/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins.functions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\b&\u0018\u00002\u00020\u0001:\u0004*+,-B3\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fB1\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0000H\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0000H\u0017\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u0019R\u001a\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001f\u001a\u0004\b\u0007\u0010 R\u001c\u0010\t\u001a\u0004\u0018\u00010\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010!\u001a\u0004\b\"\u0010#R\u001a\u0010\n\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u001f\u001a\u0004\b\n\u0010 R\u0016\u0010%\u001a\u0004\u0018\u00010\u00048WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0019R\u0016\u0010'\u001a\u0004\u0018\u00010\u00048WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0019R\u0014\u0010)\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010 "}, d2={"Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "", "classNamePrefix", "", "isReflectType", "Lorg/jetbrains/kotlin/name/ClassId;", "annotationOnInvokeClassId", "isInlineable", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;ZLorg/jetbrains/kotlin/name/ClassId;Z)V", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;Lorg/jetbrains/kotlin/name/ClassId;ZZ)V", "nonReflectKind", "()Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "reflectKind", "", "arity", "Lorg/jetbrains/kotlin/name/Name;", "numberedClassName", "(I)Lorg/jetbrains/kotlin/name/Name;", "numberedClassId", "(I)Lorg/jetbrains/kotlin/name/ClassId;", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "Ljava/lang/String;", "getClassNamePrefix", "Z", "()Z", "Lorg/jetbrains/kotlin/name/ClassId;", "getAnnotationOnInvokeClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getPrefixForTypeRender", "prefixForTypeRender", "getSerializeAsFunctionWithAnnotationUntil", "serializeAsFunctionWithAnnotationUntil", "getSupportsConversionFromSimpleFunctionType", "supportsConversionFromSimpleFunctionType", "Function", "SuspendFunction", "KFunction", "KSuspendFunction"})
public abstract class FunctionTypeKind {
    @NotNull
    private final FqName packageFqName;
    @NotNull
    private final String classNamePrefix;
    private final boolean isReflectType;
    @Nullable
    private final ClassId annotationOnInvokeClassId;
    private final boolean isInlineable;

    public FunctionTypeKind(@NotNull FqName packageFqName, @NotNull String classNamePrefix, boolean isReflectType, @Nullable ClassId annotationOnInvokeClassId, boolean isInlineable) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(classNamePrefix, "classNamePrefix");
        this.packageFqName = packageFqName;
        this.classNamePrefix = classNamePrefix;
        this.isReflectType = isReflectType;
        this.annotationOnInvokeClassId = annotationOnInvokeClassId;
        this.isInlineable = isInlineable;
    }

    @NotNull
    public final FqName getPackageFqName() {
        return this.packageFqName;
    }

    @NotNull
    public final String getClassNamePrefix() {
        return this.classNamePrefix;
    }

    public final boolean isReflectType() {
        return this.isReflectType;
    }

    @Nullable
    public final ClassId getAnnotationOnInvokeClassId() {
        return this.annotationOnInvokeClassId;
    }

    public final boolean isInlineable() {
        return this.isInlineable;
    }

    public FunctionTypeKind(@NotNull FqName packageFqName, @NotNull String classNamePrefix, @NotNull ClassId annotationOnInvokeClassId, boolean isReflectType, boolean isInlineable) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(classNamePrefix, "classNamePrefix");
        Intrinsics.checkNotNullParameter(annotationOnInvokeClassId, "annotationOnInvokeClassId");
        this(packageFqName, classNamePrefix, isReflectType, annotationOnInvokeClassId, isInlineable);
    }

    @Nullable
    public String getPrefixForTypeRender() {
        return null;
    }

    @Nullable
    public String getSerializeAsFunctionWithAnnotationUntil() {
        return null;
    }

    public boolean getSupportsConversionFromSimpleFunctionType() {
        return true;
    }

    @NotNull
    public FunctionTypeKind nonReflectKind() {
        if (this.isReflectType) {
            throw new IllegalStateException("Should be overridden explicitly".toString());
        }
        return this;
    }

    @NotNull
    public FunctionTypeKind reflectKind() {
        if (!this.isReflectType) {
            throw new IllegalStateException("Should be overridden explicitly".toString());
        }
        return this;
    }

    @NotNull
    public final Name numberedClassName(int arity) {
        Name name = Name.identifier(this.classNamePrefix + arity);
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        return name;
    }

    @NotNull
    public final ClassId numberedClassId(int arity) {
        return new ClassId(this.packageFqName, this.numberedClassName(arity));
    }

    @NotNull
    public String toString() {
        return this.packageFqName + '.' + this.classNamePrefix + 'N';
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0004\u001a\u00020\u0001H\u0017\u00a2\u0006\u0004\b\u0004\u0010\u0005"}, d2={"Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind$Function;", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "<init>", "()V", "reflectKind", "()Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;"})
    public static final class Function
    extends FunctionTypeKind {
        @NotNull
        public static final Function INSTANCE = new Function();

        private Function() {
            super(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, "Function", false, null, true);
        }

        @Override
        @NotNull
        public FunctionTypeKind reflectKind() {
            return KFunction.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0004\u001a\u00020\u0001H\u0017\u00a2\u0006\u0004\b\u0004\u0010\u0005"}, d2={"Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind$KFunction;", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "<init>", "()V", "nonReflectKind", "()Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;"})
    public static final class KFunction
    extends FunctionTypeKind {
        @NotNull
        public static final KFunction INSTANCE = new KFunction();

        private KFunction() {
            super(StandardNames.KOTLIN_REFLECT_FQ_NAME, "KFunction", true, null, false);
        }

        @Override
        @NotNull
        public FunctionTypeKind nonReflectKind() {
            return Function.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0004\u001a\u00020\u0001H\u0017\u00a2\u0006\u0004\b\u0004\u0010\u0005"}, d2={"Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind$KSuspendFunction;", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "<init>", "()V", "nonReflectKind", "()Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;"})
    public static final class KSuspendFunction
    extends FunctionTypeKind {
        @NotNull
        public static final KSuspendFunction INSTANCE = new KSuspendFunction();

        private KSuspendFunction() {
            super(StandardNames.KOTLIN_REFLECT_FQ_NAME, "KSuspendFunction", true, null, false);
        }

        @Override
        @NotNull
        public FunctionTypeKind nonReflectKind() {
            return SuspendFunction.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0004\u001a\u00020\u0001H\u0017\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\t\u001a\u00020\u00068WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind$SuspendFunction;", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "<init>", "()V", "reflectKind", "()Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "", "getPrefixForTypeRender", "()Ljava/lang/String;", "prefixForTypeRender"})
    public static final class SuspendFunction
    extends FunctionTypeKind {
        @NotNull
        public static final SuspendFunction INSTANCE = new SuspendFunction();

        private SuspendFunction() {
            super(StandardNames.COROUTINES_PACKAGE_FQ_NAME, "SuspendFunction", false, null, true);
        }

        @Override
        @NotNull
        public String getPrefixForTypeRender() {
            return "suspend";
        }

        @Override
        @NotNull
        public FunctionTypeKind reflectKind() {
            return KSuspendFunction.INSTANCE;
        }
    }
}

