/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKindExtractor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.BuiltInAnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.FilteredAnnotations;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributesKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0016\u001a'\u0010\u0004\u001a\u00020\u0002*\u00020\u00002\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a%\u0010\u0006\u001a\u00020\u0002*\u00020\u00002\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0005\u001a\u0015\u0010\t\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0015\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0013\u001a\u0011\u0010\u0015\u001a\u00020\u0014*\u00020\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0015\u0010\u0017\u001a\u0004\u0018\u00010\u0000*\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a\u0019\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00000\u0019*\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a\u0013\u0010\u001c\u001a\u00020\u0000*\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u001c\u0010\u0018\u001a\u001b\u0010\u001e\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a\u0019\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u0019*\u00020\u0000H\u0007\u00a2\u0006\u0004\b!\u0010\u001b\u001a!\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\u0019*\u00020\u00002\u0006\u0010\"\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b#\u0010$\u001a\u0013\u0010%\u001a\u00020\u0000*\u00020\u0000H\u0007\u00a2\u0006\u0004\b%\u0010\u0018\u001a\u0019\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00000\u0019*\u00020\u0000H\u0007\u00a2\u0006\u0004\b&\u0010\u001b\u001a\u0015\u0010(\u001a\u0004\u0018\u00010'*\u00020\u0000H\u0007\u00a2\u0006\u0004\b(\u0010)\u001a[\u00101\u001a\b\u0012\u0004\u0012\u00020 0\u00192\b\u0010*\u001a\u0004\u0018\u00010\u00002\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00000\u00192\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00000\u00192\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010\u00192\u0006\u0010.\u001a\u00020\u00002\u0006\u00100\u001a\u00020/H\u0007\u00a2\u0006\u0004\b1\u00102\u001ag\u00107\u001a\u0002062\u0006\u00100\u001a\u00020/2\u0006\u00104\u001a\u0002032\b\u0010*\u001a\u0004\u0018\u00010\u00002\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00000\u00192\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00000\u00192\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010\u00192\u0006\u0010.\u001a\u00020\u00002\b\b\u0002\u00105\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b7\u00108\u001a\u0011\u00109\u001a\u00020\u0002*\u000203\u00a2\u0006\u0004\b9\u0010:\u001a\u0013\u0010<\u001a\u00020;*\u000203H\u0007\u00a2\u0006\u0004\b<\u0010=\u001a\u001b\u0010>\u001a\u000203*\u0002032\u0006\u00100\u001a\u00020/H\u0007\u00a2\u0006\u0004\b>\u0010?\u001a#\u0010A\u001a\u000203*\u0002032\u0006\u00100\u001a\u00020/2\u0006\u0010@\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\bA\u0010B\u001a'\u0010F\u001a\u00020E2\u0006\u00100\u001a\u00020/2\u0006\u0010C\u001a\u00020\u00142\u0006\u0010D\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\bF\u0010G\u001a'\u0010H\u001a\u00020E2\u0006\u00100\u001a\u00020/2\u0006\u0010C\u001a\u00020\u00142\u0006\u0010D\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\bH\u0010G\"\u0015\u0010\u0006\u001a\u00020\u0002*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010I\"\u0015\u0010J\u001a\u00020\u0002*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010I\"\u0015\u0010K\u001a\u00020\u0002*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bK\u0010I\"\u0017\u0010M\u001a\u0004\u0018\u00010\u0010*\u00020\u00008G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010L\"\u0015\u0010N\u001a\u00020\u0002*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bN\u0010I\"\u0015\u0010O\u001a\u00020\u0002*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bO\u0010I\"\u0015\u0010P\u001a\u00020\u0002*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bP\u0010I\"\u0015\u0010Q\u001a\u00020\u0002*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010I\"\u0015\u0010R\u001a\u00020\u0002*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bR\u0010I\"\u0015\u0010S\u001a\u00020\u0002*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bS\u0010I\"\u0015\u0010T\u001a\u00020\u0002*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bT\u0010I\"\u0015\u0010U\u001a\u00020\u0002*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\bU\u0010V\"\u0015\u0010W\u001a\u00020\u0002*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bW\u0010I\"\u0015\u0010X\u001a\u00020\u0002*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bX\u0010I\"\u0015\u0010Y\u001a\u00020\u0002*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bY\u0010I\"\u0015\u0010Z\u001a\u00020\u0002*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bZ\u0010I\"\u0018\u0010[\u001a\u00020\u0002*\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b[\u0010I"}, d2={"Lorg/jetbrains/kotlin/types/KotlinType;", "Lkotlin/Function1;", "", "predicate", "isTypeOrSubtypeOf", "(Lorg/jetbrains/kotlin/types/KotlinType;Lkotlin/jvm/functions/Function1;)Z", "isFunctionTypeOrSubtype", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "isBuiltinFunctionClass", "(Lorg/jetbrains/kotlin/name/ClassId;)Z", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "fqName", "isNumberedFunctionClassFqName", "(Lorg/jetbrains/kotlin/name/FqNameUnsafe;)Z", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "getFunctionTypeKind", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "(Lorg/jetbrains/kotlin/name/FqNameUnsafe;)Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "", "contextFunctionTypeParamsCount", "(Lorg/jetbrains/kotlin/types/KotlinType;)I", "getReceiverTypeFromFunctionType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/KotlinType;", "", "getContextReceiverTypesFromFunctionType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Ljava/util/List;", "getReturnTypeFromFunctionType", "newReturnType", "replaceReturnType", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/types/TypeProjection;", "getValueParameterTypesFromFunctionType", "isCallableTypeWithExtension", "getValueParameterTypesFromCallableReflectionType", "(Lorg/jetbrains/kotlin/types/KotlinType;Z)Ljava/util/List;", "extractFunctionalTypeFromSupertypes", "getPureArgumentsForFunctionalTypeOrSubtype", "Lorg/jetbrains/kotlin/name/Name;", "extractParameterNameFromFunctionTypeArgument", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/name/Name;", "receiverType", "contextReceiverTypes", "parameterTypes", "parameterNames", "returnType", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "builtIns", "getFunctionTypeArgumentProjections", "(Lorg/jetbrains/kotlin/types/KotlinType;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)Ljava/util/List;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "annotations", "suspendFunction", "Lorg/jetbrains/kotlin/types/SimpleType;", "createFunctionType", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;Lorg/jetbrains/kotlin/types/KotlinType;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/types/KotlinType;Z)Lorg/jetbrains/kotlin/types/SimpleType;", "hasExtensionFunctionAnnotation", "(Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;)Z", "Lorg/jetbrains/kotlin/descriptors/annotations/FilteredAnnotations;", "withoutExtensionFunctionAnnotation", "(Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;)Lorg/jetbrains/kotlin/descriptors/annotations/FilteredAnnotations;", "withExtensionFunctionAnnotation", "(Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "contextReceiversCount", "withContextReceiversFunctionAnnotation", "(Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;I)Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "parameterCount", "isSuspendFunction", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getFunctionDescriptor", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;IZ)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getKFunctionDescriptor", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "isSuspendFunctionTypeOrSubtype", "isBuiltinFunctionalTypeOrSubtype", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "functionTypeKind", "isFunctionType", "isKFunctionType", "isSuspendFunctionType", "isKSuspendFunctionType", "isFunctionOrSuspendFunctionType", "isFunctionOrKFunctionTypeWithAnySuspendability", "isBuiltinFunctionalType", "isBuiltinFunctionalClassDescriptor", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "isNonExtensionFunctionType", "isExtensionFunctionType", "isSuspendExtensionFunctionType", "isBuiltinExtensionFunctionalType", "isTypeAnnotatedWithExtensionFunctionType"})
public final class FunctionTypesKt {
    private static final boolean isTypeOrSubtypeOf(KotlinType $this$isTypeOrSubtypeOf, Function1<? super KotlinType, Boolean> predicate) {
        return predicate.invoke($this$isTypeOrSubtypeOf) != false || (Boolean)DFS.dfsFromNode($this$isTypeOrSubtypeOf, FunctionTypesKt::isTypeOrSubtypeOf$lambda$0, new DFS.VisitedWithSet(), new DFS.AbstractNodeHandler<KotlinType, Boolean>(predicate){
            private boolean result;
            final /* synthetic */ Function1<KotlinType, Boolean> $predicate;
            {
                this.$predicate = $predicate;
            }

            public boolean beforeChildren(KotlinType current) {
                Intrinsics.checkNotNullParameter(current, "current");
                if (this.$predicate.invoke(current).booleanValue()) {
                    this.result = true;
                }
                return !this.result;
            }

            public Boolean result() {
                return this.result;
            }
        }) != false;
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull KotlinType $this$isFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter($this$isFunctionTypeOrSubtype, "<this>");
        return FunctionTypesKt.isTypeOrSubtypeOf($this$isFunctionTypeOrSubtype, FunctionTypesKt::_get_isFunctionTypeOrSubtype_$lambda$1);
    }

    public static final boolean isSuspendFunctionTypeOrSubtype(@NotNull KotlinType $this$isSuspendFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter($this$isSuspendFunctionTypeOrSubtype, "<this>");
        return FunctionTypesKt.isTypeOrSubtypeOf($this$isSuspendFunctionTypeOrSubtype, FunctionTypesKt::_get_isSuspendFunctionTypeOrSubtype_$lambda$2);
    }

    public static final boolean isBuiltinFunctionalTypeOrSubtype(@NotNull KotlinType $this$isBuiltinFunctionalTypeOrSubtype) {
        Intrinsics.checkNotNullParameter($this$isBuiltinFunctionalTypeOrSubtype, "<this>");
        return FunctionTypesKt.isTypeOrSubtypeOf($this$isBuiltinFunctionalTypeOrSubtype, FunctionTypesKt::_get_isBuiltinFunctionalTypeOrSubtype_$lambda$3);
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull KotlinType $this$isFunctionTypeOrSubtype, @NotNull Function1<? super KotlinType, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$isFunctionTypeOrSubtype, "<this>");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        return FunctionTypesKt.isTypeOrSubtypeOf($this$isFunctionTypeOrSubtype, arg_0 -> FunctionTypesKt.isFunctionTypeOrSubtype$lambda$4(predicate, arg_0));
    }

    @Nullable
    public static final FunctionTypeKind getFunctionTypeKind(@NotNull KotlinType $this$functionTypeKind) {
        Intrinsics.checkNotNullParameter($this$functionTypeKind, "<this>");
        ClassifierDescriptor classifierDescriptor = $this$functionTypeKind.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? FunctionTypesKt.getFunctionTypeKind(classifierDescriptor) : null;
    }

    public static final boolean isFunctionType(@NotNull KotlinType $this$isFunctionType) {
        Intrinsics.checkNotNullParameter($this$isFunctionType, "<this>");
        return Intrinsics.areEqual(FunctionTypesKt.getFunctionTypeKind($this$isFunctionType), FunctionTypeKind.Function.INSTANCE);
    }

    public static final boolean isKFunctionType(@NotNull KotlinType $this$isKFunctionType) {
        Intrinsics.checkNotNullParameter($this$isKFunctionType, "<this>");
        return Intrinsics.areEqual(FunctionTypesKt.getFunctionTypeKind($this$isKFunctionType), FunctionTypeKind.KFunction.INSTANCE);
    }

    public static final boolean isSuspendFunctionType(@NotNull KotlinType $this$isSuspendFunctionType) {
        Intrinsics.checkNotNullParameter($this$isSuspendFunctionType, "<this>");
        return Intrinsics.areEqual(FunctionTypesKt.getFunctionTypeKind($this$isSuspendFunctionType), FunctionTypeKind.SuspendFunction.INSTANCE);
    }

    public static final boolean isKSuspendFunctionType(@NotNull KotlinType $this$isKSuspendFunctionType) {
        Intrinsics.checkNotNullParameter($this$isKSuspendFunctionType, "<this>");
        return Intrinsics.areEqual(FunctionTypesKt.getFunctionTypeKind($this$isKSuspendFunctionType), FunctionTypeKind.KSuspendFunction.INSTANCE);
    }

    public static final boolean isFunctionOrSuspendFunctionType(@NotNull KotlinType $this$isFunctionOrSuspendFunctionType) {
        Intrinsics.checkNotNullParameter($this$isFunctionOrSuspendFunctionType, "<this>");
        return FunctionTypesKt.isFunctionType($this$isFunctionOrSuspendFunctionType) || FunctionTypesKt.isSuspendFunctionType($this$isFunctionOrSuspendFunctionType);
    }

    public static final boolean isFunctionOrKFunctionTypeWithAnySuspendability(@NotNull KotlinType $this$isFunctionOrKFunctionTypeWithAnySuspendability) {
        Intrinsics.checkNotNullParameter($this$isFunctionOrKFunctionTypeWithAnySuspendability, "<this>");
        return FunctionTypesKt.isFunctionType($this$isFunctionOrKFunctionTypeWithAnySuspendability) || FunctionTypesKt.isSuspendFunctionType($this$isFunctionOrKFunctionTypeWithAnySuspendability) || FunctionTypesKt.isKFunctionType($this$isFunctionOrKFunctionTypeWithAnySuspendability) || FunctionTypesKt.isKSuspendFunctionType($this$isFunctionOrKFunctionTypeWithAnySuspendability);
    }

    public static final boolean isBuiltinFunctionalType(@NotNull KotlinType $this$isBuiltinFunctionalType) {
        Intrinsics.checkNotNullParameter($this$isBuiltinFunctionalType, "<this>");
        ClassifierDescriptor classifierDescriptor = $this$isBuiltinFunctionalType.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? FunctionTypesKt.isBuiltinFunctionalClassDescriptor(classifierDescriptor) : false;
    }

    public static final boolean isBuiltinFunctionalClassDescriptor(@NotNull DeclarationDescriptor $this$isBuiltinFunctionalClassDescriptor) {
        Intrinsics.checkNotNullParameter($this$isBuiltinFunctionalClassDescriptor, "<this>");
        FunctionTypeKind functionalClassKind = FunctionTypesKt.getFunctionTypeKind($this$isBuiltinFunctionalClassDescriptor);
        return Intrinsics.areEqual(functionalClassKind, FunctionTypeKind.Function.INSTANCE) || Intrinsics.areEqual(functionalClassKind, FunctionTypeKind.SuspendFunction.INSTANCE);
    }

    public static final boolean isBuiltinFunctionClass(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        if (!classId.startsWith(StandardNames.BUILT_INS_PACKAGE_NAME)) {
            return false;
        }
        FunctionTypeKind kind = FunctionTypesKt.getFunctionTypeKind(classId.asSingleFqName().toUnsafe());
        return Intrinsics.areEqual(kind, FunctionTypeKind.Function.INSTANCE) || Intrinsics.areEqual(kind, FunctionTypeKind.SuspendFunction.INSTANCE);
    }

    public static final boolean isNonExtensionFunctionType(@NotNull KotlinType $this$isNonExtensionFunctionType) {
        Intrinsics.checkNotNullParameter($this$isNonExtensionFunctionType, "<this>");
        return FunctionTypesKt.isFunctionType($this$isNonExtensionFunctionType) && !FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($this$isNonExtensionFunctionType);
    }

    public static final boolean isExtensionFunctionType(@NotNull KotlinType $this$isExtensionFunctionType) {
        Intrinsics.checkNotNullParameter($this$isExtensionFunctionType, "<this>");
        return FunctionTypesKt.isFunctionType($this$isExtensionFunctionType) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($this$isExtensionFunctionType);
    }

    public static final boolean isSuspendExtensionFunctionType(@NotNull KotlinType $this$isSuspendExtensionFunctionType) {
        Intrinsics.checkNotNullParameter($this$isSuspendExtensionFunctionType, "<this>");
        return FunctionTypesKt.isSuspendFunctionType($this$isSuspendExtensionFunctionType) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($this$isSuspendExtensionFunctionType);
    }

    public static final boolean isBuiltinExtensionFunctionalType(@NotNull KotlinType $this$isBuiltinExtensionFunctionalType) {
        Intrinsics.checkNotNullParameter($this$isBuiltinExtensionFunctionalType, "<this>");
        return FunctionTypesKt.isBuiltinFunctionalType($this$isBuiltinExtensionFunctionalType) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($this$isBuiltinExtensionFunctionalType);
    }

    private static final boolean isTypeAnnotatedWithExtensionFunctionType(KotlinType $this$isTypeAnnotatedWithExtensionFunctionType) {
        return $this$isTypeAnnotatedWithExtensionFunctionType.getAnnotations().findAnnotation(StandardNames.FqNames.extensionFunctionType) != null;
    }

    public static final boolean isNumberedFunctionClassFqName(@NotNull FqNameUnsafe fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return fqName2.startsWith(StandardNames.BUILT_INS_PACKAGE_NAME) && Intrinsics.areEqual(FunctionTypesKt.getFunctionTypeKind(fqName2), FunctionTypeKind.Function.INSTANCE);
    }

    @Nullable
    public static final FunctionTypeKind getFunctionTypeKind(@NotNull DeclarationDescriptor $this$getFunctionTypeKind) {
        Intrinsics.checkNotNullParameter($this$getFunctionTypeKind, "<this>");
        if (!($this$getFunctionTypeKind instanceof ClassDescriptor)) {
            return null;
        }
        if (!KotlinBuiltIns.isUnderKotlinPackage($this$getFunctionTypeKind)) {
            return null;
        }
        return FunctionTypesKt.getFunctionTypeKind(DescriptorUtilsKt.getFqNameUnsafe($this$getFunctionTypeKind));
    }

    private static final FunctionTypeKind getFunctionTypeKind(FqNameUnsafe $this$getFunctionTypeKind) {
        if (!$this$getFunctionTypeKind.isSafe() || $this$getFunctionTypeKind.isRoot()) {
            return null;
        }
        FunctionTypeKindExtractor functionTypeKindExtractor = FunctionTypeKindExtractor.Companion.getDefault();
        FqName fqName2 = $this$getFunctionTypeKind.toSafe().parent();
        String string = $this$getFunctionTypeKind.shortName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        return functionTypeKindExtractor.getFunctionalClassKind(fqName2, string);
    }

    public static final int contextFunctionTypeParamsCount(@NotNull KotlinType $this$contextFunctionTypeParamsCount) {
        Intrinsics.checkNotNullParameter($this$contextFunctionTypeParamsCount, "<this>");
        AnnotationDescriptor annotationDescriptor = $this$contextFunctionTypeParamsCount.getAnnotations().findAnnotation(StandardNames.FqNames.contextFunctionTypeParams);
        if (annotationDescriptor == null) {
            return 0;
        }
        AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
        ConstantValue<?> constantValue = MapsKt.getValue(annotationDescriptor2.getAllValueArguments(), StandardNames.CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME);
        Intrinsics.checkNotNull(constantValue, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.constants.IntValue");
        return ((Number)((IntValue)constantValue).getValue()).intValue();
    }

    @Nullable
    public static final KotlinType getReceiverTypeFromFunctionType(@NotNull KotlinType $this$getReceiverTypeFromFunctionType) {
        Intrinsics.checkNotNullParameter($this$getReceiverTypeFromFunctionType, "<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($this$getReceiverTypeFromFunctionType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Not a function type: " + $this$getReceiverTypeFromFunctionType;
            throw new AssertionError((Object)string);
        }
        if (!FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($this$getReceiverTypeFromFunctionType)) {
            return null;
        }
        int index2 = FunctionTypesKt.contextFunctionTypeParamsCount($this$getReceiverTypeFromFunctionType);
        return $this$getReceiverTypeFromFunctionType.getArguments().get(index2).getType();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinType> getContextReceiverTypesFromFunctionType(@NotNull KotlinType $this$getContextReceiverTypesFromFunctionType) {
        List list;
        Intrinsics.checkNotNullParameter($this$getContextReceiverTypesFromFunctionType, "<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($this$getContextReceiverTypesFromFunctionType);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FunctionTypesKt$getContextReceiverTypesFromFunctionType$22 = false;
            String $i$a$-assert-FunctionTypesKt$getContextReceiverTypesFromFunctionType$22 = "Not a function type: " + $this$getContextReceiverTypesFromFunctionType;
            throw new AssertionError((Object)$i$a$-assert-FunctionTypesKt$getContextReceiverTypesFromFunctionType$22);
        }
        int contextReceiversCount = FunctionTypesKt.contextFunctionTypeParamsCount($this$getContextReceiverTypesFromFunctionType);
        if (contextReceiversCount == 0) {
            list = kotlin.collections.CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$getContextReceiverTypesFromFunctionType.getArguments().subList(0, contextReceiversCount);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getType());
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public static final KotlinType getReturnTypeFromFunctionType(@NotNull KotlinType $this$getReturnTypeFromFunctionType) {
        Intrinsics.checkNotNullParameter($this$getReturnTypeFromFunctionType, "<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($this$getReturnTypeFromFunctionType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Not a function type: " + $this$getReturnTypeFromFunctionType;
            throw new AssertionError((Object)string);
        }
        KotlinType kotlinType = kotlin.collections.CollectionsKt.last($this$getReturnTypeFromFunctionType.getArguments()).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        return kotlinType;
    }

    @NotNull
    public static final KotlinType replaceReturnType(@NotNull KotlinType $this$replaceReturnType, @NotNull KotlinType newReturnType) {
        List list;
        Intrinsics.checkNotNullParameter($this$replaceReturnType, "<this>");
        Intrinsics.checkNotNullParameter(newReturnType, "newReturnType");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($this$replaceReturnType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Not a function type: " + $this$replaceReturnType;
            throw new AssertionError((Object)string);
        }
        List $this$replaceReturnType_u24lambda_u2410 = list = kotlin.collections.CollectionsKt.toMutableList((Collection)$this$replaceReturnType.getArguments());
        boolean bl3 = false;
        $this$replaceReturnType_u24lambda_u2410.set($this$replaceReturnType_u24lambda_u2410.size() - 1, new TypeProjectionImpl(newReturnType));
        List argumentsWithNewReturnType = list;
        return TypeSubstitutionKt.replace$default($this$replaceReturnType, argumentsWithNewReturnType, null, null, 6, null);
    }

    @NotNull
    public static final List<TypeProjection> getValueParameterTypesFromFunctionType(@NotNull KotlinType $this$getValueParameterTypesFromFunctionType) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$getValueParameterTypesFromFunctionType, "<this>");
        boolean bl2 = FunctionTypesKt.isBuiltinFunctionalType($this$getValueParameterTypesFromFunctionType);
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-FunctionTypesKt$getValueParameterTypesFromFunctionType$32 = false;
            String $i$a$-assert-FunctionTypesKt$getValueParameterTypesFromFunctionType$32 = "Not a function type: " + $this$getValueParameterTypesFromFunctionType;
            throw new AssertionError((Object)$i$a$-assert-FunctionTypesKt$getValueParameterTypesFromFunctionType$32);
        }
        List<TypeProjection> arguments2 = $this$getValueParameterTypesFromFunctionType.getArguments();
        int first2 = FunctionTypesKt.contextFunctionTypeParamsCount($this$getValueParameterTypesFromFunctionType) + (FunctionTypesKt.isBuiltinExtensionFunctionalType($this$getValueParameterTypesFromFunctionType) ? 1 : 0);
        int last2 = arguments2.size() - 1;
        boolean bl3 = bl = first2 <= last2;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Not an exact function type: " + $this$getValueParameterTypesFromFunctionType;
            throw new AssertionError((Object)string);
        }
        return arguments2.subList(first2, last2);
    }

    @NotNull
    public static final List<TypeProjection> getValueParameterTypesFromCallableReflectionType(@NotNull KotlinType $this$getValueParameterTypesFromCallableReflectionType, boolean isCallableTypeWithExtension) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$getValueParameterTypesFromCallableReflectionType, "<this>");
        boolean bl2 = ReflectionTypes.Companion.isKCallableType($this$getValueParameterTypesFromCallableReflectionType);
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-FunctionTypesKt$getValueParameterTypesFromCallableReflectionType$32 = false;
            String $i$a$-assert-FunctionTypesKt$getValueParameterTypesFromCallableReflectionType$32 = "Not a callable reflection type: " + $this$getValueParameterTypesFromCallableReflectionType;
            throw new AssertionError((Object)$i$a$-assert-FunctionTypesKt$getValueParameterTypesFromCallableReflectionType$32);
        }
        List<TypeProjection> arguments2 = $this$getValueParameterTypesFromCallableReflectionType.getArguments();
        int first2 = isCallableTypeWithExtension ? 1 : 0;
        int last2 = arguments2.size() - 1;
        boolean bl3 = bl = first2 <= last2;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Not an exact function type: " + $this$getValueParameterTypesFromCallableReflectionType;
            throw new AssertionError((Object)string);
        }
        return arguments2.subList(first2, last2);
    }

    @NotNull
    public static final KotlinType extractFunctionalTypeFromSupertypes(@NotNull KotlinType $this$extractFunctionalTypeFromSupertypes) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter($this$extractFunctionalTypeFromSupertypes, "<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalTypeOrSubtype($this$extractFunctionalTypeFromSupertypes);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FunctionTypesKt$extractFunctionalTypeFromSupertypes$22 = false;
            String $i$a$-assert-FunctionTypesKt$extractFunctionalTypeFromSupertypes$22 = "Not a function type or subtype: " + $this$extractFunctionalTypeFromSupertypes;
            throw new AssertionError((Object)$i$a$-assert-FunctionTypesKt$extractFunctionalTypeFromSupertypes$22);
        }
        if (FunctionTypesKt.isBuiltinFunctionalType($this$extractFunctionalTypeFromSupertypes)) {
            kotlinType = $this$extractFunctionalTypeFromSupertypes;
        } else {
            Object element$iv2;
            block4: {
                Iterable $this$first$iv = TypeUtilsKt.supertypes($this$extractFunctionalTypeFromSupertypes);
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    KotlinType it = (KotlinType)element$iv2;
                    boolean bl2 = false;
                    if (!FunctionTypesKt.isBuiltinFunctionalType(it)) continue;
                    break block4;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            kotlinType = (KotlinType)element$iv2;
        }
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinType> getPureArgumentsForFunctionalTypeOrSubtype(@NotNull KotlinType $this$getPureArgumentsForFunctionalTypeOrSubtype) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getPureArgumentsForFunctionalTypeOrSubtype, "<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalTypeOrSubtype($this$getPureArgumentsForFunctionalTypeOrSubtype);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FunctionTypesKt$getPureArgumentsForFunctionalTypeOrSubtype$22 = false;
            String $i$a$-assert-FunctionTypesKt$getPureArgumentsForFunctionalTypeOrSubtype$22 = "Not a function type or subtype: " + $this$getPureArgumentsForFunctionalTypeOrSubtype;
            throw new AssertionError((Object)$i$a$-assert-FunctionTypesKt$getPureArgumentsForFunctionalTypeOrSubtype$22);
        }
        Iterable $this$map$iv = kotlin.collections.CollectionsKt.dropLast(FunctionTypesKt.extractFunctionalTypeFromSupertypes($this$getPureArgumentsForFunctionalTypeOrSubtype).getArguments(), 1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getType());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final Name extractParameterNameFromFunctionTypeArgument(@NotNull KotlinType $this$extractParameterNameFromFunctionTypeArgument) {
        Object object;
        block5: {
            block4: {
                Object object2;
                StringValue stringValue;
                Intrinsics.checkNotNullParameter($this$extractParameterNameFromFunctionTypeArgument, "<this>");
                AnnotationDescriptor annotationDescriptor = $this$extractParameterNameFromFunctionTypeArgument.getAnnotations().findAnnotation(StandardNames.FqNames.parameterName);
                if (annotationDescriptor == null) {
                    return null;
                }
                AnnotationDescriptor annotation = annotationDescriptor;
                Object object3 = kotlin.collections.CollectionsKt.singleOrNull((Iterable)annotation.getAllValueArguments().values());
                StringValue stringValue2 = stringValue = object3 instanceof StringValue ? (StringValue)object3 : null;
                if (stringValue == null || (object3 = (String)stringValue.getValue()) == null) break block4;
                Object it = object2 = object3;
                boolean bl = false;
                Object object4 = object = Name.isValidIdentifier(it) ? object2 : null;
                if (object != null) break block5;
            }
            return null;
        }
        Object name = object;
        return Name.identifier(name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> getFunctionTypeArgumentProjections(@Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> contextReceiverTypes, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType, @NotNull KotlinBuiltIns builtIns) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(contextReceiverTypes, "contextReceiverTypes");
        Intrinsics.checkNotNullParameter(parameterTypes, "parameterTypes");
        Intrinsics.checkNotNullParameter(returnType, "returnType");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        ArrayList<TypeProjection> arguments2 = new ArrayList<TypeProjection>(parameterTypes.size() + contextReceiverTypes.size() + (receiverType != null ? 1 : 0) + 1);
        Iterable iterable = contextReceiverTypes;
        Collection<TypeProjection> collection = arguments2;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(TypeUtilsKt.asTypeProjection((KotlinType)it));
        }
        ((ArrayList)collection).addAll((List)destination$iv$iv);
        KotlinType kotlinType = receiverType;
        CollectionsKt.addIfNotNull((Collection)arguments2, kotlinType != null ? TypeUtilsKt.asTypeProjection(kotlinType) : null);
        Iterable $this$mapIndexedTo$iv = parameterTypes;
        boolean $i$f$mapIndexedTo = false;
        int index$iv = 0;
        for (Object item$iv : $this$mapIndexedTo$iv) {
            KotlinType kotlinType2;
            void type2;
            List<Name> name;
            List<Name> list;
            void index2;
            int n2;
            Object item$iv$iv;
            Collection collection3 = arguments2;
            if ((n2 = index$iv++) < 0) {
                kotlin.collections.CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (KotlinType)item$iv;
            int it = n2;
            collection = collection3;
            boolean bl = false;
            List<Name> list2 = parameterNames;
            if (list2 != null && (list2 = list2.get((int)index2)) != null) {
                List<Name> list3;
                List<Name> it2 = list3 = list2;
                boolean bl2 = false;
                list = !((Name)((Object)it2)).isSpecial() ? list3 : null;
            } else {
                list = name = null;
            }
            if (name != null) {
                String string = ((Name)((Object)name)).asString();
                Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
                BuiltInAnnotationDescriptor parameterNameAnnotation = new BuiltInAnnotationDescriptor(builtIns, StandardNames.FqNames.parameterName, MapsKt.mapOf(TuplesKt.to(StandardNames.NAME, new StringValue(string))), false, 8, null);
                kotlinType2 = TypeUtilsKt.replaceAnnotations((KotlinType)type2, Annotations.Companion.create(kotlin.collections.CollectionsKt.plus((Iterable)type2.getAnnotations(), parameterNameAnnotation)));
            } else {
                kotlinType2 = type2;
            }
            void typeToUse = kotlinType2;
            collection.add(TypeUtilsKt.asTypeProjection((KotlinType)typeToUse));
        }
        arguments2.add(TypeUtilsKt.asTypeProjection(returnType));
        return arguments2;
    }

    @NotNull
    public static final SimpleType createFunctionType(@NotNull KotlinBuiltIns builtIns, @NotNull Annotations annotations2, @Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> contextReceiverTypes, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType, boolean suspendFunction) {
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        Intrinsics.checkNotNullParameter(contextReceiverTypes, "contextReceiverTypes");
        Intrinsics.checkNotNullParameter(parameterTypes, "parameterTypes");
        Intrinsics.checkNotNullParameter(returnType, "returnType");
        List<TypeProjection> arguments2 = FunctionTypesKt.getFunctionTypeArgumentProjections(receiverType, contextReceiverTypes, parameterTypes, parameterNames, returnType, builtIns);
        int parameterCount = parameterTypes.size() + contextReceiverTypes.size() + (receiverType == null ? 0 : 1);
        ClassDescriptor classDescriptor = FunctionTypesKt.getFunctionDescriptor(builtIns, parameterCount, suspendFunction);
        Annotations typeAnnotations = annotations2;
        if (receiverType != null) {
            typeAnnotations = FunctionTypesKt.withExtensionFunctionAnnotation(typeAnnotations, builtIns);
        }
        if (!((Collection)contextReceiverTypes).isEmpty()) {
            typeAnnotations = FunctionTypesKt.withContextReceiversFunctionAnnotation(typeAnnotations, builtIns, contextReceiverTypes.size());
        }
        return KotlinTypeFactory.simpleNotNullType(TypeAttributesKt.toDefaultAttributes(typeAnnotations), classDescriptor, arguments2);
    }

    public static /* synthetic */ SimpleType createFunctionType$default(KotlinBuiltIns kotlinBuiltIns, Annotations annotations2, KotlinType kotlinType, List list, List list2, List list3, KotlinType kotlinType2, boolean bl, int n2, Object object) {
        if ((n2 & 0x80) != 0) {
            bl = false;
        }
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, list, list2, list3, kotlinType2, bl);
    }

    public static final boolean hasExtensionFunctionAnnotation(@NotNull Annotations $this$hasExtensionFunctionAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasExtensionFunctionAnnotation, "<this>");
        return $this$hasExtensionFunctionAnnotation.hasAnnotation(StandardNames.FqNames.extensionFunctionType);
    }

    @NotNull
    public static final FilteredAnnotations withoutExtensionFunctionAnnotation(@NotNull Annotations $this$withoutExtensionFunctionAnnotation) {
        Intrinsics.checkNotNullParameter($this$withoutExtensionFunctionAnnotation, "<this>");
        return new FilteredAnnotations($this$withoutExtensionFunctionAnnotation, true, FunctionTypesKt::withoutExtensionFunctionAnnotation$lambda$23);
    }

    @NotNull
    public static final Annotations withExtensionFunctionAnnotation(@NotNull Annotations $this$withExtensionFunctionAnnotation, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter($this$withExtensionFunctionAnnotation, "<this>");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        return $this$withExtensionFunctionAnnotation.hasAnnotation(StandardNames.FqNames.extensionFunctionType) ? $this$withExtensionFunctionAnnotation : Annotations.Companion.create(kotlin.collections.CollectionsKt.plus((Iterable)$this$withExtensionFunctionAnnotation, new BuiltInAnnotationDescriptor(builtIns, StandardNames.FqNames.extensionFunctionType, MapsKt.emptyMap(), false, 8, null)));
    }

    @NotNull
    public static final Annotations withContextReceiversFunctionAnnotation(@NotNull Annotations $this$withContextReceiversFunctionAnnotation, @NotNull KotlinBuiltIns builtIns, int contextReceiversCount) {
        Intrinsics.checkNotNullParameter($this$withContextReceiversFunctionAnnotation, "<this>");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        return $this$withContextReceiversFunctionAnnotation.hasAnnotation(StandardNames.FqNames.contextFunctionTypeParams) ? $this$withContextReceiversFunctionAnnotation : Annotations.Companion.create(kotlin.collections.CollectionsKt.plus((Iterable)$this$withContextReceiversFunctionAnnotation, new BuiltInAnnotationDescriptor(builtIns, StandardNames.FqNames.contextFunctionTypeParams, MapsKt.mapOf(TuplesKt.to(StandardNames.CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME, new IntValue(contextReceiversCount))), false, 8, null)));
    }

    @NotNull
    public static final ClassDescriptor getFunctionDescriptor(@NotNull KotlinBuiltIns builtIns, int parameterCount, boolean isSuspendFunction) {
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        ClassDescriptor classDescriptor = isSuspendFunction ? builtIns.getSuspendFunction(parameterCount) : builtIns.getFunction(parameterCount);
        Intrinsics.checkNotNull(classDescriptor);
        return classDescriptor;
    }

    @NotNull
    public static final ClassDescriptor getKFunctionDescriptor(@NotNull KotlinBuiltIns builtIns, int parameterCount, boolean isSuspendFunction) {
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        ClassDescriptor classDescriptor = isSuspendFunction ? builtIns.getKSuspendFunction(parameterCount) : builtIns.getKFunction(parameterCount);
        Intrinsics.checkNotNull(classDescriptor);
        return classDescriptor;
    }

    @NotNull
    public static final SimpleType createFunctionType(@NotNull KotlinBuiltIns builtIns, @NotNull Annotations annotations2, @Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> contextReceiverTypes, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType) {
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        Intrinsics.checkNotNullParameter(contextReceiverTypes, "contextReceiverTypes");
        Intrinsics.checkNotNullParameter(parameterTypes, "parameterTypes");
        Intrinsics.checkNotNullParameter(returnType, "returnType");
        return FunctionTypesKt.createFunctionType$default(builtIns, annotations2, receiverType, contextReceiverTypes, parameterTypes, parameterNames, returnType, false, 128, null);
    }

    private static final Iterable isTypeOrSubtypeOf$lambda$0(KotlinType it) {
        return it.getConstructor().getSupertypes();
    }

    private static final boolean _get_isFunctionTypeOrSubtype_$lambda$1(KotlinType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return FunctionTypesKt.isFunctionType(it);
    }

    private static final boolean _get_isSuspendFunctionTypeOrSubtype_$lambda$2(KotlinType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return FunctionTypesKt.isSuspendFunctionType(it);
    }

    private static final boolean _get_isBuiltinFunctionalTypeOrSubtype_$lambda$3(KotlinType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return FunctionTypesKt.isBuiltinFunctionalType(it);
    }

    private static final boolean isFunctionTypeOrSubtype$lambda$4(Function1 $predicate, KotlinType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return FunctionTypesKt.isFunctionType(it) && (Boolean)$predicate.invoke(it) != false;
    }

    private static final boolean withoutExtensionFunctionAnnotation$lambda$23(FqName it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !Intrinsics.areEqual(it, StandardNames.FqNames.extensionFunctionType);
    }
}

