/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.finder;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.finder.KtLightPackage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0015J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0002J&\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0002J&\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0002JB\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001a2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 H\u0002J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J#\u0010(\u001a\b\u0012\u0004\u0012\u00020&0\u00132\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010)J#\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010+J\u001e\u0010,\u001a\u00020\u00172\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0.2\u0006\u0010/\u001a\u00020\u0011H\u0002J#\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00132\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u00102J\u001e\u00103\u001a\b\u0012\u0004\u0012\u000201042\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder;", "Lcom/intellij/psi/PsiElementFinder;", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinFinderMarker;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "psiManager", "Lcom/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "kotlinAsJavaSupport", "Lorg/jetbrains/kotlin/asJava/KotlinAsJavaSupport;", "findClass", "Lcom/intellij/psi/PsiClass;", "qualifiedName", "", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findClasses", "", "qualifiedNameString", "(Ljava/lang/String;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiClass;", "findClassesAndObjects", "", "Lorg/jetbrains/kotlin/name/FqName;", "answer", "", "findInterfaceDefaultImpls", "findRepeatableAnnotationContainer", "findSyntheticInnerClass", "syntheticName", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "", "getClassNames", "", "psiPackage", "Lcom/intellij/psi/PsiPackage;", "findPackage", "getSubPackages", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiPackage;", "getClasses", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiClass;", "sortByPreferenceToSourceFile", "list", "Lcom/intellij/util/SmartList;", "searchScope", "getPackageFiles", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiFile;", "getPackageFilesFilter", "Lcom/intellij/openapi/util/Condition;", "Companion", "light-classes-base"})
public final class JavaElementFinder
extends PsiElementFinder
implements KotlinFinderMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PsiManager psiManager;
    @NotNull
    private final KotlinAsJavaSupport kotlinAsJavaSupport;

    public JavaElementFinder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.project = project;
        PsiManager psiManager = PsiManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue(psiManager, "getInstance(...)");
        this.psiManager = psiManager;
        this.kotlinAsJavaSupport = KotlinAsJavaSupport.Companion.getInstance(this.project);
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return ArraysKt.firstOrNull(this.findClasses(qualifiedName2, scope2));
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedNameString, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(qualifiedNameString, "qualifiedNameString");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            Intrinsics.checkNotNullExpressionValue(PsiClass.EMPTY_ARRAY, "EMPTY_ARRAY");
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName qualifiedName2 = new FqName(qualifiedNameString);
        this.findClassesAndObjects(qualifiedName2, scope2, (List<PsiClass>)answer);
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClasses(qualifiedName2, scope2));
        answer.addAll(this.kotlinAsJavaSupport.getKotlinInternalClasses(qualifiedName2, scope2));
        this.sortByPreferenceToSourceFile(answer, scope2);
        Collection $this$toTypedArray$iv = answer;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiClass[0]);
    }

    private final void findClassesAndObjects(FqName qualifiedName2, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findInterfaceDefaultImpls(qualifiedName2, scope2, answer);
        this.findRepeatableAnnotationContainer(qualifiedName2, scope2, answer);
        Collection<KtClassOrObject> classOrObjectDeclarations = this.kotlinAsJavaSupport.findClassOrObjectDeclarations(qualifiedName2, scope2);
        for (KtClassOrObject declaration : classOrObjectDeclarations) {
            KtLightClass lightClass;
            if (declaration instanceof KtEnumEntry || (lightClass = this.kotlinAsJavaSupport.getLightClass(declaration)) == null) continue;
            answer.add(lightClass);
        }
    }

    private final void findInterfaceDefaultImpls(FqName qualifiedName2, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findSyntheticInnerClass(qualifiedName2, "DefaultImpls", scope2, answer, JavaElementFinder::findInterfaceDefaultImpls$lambda$0);
    }

    private final void findRepeatableAnnotationContainer(FqName qualifiedName2, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findSyntheticInnerClass(qualifiedName2, "Container", scope2, answer, JavaElementFinder::findRepeatableAnnotationContainer$lambda$1);
    }

    private final void findSyntheticInnerClass(FqName qualifiedName2, String syntheticName, GlobalSearchScope scope2, List<PsiClass> answer, Function1<? super KtClassOrObject, Boolean> predicate) {
        if (qualifiedName2.isRoot() || !Intrinsics.areEqual(qualifiedName2.shortName().asString(), syntheticName)) {
            return;
        }
        for (KtClassOrObject classOrObject : this.kotlinAsJavaSupport.findClassOrObjectDeclarations(qualifiedName2.parent(), scope2)) {
            PsiClass implsClass;
            KtLightClass interfaceClass;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            if (!predicate.invoke(classOrObject).booleanValue() || this.kotlinAsJavaSupport.getLightClass(classOrObject) == null || interfaceClass.findInnerClassByName(syntheticName, false) == null) continue;
            answer.add(implsClass);
        }
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(psiPackage, "psiPackage");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        String string = psiPackage.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue(string, "getQualifiedName(...)");
        FqName packageFQN = new FqName(string);
        Collection<KtClassOrObject> declarations2 = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        HashSet<String> answer = new HashSet<String>();
        answer.addAll(this.kotlinAsJavaSupport.getFacadeNames(packageFQN, scope2));
        for (KtClassOrObject declaration : declarations2) {
            String name;
            if (declaration.getName() == null) continue;
            answer.add(name);
        }
        return answer;
    }

    @Override
    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedNameString) {
        Intrinsics.checkNotNullParameter(qualifiedNameString, "qualifiedNameString");
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            return null;
        }
        FqName fqName2 = new FqName(qualifiedNameString);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.project);
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "allScope(...)");
        GlobalSearchScope allScope = globalSearchScope;
        return this.kotlinAsJavaSupport.packageExists(fqName2, allScope) ? (PsiPackage)new KtLightPackage(this.psiManager, fqName2, allScope) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(psiPackage, "psiPackage");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        String string = psiPackage.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue(string, "getQualifiedName(...)");
        Collection<FqName> subpackages = this.kotlinAsJavaSupport.getSubPackages(new FqName(string), scope2);
        Iterable $this$map$iv = subpackages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FqName fqName2 = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new KtLightPackage(this.psiManager, (FqName)it, scope2));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiPackage[0]);
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(psiPackage, "psiPackage");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        String string = psiPackage.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue(string, "getQualifiedName(...)");
        FqName packageFQN = new FqName(string);
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClassesInPackage(packageFQN, scope2));
        Collection<KtClassOrObject> declarations2 = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        for (KtClassOrObject declaration : declarations2) {
            KtLightClass aClass;
            if (this.kotlinAsJavaSupport.getLightClass(declaration) == null) continue;
            answer.add(aClass);
        }
        this.sortByPreferenceToSourceFile(answer, scope2);
        Collection $this$toTypedArray$iv = answer;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiClass[0]);
    }

    private final void sortByPreferenceToSourceFile(SmartList<PsiClass> list, GlobalSearchScope searchScope) {
        if (list.size() < 2) {
            return;
        }
        ContainerUtil.quickSort((List)list, Companion.byClasspathComparator(searchScope));
        List $this$sortBy$iv = list;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a2, T b2) {
                    PsiClass it = (PsiClass)a2;
                    boolean bl = false;
                    boolean bl2 = !(it instanceof ClsClassImpl);
                    it = (PsiClass)b2;
                    Comparable comparable = Boolean.valueOf(bl2);
                    bl = false;
                    return ComparisonsKt.compareValues(comparable, !(it instanceof ClsClassImpl));
                }
            });
        }
    }

    @Override
    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(psiPackage, "psiPackage");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        String string = psiPackage.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue(string, "getQualifiedName(...)");
        Collection<KtFile> $this$toTypedArray$iv = this.kotlinAsJavaSupport.findFilesForPackage(new FqName(string), scope2);
        boolean $i$f$toTypedArray = false;
        Collection<KtFile> thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiFile[0]);
    }

    @Override
    @NotNull
    public Condition<PsiFile> getPackageFilesFilter(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(psiPackage, "psiPackage");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return arg_0 -> JavaElementFinder.getPackageFilesFilter$lambda$4(psiPackage, arg_0);
    }

    private static final boolean findInterfaceDefaultImpls$lambda$0(KtClassOrObject it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof KtClass && ((KtClass)it).isInterface();
    }

    private static final boolean findRepeatableAnnotationContainer$lambda$1(KtClassOrObject it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return LightClassUtilsKt.getHasRepeatableAnnotationContainer(it);
    }

    private static final boolean getPackageFilesFilter$lambda$4(PsiPackage $psiPackage, PsiFile input) {
        return !(input instanceof KtFile) ? true : Intrinsics.areEqual($psiPackage.getQualifiedName(), ((KtFile)input).getPackageFqName().asString());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder;", "project", "Lcom/intellij/openapi/project/Project;", "byClasspathComparator", "Ljava/util/Comparator;", "Lcom/intellij/psi/PsiElement;", "Lkotlin/Comparator;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "light-classes-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaElementFinder getInstance(@NotNull Project project) {
            PsiElementFinder psiElementFinder;
            block2: {
                Intrinsics.checkNotNullParameter(project, "project");
                PsiElementFinder[] psiElementFinderArray = PsiElementFinder.EP.getPoint(project).getExtensions();
                Intrinsics.checkNotNullExpressionValue(psiElementFinderArray, "getExtensions(...)");
                PsiElementFinder[] $this$firstIsInstanceOrNull$iv = psiElementFinderArray;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (PsiElementFinder element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof JavaElementFinder)) continue;
                    psiElementFinder = element$iv;
                    break block2;
                }
                psiElementFinder = null;
            }
            JavaElementFinder javaElementFinder = (JavaElementFinder)psiElementFinder;
            if (javaElementFinder == null) {
                throw new IllegalStateException((JavaElementFinder.class.getSimpleName() + " is not found for project " + project).toString());
            }
            return javaElementFinder;
        }

        @NotNull
        public final Comparator<PsiElement> byClasspathComparator(@NotNull GlobalSearchScope searchScope) {
            Intrinsics.checkNotNullParameter(searchScope, "searchScope");
            return (arg_0, arg_1) -> Companion.byClasspathComparator$lambda$0(searchScope, arg_0, arg_1);
        }

        private static final int byClasspathComparator$lambda$0(GlobalSearchScope $searchScope, PsiElement o1, PsiElement o2) {
            VirtualFile f1 = PsiUtilCore.getVirtualFile(o1);
            VirtualFile f2 = PsiUtilCore.getVirtualFile(o2);
            return f1 == f2 ? 0 : (f1 == null ? -1 : (f2 == null ? 1 : $searchScope.compare(f2, f1)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

