/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.utils.caches;

import com.intellij.openapi.project.Project;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CachedValueBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.utils.caches.SoftCachedMap;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J#\u0010\u0016\u001a\u00028\u00012\u0006\u0010\u0017\u001a\u00028\u00002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR4\u0010\u000e\u001a(\u0012\t\u0012\u00078\u0000\u00a2\u0006\u0002\b\u0010\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u00010\u0011\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u00120\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/utils/caches/SoftCachedMapWithTrackers;", "K", "", "V", "Lorg/jetbrains/kotlin/analysis/utils/caches/SoftCachedMap;", "project", "Lcom/intellij/openapi/project/Project;", "kind", "Lorg/jetbrains/kotlin/analysis/utils/caches/SoftCachedMap$Kind;", "trackers", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/analysis/utils/caches/SoftCachedMap$Kind;[Ljava/lang/Object;)V", "[Ljava/lang/Object;", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/psi/util/CachedValue;", "Lkotlin/jvm/internal/EnhancedNullability;", "clear", "", "clearCachedValues", "getOrPut", "key", "create", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "analysis-internal-utils"})
final class SoftCachedMapWithTrackers<K, V>
extends SoftCachedMap<K, V> {
    @NotNull
    private final Project project;
    @NotNull
    private final Object[] trackers;
    @NotNull
    private final ConcurrentMap<K, CachedValue<V>> cache;

    public SoftCachedMapWithTrackers(@NotNull Project project, @NotNull SoftCachedMap.Kind kind, @NotNull Object[] trackers) {
        ConcurrentMap concurrentMap;
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(trackers, "trackers");
        this.project = project;
        this.trackers = trackers;
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                concurrentMap = ContainerUtil.createConcurrentSoftMap();
                break;
            }
            case 2: {
                concurrentMap = new ConcurrentHashMap();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ConcurrentMap concurrentMap2 = concurrentMap;
        Intrinsics.checkNotNull(concurrentMap2);
        this.cache = concurrentMap2;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void clearCachedValues() {
        Iterable $this$forEach$iv = this.cache.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CachedValue it = (CachedValue)element$iv;
            boolean bl = false;
            CachedValueBase cachedValueBase = it instanceof CachedValueBase ? (CachedValueBase)((Object)it) : null;
            if (cachedValueBase == null) continue;
            cachedValueBase.clear();
        }
    }

    @Override
    @NotNull
    public V getOrPut(@NotNull K key, @NotNull Function0<? extends V> create2) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(create2, "create");
        ConcurrentMap $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key);
        if (object == null) {
            boolean bl = false;
            CachedValue default$iv = CachedValuesManager.getManager(this.project).createCachedValue(() -> SoftCachedMapWithTrackers.getOrPut$lambda$2$lambda$1(create2, this));
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Object t2 = ((CachedValue)object).getValue();
        Intrinsics.checkNotNullExpressionValue(t2, "getValue(...)");
        return (V)t2;
    }

    private static final CachedValueProvider.Result getOrPut$lambda$2$lambda$1(Function0 $create, SoftCachedMapWithTrackers this$0) {
        Object[] objectArray = this$0.trackers;
        return new CachedValueProvider.Result($create.invoke(), Arrays.copyOf(objectArray, objectArray.length));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SoftCachedMap.Kind.values().length];
            try {
                nArray[SoftCachedMap.Kind.SOFT_KEYS_SOFT_VALUES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SoftCachedMap.Kind.STRONG_KEYS_SOFT_VALUES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

