/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.builder;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.impl.KaModuleUtilsKt;
import org.jetbrains.kotlin.analysis.project.structure.impl.KaSourceModuleImpl;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0016J\u0014\u0010\"\u001a\u00020 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$J\u000e\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0018J\u0014\u0010'\u001a\u00020 2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00180$J\b\u0010)\u001a\u00020*H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00180,H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtSourceModuleBuilder;", "Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtModuleBuilder;", "coreApplicationEnvironment", "Lcom/intellij/core/CoreApplicationEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/core/CoreApplicationEnvironment;Lcom/intellij/openapi/project/Project;)V", "moduleName", "", "getModuleName", "()Ljava/lang/String;", "setModuleName", "(Ljava/lang/String;)V", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "setLanguageVersionSettings", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "sourceRoots", "", "Ljava/nio/file/Path;", "sourceVirtualFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "setContentScope", "(Lcom/intellij/psi/search/GlobalSearchScope;)V", "addSourceRoot", "", "path", "addSourceRoots", "paths", "", "addSourceVirtualFile", "virtualFile", "addSourceVirtualFiles", "virtualFiles", "build", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;", "collectVirtualFilesByRoots", "", "analysis-api-standalone"})
public final class KtSourceModuleBuilder
extends KtModuleBuilder {
    @NotNull
    private final CoreApplicationEnvironment coreApplicationEnvironment;
    @NotNull
    private final Project project;
    public String moduleName;
    @NotNull
    private LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final List<Path> sourceRoots;
    @NotNull
    private final List<VirtualFile> sourceVirtualFiles;
    @Nullable
    private GlobalSearchScope contentScope;

    public KtSourceModuleBuilder(@NotNull CoreApplicationEnvironment coreApplicationEnvironment, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(coreApplicationEnvironment, "coreApplicationEnvironment");
        Intrinsics.checkNotNullParameter(project, "project");
        this.coreApplicationEnvironment = coreApplicationEnvironment;
        this.project = project;
        this.languageVersionSettings = new LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST, null, null, 12, null);
        this.sourceRoots = new ArrayList();
        this.sourceVirtualFiles = new ArrayList();
    }

    @NotNull
    public final String getModuleName() {
        String string = this.moduleName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("moduleName");
        return null;
    }

    public final void setModuleName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.moduleName = string;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public final void setLanguageVersionSettings(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "<set-?>");
        this.languageVersionSettings = languageVersionSettings;
    }

    @Nullable
    public final GlobalSearchScope getContentScope() {
        return this.contentScope;
    }

    public final void setContentScope(@Nullable GlobalSearchScope globalSearchScope) {
        this.contentScope = globalSearchScope;
    }

    public final void addSourceRoot(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        this.sourceRoots.add(path);
    }

    public final void addSourceRoots(@NotNull Collection<? extends Path> paths2) {
        Intrinsics.checkNotNullParameter(paths2, "paths");
        this.sourceRoots.addAll(paths2);
    }

    public final void addSourceVirtualFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter(virtualFile, "virtualFile");
        this.sourceVirtualFiles.add(virtualFile);
    }

    public final void addSourceVirtualFiles(@NotNull Collection<? extends VirtualFile> virtualFiles) {
        Intrinsics.checkNotNullParameter(virtualFiles, "virtualFiles");
        this.sourceVirtualFiles.addAll(virtualFiles);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KaSourceModule build() {
        void $this$mapNotNullTo$iv$iv;
        List<VirtualFile> virtualFiles = this.collectVirtualFilesByRoots();
        PsiManager psiManager = PsiManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue(psiManager, "getInstance(...)");
        PsiManager psiManager2 = psiManager;
        Iterable $this$mapNotNull$iv = virtualFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (psiManager2.findFile(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List psiFiles = (List)destination$iv$iv;
        GlobalSearchScope globalSearchScope = this.contentScope;
        if (globalSearchScope == null) {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.filesScope(this.project, (Collection<? extends VirtualFile>)virtualFiles);
            globalSearchScope = globalSearchScope2;
            Intrinsics.checkNotNullExpressionValue(globalSearchScope2, "filesScope(...)");
        }
        GlobalSearchScope contentScope = globalSearchScope;
        return new KaSourceModuleImpl(this.getDirectRegularDependencies(), this.getDirectDependsOnDependencies(), this.getDirectFriendDependencies(), contentScope, this.getPlatform(), this.project, this.getModuleName(), this.languageVersionSettings, psiFiles);
    }

    private final List<VirtualFile> collectVirtualFilesByRoots() {
        List<VirtualFile> list;
        CoreLocalFileSystem coreLocalFileSystem = this.coreApplicationEnvironment.getLocalFileSystem();
        Intrinsics.checkNotNullExpressionValue(coreLocalFileSystem, "getLocalFileSystem(...)");
        CoreLocalFileSystem localFileSystem = coreLocalFileSystem;
        List<VirtualFile> $this$collectVirtualFilesByRoots_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Path root : this.sourceRoots) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            List<Path> files2 = Files.isDirectory(root, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? KaModuleUtilsKt.collectSourceFilePaths(root) : (KaModuleUtilsKt.hasSuitableExtensionToAnalyse(root) ? CollectionsKt.listOf(root) : CollectionsKt.emptyList());
            for (Path file : files2) {
                VirtualFile virtualFile;
                if (localFileSystem.findFileByNioFile(file.toAbsolutePath()) == null) continue;
                $this$collectVirtualFilesByRoots_u24lambda_u242.add(virtualFile);
            }
        }
        $this$collectVirtualFilesByRoots_u24lambda_u242.addAll((Collection)this.sourceVirtualFiles);
        List<VirtualFile> $this$sortBy$iv = $this$collectVirtualFilesByRoots_u24lambda_u242;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a2, T b2) {
                    VirtualFile it = (VirtualFile)a2;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getPath());
                    it = (VirtualFile)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getPath()));
                }
            });
        }
        return CollectionsKt.build(list);
    }
}

