/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.util;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignationKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ContextCollector;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.DesignationInterceptor;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirControlFlowGraphOwner;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.FirErrorProperty;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataContext;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.ImplicitReceiverUtilsKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.resolve.FirTowerDataMode;
import org.jetbrains.kotlin.fir.resolve.ImplicitValueStorage;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.SessionHolderImpl;
import org.jetbrains.kotlin.fir.resolve.dfa.DataFlowAnalyzerContext;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.RealVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.TypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.UtilKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ClassExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.MergePostponedLambdaExitsNode;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculatorForFullBodyResolve;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.BodyResolveContext;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirExpressionsResolveTransformerKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ImportingScopesKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirLocalScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirMemberTypeParameterScope;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitorVoid;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.SmartcastStability;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001:\u0006\u0085\u0001\u0086\u0001\u0087\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0002J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u001aH\u0016J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010(\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010*2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J&\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010*2\u0006\u0010/\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u00100\u001a\u000201H\u0002J \u00102\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0-2\u0006\u00100\u001a\u000201H\u0002J\u001e\u00103\u001a\b\u0012\u0002\b\u0003\u0018\u00010*2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u00104\u001a\u00020\u00052\n\u00105\u001a\u0006\u0012\u0002\b\u00030*H\u0002J\u0010\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020HH\u0016J\u0014\u0010I\u001a\u00020\u000f*\u00020J2\u0006\u0010G\u001a\u00020HH\u0002J\u0014\u0010K\u001a\u00020\u000f*\u00020J2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010L\u001a\u00020\u000f*\u00020J2\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010O\u001a\u00020\u000f2\u0006\u0010P\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\u000f2\u0006\u0010S\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020\u000f2\u0006\u0010V\u001a\u00020WH\u0016J\u0010\u0010X\u001a\u00020\u000f2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020\u000f2\u0006\u0010\\\u001a\u00020]H\u0016J\u0010\u0010^\u001a\u00020\u000f2\u0006\u0010_\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u00020\u000f2\u0006\u0010b\u001a\u00020cH\u0016J\"\u0010d\u001a\u00020\u000f*\u00020\u001d2\u0006\u0010b\u001a\u00020c2\f\u0010e\u001a\b\u0012\u0004\u0012\u00020\u000f0fH\u0002J\u000e\u0010g\u001a\u0004\u0018\u00010h*\u00020hH\u0002J\u0010\u0010i\u001a\u00020\u000f2\u0006\u0010j\u001a\u00020kH\u0016J\u0010\u0010l\u001a\u00020\u000f2\u0006\u0010m\u001a\u00020nH\u0016J\u0010\u0010o\u001a\u00020\u000f2\u0006\u0010p\u001a\u00020qH\u0016J\u0010\u0010r\u001a\u00020\u000f2\u0006\u0010s\u001a\u00020tH\u0016J\u0010\u0010u\u001a\u00020\u000f2\u0006\u0010v\u001a\u00020wH\u0016J\u0010\u0010x\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010y\u001a\u00020\u000f2\u0006\u0010z\u001a\u00020{H\u0016J\u0014\u0010|\u001a\u00020\u000f*\u00020J2\u0006\u0010#\u001a\u00020$H\u0003J\u0014\u0010}\u001a\u00020\u000f*\u00020J2\u0006\u0010#\u001a\u00020$H\u0003J+\u0010~\u001a\u00020\u000f2\u0006\u0010\u007f\u001a\u00020\u001a2\u0018\u0010z\u001a\u0014\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020\u000f0\u0007\u00a2\u0006\u0003\b\u0080\u0001H\u0082\bJ\u0017\u0010\u0081\u0001\u001a\u00020\u000f2\f\u0010z\u001a\b\u0012\u0004\u0012\u00020\u000f0fH\u0002J \u0010\u0082\u0001\u001a\u00020\u000f2\u0006\u0010\u007f\u001a\u00020\u001a2\f\u0010z\u001a\b\u0012\u0004\u0012\u00020\u000f0fH\u0082\bJ\u0018\u0010\u0083\u0001\u001a\u00020\u000f2\f\u0010z\u001a\b\u0012\u0004\u0012\u00020\u000f0fH\u0082\bJ\u0018\u0010\u0084\u0001\u001a\u00020\u000f2\f\u0010z\u001a\b\u0012\u0004\u0012\u00020\u000f0fH\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0019j\b\u0012\u0004\u0012\u00020\u001a`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00130\u001fj\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u0013`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010+\u001a>\u0012\u0004\u0012\u00020,\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0-0\u001fj\u001e\u0012\u0004\u0012\u00020,\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0-`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0088\u0001"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollectorVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitorVoid;", "bodyHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "shouldCollectBodyContext", "", "filter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$FilterResponse;", "designationPathInterceptor", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/DesignationInterceptor;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;ZLkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/DesignationInterceptor;)V", "collect", "", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "get", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$Context;", "element", "kind", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextKind;", "isActive", "parents", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/fir/FirElement;", "Lkotlin/collections/ArrayList;", "context", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveContext;", "result", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollectorVisitor$ContextKey;", "Lkotlin/collections/HashMap;", "getSessionHolder", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "visitElement", "dumpContext", "fir", "computeContext", "getClosestControlFlowNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "nodesCache", "Lorg/jetbrains/kotlin/fir/declarations/FirControlFlowGraphOwner;", "", "findNode", "container", "flow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "buildDeclarationNodesMapping", "getControlFlowNode", "isAcceptedControlFlowNode", "node", "visitScript", "script", "Lorg/jetbrains/kotlin/fir/declarations/FirScript;", "visitFile", "visitCodeFragment", "codeFragment", "Lorg/jetbrains/kotlin/fir/declarations/FirCodeFragment;", "visitAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "processClassHeader", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollectorVisitor$Processor;", "processFileHeader", "processAnonymousObjectHeader", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "visitErrorPrimaryConstructor", "errorPrimaryConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorPrimaryConstructor;", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitDanglingModifierList", "danglingModifierList", "Lorg/jetbrains/kotlin/fir/declarations/FirDanglingModifierList;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitErrorProperty", "errorProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorProperty;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "forPropertyInitializerIfNonLocal", "f", "Lkotlin/Function0;", "unwrap", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "visitField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "visitPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "visitValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "visitAnonymousInitializer", "anonymousInitializer", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "visitAnonymousFunction", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "visitAnonymousObject", "visitBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "processRawAnnotations", "processAnnotations", "withProcessor", "parent", "Lkotlin/ExtensionFunctionType;", "withInterceptor", "withParent", "onActive", "onActiveBody", "ContextKey", "Processor", "FilteringVisitor", "low-level-api-fir"})
final class ContextCollectorVisitor
extends FirDefaultVisitorVoid {
    @NotNull
    private final SessionHolder bodyHolder;
    private final boolean shouldCollectBodyContext;
    @NotNull
    private final Function1<PsiElement, ContextCollector.FilterResponse> filter;
    @Nullable
    private final DesignationInterceptor designationPathInterceptor;
    private boolean isActive;
    @NotNull
    private final ArrayList<FirElement> parents;
    @NotNull
    private final BodyResolveContext context;
    @NotNull
    private final HashMap<ContextKey, ContextCollector.Context> result;
    @NotNull
    private final HashMap<FirControlFlowGraphOwner, Map<FirElement, CFGNode<?>>> nodesCache;

    public ContextCollectorVisitor(@NotNull SessionHolder bodyHolder, boolean shouldCollectBodyContext, @NotNull Function1<? super PsiElement, ? extends ContextCollector.FilterResponse> filter2, @Nullable DesignationInterceptor designationPathInterceptor) {
        Intrinsics.checkNotNullParameter(bodyHolder, "bodyHolder");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        this.bodyHolder = bodyHolder;
        this.shouldCollectBodyContext = shouldCollectBodyContext;
        this.filter = filter2;
        this.designationPathInterceptor = designationPathInterceptor;
        this.isActive = true;
        this.parents = new ArrayList();
        this.context = new BodyResolveContext(ReturnTypeCalculatorForFullBodyResolve.Companion.getDefault(), new DataFlowAnalyzerContext(this.bodyHolder.getSession()));
        this.result = new HashMap();
        this.nodesCache = new HashMap();
    }

    public final void collect(@NotNull FirFile file) {
        Intrinsics.checkNotNullParameter(file, "file");
        if (this.designationPathInterceptor != null) {
            this.withInterceptor(() -> ContextCollectorVisitor.collect$lambda$1(file, this));
        } else {
            file.accept(this);
        }
    }

    @Nullable
    public final ContextCollector.Context get(@NotNull PsiElement element, @NotNull ContextCollector.ContextKind kind) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        ContextKey key = new ContextKey(element, kind);
        return this.result.get(key);
    }

    private final SessionHolder getSessionHolder(FirDeclaration declaration) {
        FirSession session = declaration.getModuleData().getSession();
        return Intrinsics.areEqual(session, this.bodyHolder.getSession()) ? this.bodyHolder : (SessionHolder)new SessionHolderImpl(session, this.bodyHolder.getScopeSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitElement(@NotNull FirElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        this.dumpContext(element, ContextCollector.ContextKind.SELF);
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withParent = false;
        this_$iv.parents.add(element);
        try {
            boolean bl = false;
            this.dumpContext(element, ContextCollector.ContextKind.BODY);
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$onActive = false;
            if (this_$iv2.isActive) {
                boolean bl2 = false;
                element.acceptChildren(this);
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv.parents);
        }
    }

    private final void dumpContext(FirElement fir, ContextCollector.ContextKind kind) {
        ProgressManager.checkCanceled();
        if (kind == ContextCollector.ContextKind.BODY && !this.shouldCollectBodyContext) {
            return;
        }
        PsiElement psiElement = UtilsKt.getPsi(fir);
        if (psiElement == null) {
            return;
        }
        PsiElement psi = psiElement;
        ContextKey key = new ContextKey(psi, kind);
        if (((Map)this.result).containsKey(key)) {
            return;
        }
        ContextCollector.FilterResponse response = this.filter.invoke(psi);
        if (response != ContextCollector.FilterResponse.SKIP) {
            ((Map)this.result).put(key, this.computeContext(fir, kind));
        }
        if (response == ContextCollector.FilterResponse.STOP) {
            this.isActive = false;
        }
    }

    private final ContextCollector.Context computeContext(FirElement fir, ContextCollector.ContextKind kind) {
        ImplicitValueStorage implicitReceiverStack = this.context.getTowerDataContext().getImplicitValueStorage();
        Map smartCasts = new LinkedHashMap();
        CFGNode<?> cfgNode = this.getClosestControlFlowNode(fir, kind);
        if (cfgNode != null) {
            Iterator<RealVariable> $this$sortedBy$iv;
            PersistentFlow flow = cfgNode.getFlow();
            Iterable iterable = flow.getKnownVariables();
            boolean $i$f$sortedBy = false;
            List<RealVariable> realVariables = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a2, T b2) {
                    RealVariable it = (RealVariable)a2;
                    boolean bl = false;
                    Name name = FirDeclarationUtilKt.getMemberDeclarationNameOrNull(it.getSymbol());
                    it = (RealVariable)b2;
                    Comparable comparable = (Comparable)((Object)(name != null ? name.asString() : null));
                    bl = false;
                    Name name2 = FirDeclarationUtilKt.getMemberDeclarationNameOrNull(it.getSymbol());
                    return ComparisonsKt.compareValues(comparable, (Comparable)((Object)(name2 != null ? name2.asString() : null)));
                }
            });
            for (RealVariable realVariable : realVariables) {
                TypeStatement typeStatement;
                SmartcastStability stability;
                if (flow.getTypeStatement(realVariable) == null || (stability = realVariable.getStability(flow, this.bodyHolder.getSession())) != SmartcastStability.STABLE_VALUE && stability != SmartcastStability.CAPTURED_VARIABLE) continue;
                smartCasts.put(typeStatement.getVariable(), typeStatement.getExactType());
                if (!realVariable.isImplicit()) continue;
                ConeKotlinType smartCastedType = UtilKt.smartCastedType(typeStatement, TypeComponentsKt.getTypeContext(this.bodyHolder.getSession()));
                implicitReceiverStack.replaceImplicitValueType(realVariable.getSymbol(), smartCastedType);
            }
        }
        FirTowerDataContext towerDataContextSnapshot = this.context.getTowerDataContext().createSnapshot(true);
        for (RealVariable realVariable : smartCasts.keySet()) {
            if (!realVariable.isImplicit()) continue;
            implicitReceiverStack.replaceImplicitValueType(realVariable.getSymbol(), realVariable.getOriginalType());
        }
        return new ContextCollector.Context(towerDataContextSnapshot, smartCasts);
    }

    private final CFGNode<?> getClosestControlFlowNode(FirElement fir, ContextCollector.ContextKind kind) {
        CFGNode<?> selfNode = this.getControlFlowNode(fir, kind);
        if (selfNode != null) {
            return selfNode;
        }
        for (FirElement parent2 : CollectionsKt.asReversedMutable((List)this.parents)) {
            CFGNode<?> parentNode = this.getControlFlowNode(parent2, kind);
            if (parentNode == null) continue;
            return parentNode;
        }
        return null;
    }

    private final CFGNode<?> findNode(FirControlFlowGraphOwner container, FirElement element, ControlFlowGraph flow) {
        Object object;
        Map $this$getOrPut$iv = this.nodesCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(container);
        if (value$iv == null) {
            boolean bl = false;
            Map<FirElement, CFGNode<?>> answer$iv = this.buildDeclarationNodesMapping(flow);
            $this$getOrPut$iv.put(container, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Map map2 = (Map)object;
        return (CFGNode)map2.get(element);
    }

    private final Map<FirElement, CFGNode<?>> buildDeclarationNodesMapping(ControlFlowGraph flow) {
        Map<FirElement, CFGNode<Object>> map2;
        Map<FirElement, CFGNode<?>> map3 = new HashMap();
        HashMap $this$buildDeclarationNodesMapping_u24lambda_u246 = map3;
        boolean bl = false;
        for (CFGNode<?> node : flow.getNodes()) {
            if (!this.isAcceptedControlFlowNode(node)) continue;
            Object fir = node.getFir();
            $this$buildDeclarationNodesMapping_u24lambda_u246.putIfAbsent(fir, node);
        }
        if ((map3 = (Map)map3).isEmpty()) {
            boolean bl2 = false;
            map2 = MapsKt.emptyMap();
        } else {
            map2 = map3;
        }
        return map2;
    }

    private final CFGNode<?> getControlFlowNode(FirElement fir, ContextCollector.ContextKind kind) {
        for (FirDeclaration container : CollectionsKt.asReversedMutable((List)this.context.getContainers())) {
            ControlFlowGraph cfg;
            FirControlFlowGraphReference cfgReference;
            FirControlFlowGraphOwner cfgOwner;
            FirControlFlowGraphOwner firControlFlowGraphOwner = container instanceof FirControlFlowGraphOwner ? (FirControlFlowGraphOwner)((Object)container) : null;
            if (firControlFlowGraphOwner == null || (cfgOwner = firControlFlowGraphOwner).getControlFlowGraphReference() == null || FirControlFlowGraphReferenceImplKt.getControlFlowGraph(cfgReference) == null) continue;
            CFGNode<?> node = this.findNode((FirControlFlowGraphOwner)((Object)container), fir, cfg);
            if (node != null) {
                CFGNode<Object> cFGNode;
                switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                    case 1: {
                        cFGNode = CollectionsKt.singleOrNull(node.getPreviousNodes());
                        if (cFGNode != null) {
                            CFGNode<?> cFGNode2;
                            CFGNode<?> it = cFGNode2 = cFGNode;
                            boolean bl = false;
                            cFGNode = cfg.getNodes().contains(it) ? cFGNode2 : null;
                            if (cFGNode != null) break;
                        }
                        cFGNode = node;
                        break;
                    }
                    case 2: {
                        cFGNode = node;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return cFGNode;
            }
            if (cfg.isSubGraph()) continue;
            return null;
        }
        return null;
    }

    private final boolean isAcceptedControlFlowNode(CFGNode<?> node) {
        return node instanceof ClassExitNode ? false : !(node instanceof MergePostponedLambdaExitsNode) || ((MergePostponedLambdaExitsNode)node).getFlowInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitScript(@NotNull FirScript script) {
        Intrinsics.checkNotNullParameter(script, "script");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv$iv = this_$iv;
        boolean $i$f$withParent = false;
        this_$iv$iv.parents.add(script);
        try {
            boolean bl = false;
            Processor $this$visitScript_u24lambda_u2412 = new Processor(this_$iv);
            boolean bl2 = false;
            this.dumpContext(script, ContextCollector.ContextKind.SELF);
            this.processAnnotations($this$visitScript_u24lambda_u2412, script);
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$onActiveBody = false;
            if (this_$iv2.isActive || this_$iv2.shouldCollectBodyContext) {
                boolean bl3 = false;
                SessionHolder holder = this.getSessionHolder(script);
                this.context.withScript(script, holder, () -> ContextCollectorVisitor.visitScript$lambda$12$lambda$11$lambda$10(this, script, $this$visitScript_u24lambda_u2412));
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv$iv.parents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitFile(@NotNull FirFile file) {
        Intrinsics.checkNotNullParameter(file, "file");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv$iv = this_$iv;
        boolean $i$f$withParent = false;
        this_$iv$iv.parents.add(file);
        try {
            int n2;
            int size$iv$iv;
            boolean bl = false;
            Processor $this$visitFile_u24lambda_u2416 = new Processor(this_$iv);
            boolean bl2 = false;
            SessionHolder holder = this.getSessionHolder(file);
            BodyResolveContext this_$iv2 = this.context;
            boolean $i$f$withFile = false;
            this_$iv2.clear();
            this_$iv2.setFile(file);
            List<FirScope> scopes$iv$iv = this_$iv2.getFileImportsScope();
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv$iv = scopes$iv$iv.size();
            try {
                Unit unit;
                boolean bl3 = false;
                BodyResolveContext this_$iv$iv2 = this_$iv2;
                boolean $i$f$withTowerDataCleanup = false;
                FirTowerDataContext initialContext$iv$iv = this_$iv$iv2.getTowerDataContext();
                try {
                    void $this$mapTo$iv$iv$iv;
                    void $this$map$iv$iv;
                    boolean bl4 = false;
                    List importingScopes$iv = ImportingScopesKt.createImportingScopes$default(file, holder.getSession(), holder.getScopeSession(), false, 8, null);
                    CollectionsKt.addAll((Collection)this_$iv2.getFileImportsScope(), importingScopes$iv);
                    Iterable iterable = importingScopes$iv;
                    BodyResolveContext bodyResolveContext = this_$iv2;
                    boolean $i$f$map = false;
                    Unit unit2 = $this$map$iv$iv;
                    Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                        void it$iv;
                        FirScope firScope = (FirScope)item$iv$iv$iv;
                        Collection collection = destination$iv$iv$iv;
                        boolean bl5 = false;
                        collection.add(ImplicitReceiverUtilsKt.asTowerDataElement((FirScope)it$iv, false));
                    }
                    bodyResolveContext.addNonLocalTowerDataElements((List)destination$iv$iv$iv);
                    BodyResolveContext this_$iv$iv3 = this_$iv2;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv3.getContainers().add(file);
                    try {
                        boolean bl6 = false;
                        this.dumpContext(file, ContextCollector.ContextKind.SELF);
                        this.processFileHeader($this$visitFile_u24lambda_u2416, file);
                        ContextCollectorVisitor this_$iv3 = this;
                        boolean $i$f$onActive = false;
                        if (this_$iv3.isActive) {
                            boolean bl7 = false;
                            this.withInterceptor(() -> ContextCollectorVisitor.visitFile$lambda$16$lambda$15$lambda$14$lambda$13($this$visitFile_u24lambda_u2416, file));
                        }
                        unit2 = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv3.getContainers().removeLast();
                    }
                    unit = unit2;
                }
                finally {
                    this_$iv$iv2.replaceTowerDataContext(initialContext$iv$iv);
                }
                Unit unit3 = unit;
                size$iv$iv = scopes$iv$iv.size();
                int n3 = n2 = size$iv$iv >= sizeBefore$iv$iv ? 1 : 0;
            }
            catch (Throwable throwable) {
                int n4;
                int size$iv$iv2 = scopes$iv$iv.size();
                int n5 = n4 = size$iv$iv2 >= sizeBefore$iv$iv ? 1 : 0;
                if (_Assertions.ENABLED && n4 == 0) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                n4 = size$iv$iv2 - sizeBefore$iv$iv;
                int n6 = 0;
                while (n6 < n4) {
                    int it$iv$iv = n6++;
                    boolean bl8 = false;
                    List<FirScope> it$iv$iv2 = scopes$iv$iv;
                    boolean bl9 = false;
                    it$iv$iv2.remove(it$iv$iv2.size() - 1);
                }
                throw throwable;
            }
            if (_Assertions.ENABLED && n2 == 0) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            n2 = size$iv$iv - sizeBefore$iv$iv;
            int n7 = 0;
            while (n7 < n2) {
                int it$iv$iv = n7++;
                boolean bl10 = false;
                List<FirScope> it$iv$iv3 = scopes$iv$iv;
                boolean bl11 = false;
                it$iv$iv3.remove(it$iv$iv3.size() - 1);
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv$iv.parents);
        }
    }

    @Override
    public void visitCodeFragment(@NotNull FirCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter(codeFragment, "codeFragment");
        FirLazyDeclarationResolverKt.lazyResolveToPhase(codeFragment, FirResolvePhase.BODY_RESOLVE);
        SessionHolder holder = this.getSessionHolder(codeFragment);
        this.context.withCodeFragment(codeFragment, holder, () -> ContextCollectorVisitor.visitCodeFragment$lambda$17(this, codeFragment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitAnnotationCall(@NotNull FirAnnotationCall annotationCall) {
        Intrinsics.checkNotNullParameter(annotationCall, "annotationCall");
        BodyResolveContext this_$iv = this.context;
        boolean $i$f$forAnnotation = false;
        if (this_$iv.getContainerIfAny() instanceof FirRegularClass && !this_$iv.getInsideClassHeader()) {
            void this_$iv$iv;
            BodyResolveContext bodyResolveContext = this_$iv;
            FirTowerDataMode mode$iv$iv = FirTowerDataMode.CLASS_HEADER_ANNOTATIONS;
            boolean $i$f$withTowerDataMode = false;
            void this_$iv$iv$iv = this_$iv$iv;
            boolean $i$f$withTowerDataModeCleanup = false;
            FirTowerDataMode initialMode$iv$iv$iv = this_$iv$iv$iv.getTowerDataMode();
            try {
                boolean bl = false;
                this_$iv$iv.setTowerDataMode(mode$iv$iv);
                boolean bl2 = false;
                this.dumpContext(annotationCall, ContextCollector.ContextKind.SELF);
                ContextCollectorVisitor this_$iv2 = this;
                boolean $i$f$onActiveBody = false;
                if (this_$iv2.isActive || this_$iv2.shouldCollectBodyContext) {
                    boolean bl3 = false;
                    this.dumpContext(annotationCall, ContextCollector.ContextKind.BODY);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv$iv$iv.setTowerDataMode(initialMode$iv$iv$iv);
            }
        } else {
            boolean bl = false;
            this.dumpContext(annotationCall, ContextCollector.ContextKind.SELF);
            ContextCollectorVisitor this_$iv3 = this;
            boolean $i$f$onActiveBody = false;
            if (this_$iv3.isActive || this_$iv3.shouldCollectBodyContext) {
                boolean bl4 = false;
                this.dumpContext(annotationCall, ContextCollector.ContextKind.BODY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitFunctionCall(@NotNull FirFunctionCall functionCall) {
        Intrinsics.checkNotNullParameter(functionCall, "functionCall");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl = false;
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$withParent = false;
            this_$iv2.parents.add(functionCall);
            try {
                boolean bl2 = false;
                functionCall.acceptChildren(this);
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv2.parents);
            }
        }
        this.dumpContext(functionCall, ContextCollector.ContextKind.SELF);
        FirExpressionsResolveTransformerKt.addReceiversFromExtensions(this.context, functionCall, this.bodyHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression) {
        Intrinsics.checkNotNullParameter(propertyAccessExpression, "propertyAccessExpression");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl = false;
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$withParent = false;
            this_$iv2.parents.add(propertyAccessExpression);
            try {
                boolean bl2 = false;
                FirNamedReference calleeReference = propertyAccessExpression.getCalleeReference();
                propertyAccessExpression.acceptChildren(new FilteringVisitor(this, SetsKt.setOf(calleeReference)));
                calleeReference.accept(this);
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv2.parents);
            }
        }
        this.dumpContext(propertyAccessExpression, ContextCollector.ContextKind.SELF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitRegularClass(@NotNull FirRegularClass regularClass) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv$iv = this_$iv;
        boolean $i$f$withParent = false;
        this_$iv$iv.parents.add(regularClass);
        try {
            boolean bl = false;
            Processor $this$visitRegularClass_u24lambda_u2430 = new Processor(this_$iv);
            boolean bl2 = false;
            this.dumpContext(regularClass, ContextCollector.ContextKind.SELF);
            Object this_$iv2 = this.context;
            boolean $i$f$withClassHeader = false;
            boolean old$iv = ((BodyResolveContext)this_$iv2).getInsideClassHeader();
            ((BodyResolveContext)this_$iv2).setInsideClassHeader(true);
            try {
                BodyResolveContext this_$iv$iv2 = this_$iv2;
                boolean $i$f$withSwitchedTowerDataModeForStaticNestedClass = false;
                BodyResolveContext this_$iv$iv$iv = this_$iv$iv2;
                boolean $i$f$withTowerDataModeCleanup = false;
                FirTowerDataMode initialMode$iv$iv$iv = this_$iv$iv$iv.getTowerDataMode();
                try {
                    boolean bl3 = false;
                    FirMemberDeclaration $this$isInner$iv$iv$iv = regularClass;
                    boolean $i$f$isInner = false;
                    if (!$this$isInner$iv$iv$iv.getStatus().isInner() && this_$iv$iv2.getContainerIfAny() instanceof FirRegularClass) {
                        FirRegularClass $this$isCompanion$iv$iv$iv = regularClass;
                        boolean $i$f$isCompanion = false;
                        this_$iv$iv2.setTowerDataMode($this$isCompanion$iv$iv$iv.getStatus().isCompanion() ? FirTowerDataMode.COMPANION_OBJECT : FirTowerDataMode.NESTED_CLASS);
                    }
                    boolean bl4 = false;
                    BodyResolveContext this_$iv$iv3 = this_$iv2;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv3.getContainers().add(regularClass);
                    try {
                        boolean bl5 = false;
                        this.processRawAnnotations($this$visitRegularClass_u24lambda_u2430, regularClass);
                    }
                    finally {
                        this_$iv$iv3.getContainers().removeLast();
                    }
                }
                finally {
                    this_$iv$iv$iv.setTowerDataMode(initialMode$iv$iv$iv);
                }
            }
            finally {
                ((BodyResolveContext)this_$iv2).setInsideClassHeader(old$iv);
            }
            this_$iv2 = this;
            boolean $i$f$onActiveBody = false;
            if (((ContextCollectorVisitor)this_$iv2).isActive || ((ContextCollectorVisitor)this_$iv2).shouldCollectBodyContext) {
                boolean bl6 = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase(regularClass, FirResolvePhase.STATUS);
                BodyResolveContext this_$iv3 = this.context;
                boolean $i$f$withContainingClass = false;
                this_$iv3.getContainingClassDeclarations().add(regularClass);
                try {
                    boolean bl7 = false;
                    this.processClassHeader($this$visitRegularClass_u24lambda_u2430, regularClass);
                    SessionHolder holder = this.getSessionHolder(regularClass);
                    this.context.withRegularClass(regularClass, holder, () -> ContextCollectorVisitor.visitRegularClass$lambda$30$lambda$29$lambda$28$lambda$27(this, regularClass, $this$visitRegularClass_u24lambda_u2430));
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv3.getContainingClassDeclarations().removeLast();
                }
            }
            FirClassLikeDeclaration $this$isLocal$iv = regularClass;
            boolean $i$f$isLocal = false;
            if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                this.context.storeClassIfNotNested(regularClass, regularClass.getModuleData().getSession());
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv$iv.parents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processClassHeader(Processor $this$processClassHeader, FirRegularClass regularClass) {
        block14: {
            BodyResolveContext this_$iv = this.context;
            boolean $i$f$withClassHeader = false;
            boolean old$iv = this_$iv.getInsideClassHeader();
            this_$iv.setInsideClassHeader(true);
            try {
                BodyResolveContext this_$iv$iv = this_$iv;
                boolean $i$f$withSwitchedTowerDataModeForStaticNestedClass = false;
                BodyResolveContext this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$withTowerDataModeCleanup = false;
                FirTowerDataMode initialMode$iv$iv$iv = this_$iv$iv$iv.getTowerDataMode();
                try {
                    boolean bl = false;
                    FirMemberDeclaration $this$isInner$iv$iv$iv = regularClass;
                    boolean $i$f$isInner = false;
                    if (!$this$isInner$iv$iv$iv.getStatus().isInner() && this_$iv$iv.getContainerIfAny() instanceof FirRegularClass) {
                        FirRegularClass $this$isCompanion$iv$iv$iv = regularClass;
                        boolean $i$f$isCompanion = false;
                        this_$iv$iv.setTowerDataMode($this$isCompanion$iv$iv$iv.getStatus().isCompanion() ? FirTowerDataMode.COMPANION_OBJECT : FirTowerDataMode.NESTED_CLASS);
                    }
                    boolean bl2 = false;
                    BodyResolveContext this_$iv$iv2 = this_$iv;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv2.getContainers().add(regularClass);
                    try {
                        boolean bl3 = false;
                        BodyResolveContext this_$iv2 = this.context;
                        boolean $i$f$withTypeParametersOf = false;
                        if (((FirMemberDeclaration)regularClass).getTypeParameters().isEmpty()) {
                            boolean bl4 = false;
                            $this$processClassHeader.processList((Collection<? extends FirElement>)regularClass.getContextParameters());
                            $this$processClassHeader.processList((Collection<? extends FirElement>)regularClass.getTypeParameters());
                            $this$processClassHeader.processList((Collection<? extends FirElement>)regularClass.getSuperTypeRefs());
                            break block14;
                        }
                        FirMemberTypeParameterScope scope$iv = new FirMemberTypeParameterScope(regularClass);
                        BodyResolveContext this_$iv$iv3 = this_$iv2;
                        boolean $i$f$withTowerDataCleanup = false;
                        FirTowerDataContext initialContext$iv$iv = this_$iv$iv3.getTowerDataContext();
                        try {
                            boolean bl5 = false;
                            this_$iv2.addNonLocalTowerDataElement(ImplicitReceiverUtilsKt.asTowerDataElement(scope$iv, false));
                            boolean bl6 = false;
                            $this$processClassHeader.processList((Collection<? extends FirElement>)regularClass.getContextParameters());
                            $this$processClassHeader.processList((Collection<? extends FirElement>)regularClass.getTypeParameters());
                            $this$processClassHeader.processList((Collection<? extends FirElement>)regularClass.getSuperTypeRefs());
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            this_$iv$iv3.replaceTowerDataContext(initialContext$iv$iv);
                        }
                    }
                    finally {
                        this_$iv$iv2.getContainers().removeLast();
                    }
                }
                finally {
                    this_$iv$iv$iv.setTowerDataMode(initialMode$iv$iv$iv);
                }
            }
            finally {
                this_$iv.setInsideClassHeader(old$iv);
            }
        }
    }

    private final void processFileHeader(Processor $this$processFileHeader, FirFile file) {
        $this$processFileHeader.process(file.getPackageDirective());
        $this$processFileHeader.processList((Collection<? extends FirElement>)file.getImports());
        this.processRawAnnotations($this$processFileHeader, file);
    }

    private final void processAnonymousObjectHeader(Processor $this$processAnonymousObjectHeader, FirAnonymousObject anonymousObject) {
        $this$processAnonymousObjectHeader.processList((Collection<? extends FirElement>)anonymousObject.getSuperTypeRefs());
    }

    @Override
    public void visitErrorPrimaryConstructor(@NotNull FirErrorPrimaryConstructor errorPrimaryConstructor) {
        Intrinsics.checkNotNullParameter(errorPrimaryConstructor, "errorPrimaryConstructor");
        this.visitConstructor(errorPrimaryConstructor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitConstructor(@NotNull FirConstructor constructor) {
        block22: {
            Intrinsics.checkNotNullParameter(constructor, "constructor");
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$withProcessor = false;
            ContextCollectorVisitor this_$iv$iv = this_$iv;
            boolean $i$f$withParent = false;
            this_$iv$iv.parents.add(constructor);
            try {
                boolean bl = false;
                Processor $this$visitConstructor_u24lambda_u2441 = new Processor(this_$iv);
                boolean bl2 = false;
                this.dumpContext(constructor, ContextCollector.ContextKind.SELF);
                this.processRawAnnotations($this$visitConstructor_u24lambda_u2441, constructor);
                ContextCollectorVisitor this_$iv2 = this;
                boolean $i$f$onActiveBody = false;
                if (!this_$iv2.isActive && !this_$iv2.shouldCollectBodyContext) break block22;
                boolean bl3 = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase(constructor, FirResolvePhase.BODY_RESOLVE);
                BodyResolveContext this_$iv3 = this.context;
                boolean $i$f$withConstructor = false;
                BodyResolveContext this_$iv$iv2 = this_$iv3;
                boolean $i$f$withContainer = false;
                this_$iv$iv2.getContainers().add(constructor);
                try {
                    void this_$iv$iv$iv;
                    boolean bl4 = false;
                    SessionHolder holder = this.getSessionHolder(constructor);
                    FirDeclaration firDeclaration = this.context.getContainerIfAny();
                    FirRegularClass containingClass = firDeclaration instanceof FirRegularClass ? (FirRegularClass)firDeclaration : null;
                    Object this_$iv4 = this.context;
                    boolean $i$f$forConstructorParameters = false;
                    BodyResolveContext this_$iv$iv3 = this_$iv4;
                    boolean $i$f$forConstructorParametersOrDelegatedConstructorCall2 = false;
                    BodyResolveContext bodyResolveContext = this_$iv$iv3;
                    FirTowerDataMode mode$iv$iv$iv = FirTowerDataMode.CONSTRUCTOR_HEADER;
                    boolean $i$f$withTowerDataMode = false;
                    void this_$iv$iv$iv$iv = this_$iv$iv$iv;
                    boolean $i$f$withTowerDataModeCleanup2 = false;
                    FirTowerDataMode initialMode$iv$iv$iv$iv = this_$iv$iv$iv$iv.getTowerDataMode();
                    try {
                        Unit unit;
                        boolean bl5 = false;
                        this_$iv$iv$iv.setTowerDataMode(mode$iv$iv$iv);
                        boolean bl6 = false;
                        BodyResolveContext this_$iv$iv$iv2 = this_$iv$iv3;
                        boolean $i$f$withTowerDataCleanup = false;
                        FirTowerDataContext initialContext$iv$iv$iv = this_$iv$iv$iv2.getTowerDataContext();
                        try {
                            boolean bl7 = false;
                            if (!constructor.isPrimary()) {
                                this_$iv$iv3.addInaccessibleImplicitReceiverValue(containingClass, holder);
                            }
                            this_$iv$iv3.addLocalScope(this_$iv$iv3.buildConstructorParametersScope(constructor, holder.getSession()));
                            boolean bl8 = false;
                            $this$visitConstructor_u24lambda_u2441.processList((Collection<? extends FirElement>)constructor.getValueParameters());
                            unit = Unit.INSTANCE;
                        }
                        finally {
                            this_$iv$iv$iv2.replaceTowerDataContext(initialContext$iv$iv$iv);
                        }
                        Unit bl8 = unit;
                    }
                    finally {
                        this_$iv$iv$iv$iv.setTowerDataMode(initialMode$iv$iv$iv$iv);
                    }
                    this.context.forConstructorBody(constructor, holder.getSession(), () -> ContextCollectorVisitor.visitConstructor$lambda$41$lambda$40$lambda$39$lambda$35($this$visitConstructor_u24lambda_u2441, constructor, this));
                    this_$iv4 = this;
                    boolean $i$f$onActive = false;
                    if (((ContextCollectorVisitor)this_$iv4).isActive) {
                        void this_$iv$iv$iv3;
                        ContextCollectorVisitor this_$iv5;
                        boolean bl9 = false;
                        BodyResolveContext $i$f$forConstructorParametersOrDelegatedConstructorCall2 = this.context;
                        FirRegularClass owningClass$iv = null;
                        boolean $i$f$forDelegatedConstructorCall = false;
                        void this_$iv$iv4 = this_$iv5;
                        boolean $i$f$forConstructorParametersOrDelegatedConstructorCall3 = false;
                        void $i$f$withTowerDataModeCleanup2 = this_$iv$iv4;
                        FirTowerDataMode mode$iv$iv$iv2 = FirTowerDataMode.CONSTRUCTOR_HEADER;
                        boolean $i$f$withTowerDataMode2 = false;
                        void this_$iv$iv$iv$iv2 = this_$iv$iv$iv3;
                        boolean $i$f$withTowerDataModeCleanup3 = false;
                        FirTowerDataMode initialMode$iv$iv$iv$iv2 = this_$iv$iv$iv$iv2.getTowerDataMode();
                        try {
                            Unit unit;
                            boolean bl10 = false;
                            this_$iv$iv$iv3.setTowerDataMode(mode$iv$iv$iv2);
                            boolean bl11 = false;
                            void this_$iv$iv$iv4 = this_$iv$iv4;
                            boolean $i$f$withTowerDataCleanup = false;
                            FirTowerDataContext initialContext$iv$iv$iv = this_$iv$iv$iv4.getTowerDataContext();
                            try {
                                boolean bl12 = false;
                                if (!constructor.isPrimary()) {
                                    this_$iv$iv4.addInaccessibleImplicitReceiverValue(owningClass$iv, holder);
                                }
                                this_$iv$iv4.addLocalScope(this_$iv$iv4.buildConstructorParametersScope(constructor, holder.getSession()));
                                boolean bl13 = false;
                                $this$visitConstructor_u24lambda_u2441.process(constructor.getDelegatedConstructor());
                                unit = Unit.INSTANCE;
                            }
                            finally {
                                this_$iv$iv$iv4.replaceTowerDataContext(initialContext$iv$iv$iv);
                            }
                            Unit unit2 = unit;
                        }
                        finally {
                            this_$iv$iv$iv$iv2.setTowerDataMode(initialMode$iv$iv$iv$iv2);
                        }
                        this_$iv5 = this;
                        boolean $i$f$onActive2 = false;
                        if (this_$iv5.isActive) {
                            boolean bl14 = false;
                            $this$visitConstructor_u24lambda_u2441.processChildren(constructor);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv$iv2.getContainers().removeLast();
                }
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv$iv.parents);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitEnumEntry(@NotNull FirEnumEntry enumEntry) {
        block11: {
            Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$withProcessor = false;
            ContextCollectorVisitor this_$iv$iv = this_$iv;
            boolean $i$f$withParent = false;
            this_$iv$iv.parents.add(enumEntry);
            try {
                void this_$iv$iv2;
                boolean bl = false;
                Processor $this$visitEnumEntry_u24lambda_u2446 = new Processor(this_$iv);
                boolean bl2 = false;
                this.dumpContext(enumEntry, ContextCollector.ContextKind.SELF);
                ContextCollectorVisitor this_$iv2 = this;
                boolean $i$f$onActiveBody = false;
                if (!this_$iv2.isActive && !this_$iv2.shouldCollectBodyContext) break block11;
                boolean bl3 = false;
                BodyResolveContext this_$iv3 = this.context;
                boolean $i$f$withEnumEntry = false;
                BodyResolveContext bodyResolveContext = this_$iv3;
                FirTowerDataMode mode$iv$iv = FirTowerDataMode.ENUM_ENTRY;
                boolean $i$f$withTowerDataMode = false;
                void this_$iv$iv$iv = this_$iv$iv2;
                boolean $i$f$withTowerDataModeCleanup = false;
                FirTowerDataMode initialMode$iv$iv$iv = this_$iv$iv$iv.getTowerDataMode();
                try {
                    Unit unit;
                    boolean bl4 = false;
                    this_$iv$iv2.setTowerDataMode(mode$iv$iv);
                    boolean bl5 = false;
                    BodyResolveContext this_$iv$iv3 = this_$iv3;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv3.getContainers().add(enumEntry);
                    try {
                        boolean bl6 = false;
                        this.processRawAnnotations($this$visitEnumEntry_u24lambda_u2446, enumEntry);
                        ContextCollectorVisitor this_$iv4 = this;
                        boolean $i$f$onActiveBody2 = false;
                        if (this_$iv4.isActive || this_$iv4.shouldCollectBodyContext) {
                            boolean bl7 = false;
                            FirLazyDeclarationResolverKt.lazyResolveToPhase(enumEntry, FirResolvePhase.BODY_RESOLVE);
                            this.dumpContext(enumEntry, ContextCollector.ContextKind.BODY);
                            ContextCollectorVisitor this_$iv5 = this;
                            boolean $i$f$onActive = false;
                            if (this_$iv5.isActive) {
                                boolean bl8 = false;
                                $this$visitEnumEntry_u24lambda_u2446.processChildren(enumEntry);
                            }
                        }
                        unit = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv3.getContainers().removeLast();
                    }
                    Unit unit2 = unit;
                }
                finally {
                    this_$iv$iv$iv.setTowerDataMode(initialMode$iv$iv$iv);
                }
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv$iv.parents);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitDanglingModifierList(@NotNull FirDanglingModifierList danglingModifierList) {
        Intrinsics.checkNotNullParameter(danglingModifierList, "danglingModifierList");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv$iv = this_$iv;
        boolean $i$f$withParent = false;
        this_$iv$iv.parents.add(danglingModifierList);
        try {
            boolean bl = false;
            Processor $this$visitDanglingModifierList_u24lambda_u2450 = new Processor(this_$iv);
            boolean bl2 = false;
            this.dumpContext(danglingModifierList, ContextCollector.ContextKind.SELF);
            this.processAnnotations($this$visitDanglingModifierList_u24lambda_u2450, danglingModifierList);
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$onActiveBody = false;
            if (this_$iv2.isActive || this_$iv2.shouldCollectBodyContext) {
                boolean bl3 = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase(danglingModifierList, FirResolvePhase.BODY_RESOLVE);
                this.context.withDanglingModifierList(danglingModifierList, () -> ContextCollectorVisitor.visitDanglingModifierList$lambda$50$lambda$49$lambda$48(this, danglingModifierList, $this$visitDanglingModifierList_u24lambda_u2450));
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv$iv.parents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction) {
        block20: {
            Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$withProcessor = false;
            ContextCollectorVisitor this_$iv$iv = this_$iv;
            boolean $i$f$withParent = false;
            this_$iv$iv.parents.add(simpleFunction);
            try {
                void this_$iv2;
                boolean bl = false;
                Processor $this$visitSimpleFunction_u24lambda_u2458 = new Processor(this_$iv);
                boolean bl2 = false;
                this.dumpContext(simpleFunction, ContextCollector.ContextKind.SELF);
                this.processAnnotations($this$visitSimpleFunction_u24lambda_u2458, simpleFunction);
                ContextCollectorVisitor this_$iv3 = this;
                boolean $i$f$onActiveBody = false;
                if (!this_$iv3.isActive && !this_$iv3.shouldCollectBodyContext) break block20;
                boolean bl3 = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase(simpleFunction, FirResolvePhase.BODY_RESOLVE);
                SessionHolder holder = this.getSessionHolder(simpleFunction);
                BodyResolveContext bodyResolveContext = this.context;
                FirSession session$iv = holder.getSession();
                boolean $i$f$withSimpleFunction = false;
                if (!(this_$iv2.getContainerIfAny() instanceof FirClass)) {
                    this_$iv2.storeFunction(simpleFunction, session$iv);
                }
                void this_$iv$iv2 = this_$iv2;
                boolean $i$f$withTypeParametersOf = false;
                if (((FirMemberDeclaration)simpleFunction).getTypeParameters().isEmpty()) {
                    boolean bl4 = false;
                    void this_$iv$iv3 = this_$iv2;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv3.getContainers().add(simpleFunction);
                    try {
                        boolean bl5 = false;
                        $this$visitSimpleFunction_u24lambda_u2458.processList((Collection<? extends FirElement>)simpleFunction.getTypeParameters());
                        ContextCollectorVisitor this_$iv4 = this;
                        boolean $i$f$onActive = false;
                        if (this_$iv4.isActive) {
                            boolean bl6 = false;
                            $this$visitSimpleFunction_u24lambda_u2458.process(simpleFunction.getReceiverParameter());
                        }
                        this_$iv4 = this;
                        boolean $i$f$onActiveBody2 = false;
                        if (this_$iv4.isActive || this_$iv4.shouldCollectBodyContext) {
                            boolean bl7 = false;
                            this.context.forFunctionBody(simpleFunction, holder, () -> ContextCollectorVisitor.visitSimpleFunction$lambda$58$lambda$57$lambda$56$lambda$55$lambda$53(this, simpleFunction, $this$visitSimpleFunction_u24lambda_u2458));
                            ContextCollectorVisitor this_$iv5 = this;
                            boolean $i$f$onActive2 = false;
                            if (this_$iv5.isActive) {
                                boolean bl8 = false;
                                $this$visitSimpleFunction_u24lambda_u2458.processChildren(simpleFunction);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                        break block20;
                    }
                    finally {
                        this_$iv$iv3.getContainers().removeLast();
                    }
                }
                FirMemberTypeParameterScope scope$iv$iv = new FirMemberTypeParameterScope(simpleFunction);
                void this_$iv$iv$iv = this_$iv$iv2;
                boolean $i$f$withTowerDataCleanup = false;
                FirTowerDataContext initialContext$iv$iv$iv = this_$iv$iv$iv.getTowerDataContext();
                try {
                    Unit unit;
                    boolean bl9 = false;
                    this_$iv$iv2.addNonLocalTowerDataElement(ImplicitReceiverUtilsKt.asTowerDataElement(scope$iv$iv, false));
                    boolean bl10 = false;
                    void this_$iv$iv4 = this_$iv2;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv4.getContainers().add(simpleFunction);
                    try {
                        boolean bl11 = false;
                        $this$visitSimpleFunction_u24lambda_u2458.processList((Collection<? extends FirElement>)simpleFunction.getTypeParameters());
                        ContextCollectorVisitor this_$iv6 = this;
                        boolean $i$f$onActive = false;
                        if (this_$iv6.isActive) {
                            boolean bl12 = false;
                            $this$visitSimpleFunction_u24lambda_u2458.process(simpleFunction.getReceiverParameter());
                        }
                        this_$iv6 = this;
                        boolean $i$f$onActiveBody3 = false;
                        if (this_$iv6.isActive || this_$iv6.shouldCollectBodyContext) {
                            boolean bl13 = false;
                            this.context.forFunctionBody(simpleFunction, holder, () -> ContextCollectorVisitor.visitSimpleFunction$lambda$58$lambda$57$lambda$56$lambda$55$lambda$53(this, simpleFunction, $this$visitSimpleFunction_u24lambda_u2458));
                            ContextCollectorVisitor this_$iv7 = this;
                            boolean $i$f$onActive3 = false;
                            if (this_$iv7.isActive) {
                                boolean bl14 = false;
                                $this$visitSimpleFunction_u24lambda_u2458.processChildren(simpleFunction);
                            }
                        }
                        unit = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv4.getContainers().removeLast();
                    }
                    Unit unit2 = unit;
                }
                finally {
                    this_$iv$iv$iv.replaceTowerDataContext(initialContext$iv$iv$iv);
                }
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv$iv.parents);
            }
        }
    }

    @Override
    public void visitErrorProperty(@NotNull FirErrorProperty errorProperty) {
        Intrinsics.checkNotNullParameter(errorProperty, "errorProperty");
        this.visitProperty(errorProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitProperty(@NotNull FirProperty property) {
        Intrinsics.checkNotNullParameter(property, "property");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv$iv = this_$iv;
        boolean $i$f$withParent = false;
        this_$iv$iv.parents.add(property);
        try {
            boolean bl = false;
            Processor $this$visitProperty_u24lambda_u2470 = new Processor(this_$iv);
            boolean bl2 = false;
            this.dumpContext(property, ContextCollector.ContextKind.SELF);
            this.processAnnotations($this$visitProperty_u24lambda_u2470, property);
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$onActiveBody = false;
            if (this_$iv2.isActive || this_$iv2.shouldCollectBodyContext) {
                boolean bl3 = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase(property, FirResolvePhase.BODY_RESOLVE);
                BodyResolveContext this_$iv3 = this.context;
                boolean $i$f$withProperty = false;
                BodyResolveContext this_$iv$iv2 = this_$iv3;
                boolean $i$f$withTypeParametersOf = false;
                if (((FirMemberDeclaration)property).getTypeParameters().isEmpty()) {
                    boolean bl4 = false;
                    BodyResolveContext this_$iv$iv3 = this_$iv3;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv3.getContainers().add(property);
                    try {
                        boolean bl5 = false;
                        $this$visitProperty_u24lambda_u2470.processList((Collection<? extends FirElement>)property.getTypeParameters());
                        ContextCollectorVisitor this_$iv4 = this;
                        boolean $i$f$onActive = false;
                        if (this_$iv4.isActive) {
                            boolean bl6 = false;
                            $this$visitProperty_u24lambda_u2470.process(property.getReceiverParameter());
                        }
                        this_$iv4 = this;
                        boolean $i$f$onActiveBody2 = false;
                        if (this_$iv4.isActive || this_$iv4.shouldCollectBodyContext) {
                            boolean bl7 = false;
                            this.dumpContext(property, ContextCollector.ContextKind.BODY);
                        }
                        this_$iv4 = this;
                        $i$f$onActive = false;
                        if (this_$iv4.isActive) {
                            boolean bl8 = false;
                            this.context.withParameters(property, this.getSessionHolder(property), () -> ContextCollectorVisitor.visitProperty$lambda$70$lambda$69$lambda$68$lambda$67$lambda$61($this$visitProperty_u24lambda_u2470, property));
                            ContextCollectorVisitor this_$iv5 = this;
                            boolean $i$f$onActive2 = false;
                            if (this_$iv5.isActive) {
                                boolean bl9 = false;
                                this.forPropertyInitializerIfNonLocal(this.context, property, () -> ContextCollectorVisitor.visitProperty$lambda$70$lambda$69$lambda$68$lambda$67$lambda$66$lambda$64($this$visitProperty_u24lambda_u2470, property, this));
                                ContextCollectorVisitor this_$iv6 = this;
                                boolean $i$f$onActive3 = false;
                                if (this_$iv6.isActive) {
                                    boolean bl10 = false;
                                    $this$visitProperty_u24lambda_u2470.processChildren(property);
                                }
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv3.getContainers().removeLast();
                    }
                }
                FirMemberTypeParameterScope scope$iv$iv = new FirMemberTypeParameterScope(property);
                BodyResolveContext this_$iv$iv$iv = this_$iv$iv2;
                boolean $i$f$withTowerDataCleanup = false;
                FirTowerDataContext initialContext$iv$iv$iv = this_$iv$iv$iv.getTowerDataContext();
                try {
                    Unit unit;
                    boolean bl11 = false;
                    this_$iv$iv2.addNonLocalTowerDataElement(ImplicitReceiverUtilsKt.asTowerDataElement(scope$iv$iv, false));
                    boolean bl12 = false;
                    BodyResolveContext this_$iv$iv4 = this_$iv3;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv4.getContainers().add(property);
                    try {
                        boolean bl13 = false;
                        $this$visitProperty_u24lambda_u2470.processList((Collection<? extends FirElement>)property.getTypeParameters());
                        ContextCollectorVisitor this_$iv7 = this;
                        boolean $i$f$onActive = false;
                        if (this_$iv7.isActive) {
                            boolean bl14 = false;
                            $this$visitProperty_u24lambda_u2470.process(property.getReceiverParameter());
                        }
                        this_$iv7 = this;
                        boolean $i$f$onActiveBody3 = false;
                        if (this_$iv7.isActive || this_$iv7.shouldCollectBodyContext) {
                            boolean bl15 = false;
                            this.dumpContext(property, ContextCollector.ContextKind.BODY);
                        }
                        this_$iv7 = this;
                        $i$f$onActive = false;
                        if (this_$iv7.isActive) {
                            boolean bl16 = false;
                            this.context.withParameters(property, this.getSessionHolder(property), () -> ContextCollectorVisitor.visitProperty$lambda$70$lambda$69$lambda$68$lambda$67$lambda$61($this$visitProperty_u24lambda_u2470, property));
                            ContextCollectorVisitor this_$iv8 = this;
                            boolean $i$f$onActive4 = false;
                            if (this_$iv8.isActive) {
                                boolean bl17 = false;
                                this.forPropertyInitializerIfNonLocal(this.context, property, () -> ContextCollectorVisitor.visitProperty$lambda$70$lambda$69$lambda$68$lambda$67$lambda$66$lambda$64($this$visitProperty_u24lambda_u2470, property, this));
                                ContextCollectorVisitor this_$iv9 = this;
                                boolean $i$f$onActive5 = false;
                                if (this_$iv9.isActive) {
                                    boolean bl18 = false;
                                    $this$visitProperty_u24lambda_u2470.processChildren(property);
                                }
                            }
                        }
                        unit = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv4.getContainers().removeLast();
                    }
                    Unit unit2 = unit;
                }
                finally {
                    this_$iv$iv$iv.replaceTowerDataContext(initialContext$iv$iv$iv);
                }
            }
            if (property.isLocal()) {
                this.context.storeVariable(property, property.getModuleData().getSession());
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv$iv.parents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void forPropertyInitializerIfNonLocal(BodyResolveContext $this$forPropertyInitializerIfNonLocal, FirProperty property, Function0<Unit> f2) {
        if (!property.isLocal()) {
            BodyResolveContext this_$iv = $this$forPropertyInitializerIfNonLocal;
            boolean $i$f$forPropertyInitializer = false;
            BodyResolveContext this_$iv$iv = this_$iv;
            boolean $i$f$withTowerDataCleanup = false;
            FirTowerDataContext initialContext$iv$iv = this_$iv$iv.getTowerDataContext();
            try {
                boolean bl = false;
                FirLocalScope firLocalScope = this_$iv.getPrimaryConstructorPureParametersScope();
                if (firLocalScope != null) {
                    FirLocalScope it$iv = firLocalScope;
                    boolean bl2 = false;
                    this_$iv.addLocalScope(it$iv);
                }
                Unit unit = f2.invoke();
            }
            finally {
                this_$iv$iv.replaceTowerDataContext(initialContext$iv$iv);
            }
        } else {
            f2.invoke();
        }
    }

    private final FirExpression unwrap(FirExpression $this$unwrap) {
        FirExpression firExpression;
        FirExpression firExpression2 = $this$unwrap;
        if (firExpression2 instanceof FirCheckNotNullCall) {
            FirCall $this$argument$iv = (FirCall)((Object)$this$unwrap);
            boolean $i$f$getArgument = false;
            firExpression = this.unwrap(CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()));
        } else if (firExpression2 instanceof FirSafeCallExpression) {
            FirStatement firStatement = ((FirSafeCallExpression)$this$unwrap).getSelector();
            FirExpression firExpression3 = firStatement instanceof FirExpression ? (FirExpression)firStatement : null;
            firExpression = firExpression3 != null ? this.unwrap(firExpression3) : null;
        } else {
            firExpression = $this$unwrap;
        }
        return firExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitField(@NotNull FirField field) {
        block14: {
            Intrinsics.checkNotNullParameter(field, "field");
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$withProcessor = false;
            ContextCollectorVisitor this_$iv$iv = this_$iv;
            boolean $i$f$withParent = false;
            this_$iv$iv.parents.add(field);
            try {
                void this_$iv$iv2;
                boolean bl = false;
                Processor $this$visitField_u24lambda_u2474 = new Processor(this_$iv);
                boolean bl2 = false;
                this.dumpContext(field, ContextCollector.ContextKind.SELF);
                this.processAnnotations($this$visitField_u24lambda_u2474, field);
                ContextCollectorVisitor this_$iv2 = this;
                boolean $i$f$onActiveBody = false;
                if (!this_$iv2.isActive && !this_$iv2.shouldCollectBodyContext) break block14;
                boolean bl3 = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase(field, FirResolvePhase.BODY_RESOLVE);
                BodyResolveContext this_$iv3 = this.context;
                boolean $i$f$withField = false;
                BodyResolveContext bodyResolveContext = this_$iv3;
                FirTowerDataMode mode$iv$iv = FirTowerDataMode.CONSTRUCTOR_HEADER;
                boolean $i$f$withTowerDataMode = false;
                void this_$iv$iv$iv = this_$iv$iv2;
                boolean $i$f$withTowerDataModeCleanup = false;
                FirTowerDataMode initialMode$iv$iv$iv = this_$iv$iv$iv.getTowerDataMode();
                try {
                    Unit unit;
                    boolean bl4 = false;
                    this_$iv$iv2.setTowerDataMode(mode$iv$iv);
                    boolean bl5 = false;
                    BodyResolveContext this_$iv$iv3 = this_$iv3;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv3.getContainers().add(field);
                    try {
                        Unit unit2;
                        boolean bl6 = false;
                        BodyResolveContext this_$iv$iv4 = this_$iv3;
                        boolean $i$f$withTowerDataCleanup = false;
                        FirTowerDataContext initialContext$iv$iv = this_$iv$iv4.getTowerDataContext();
                        try {
                            boolean bl7 = false;
                            FirLocalScope firLocalScope = this_$iv3.getPrimaryConstructorAllParametersScope();
                            if (firLocalScope != null) {
                                FirLocalScope it$iv = firLocalScope;
                                boolean bl8 = false;
                                this_$iv3.addLocalScope(it$iv);
                            }
                            boolean bl9 = false;
                            this.dumpContext(field, ContextCollector.ContextKind.BODY);
                            ContextCollectorVisitor this_$iv4 = this;
                            boolean $i$f$onActive = false;
                            if (this_$iv4.isActive) {
                                boolean bl10 = false;
                                $this$visitField_u24lambda_u2474.process(field.getInitializer());
                            }
                            unit2 = Unit.INSTANCE;
                        }
                        finally {
                            this_$iv$iv4.replaceTowerDataContext(initialContext$iv$iv);
                        }
                        unit = unit2;
                    }
                    finally {
                        this_$iv$iv3.getContainers().removeLast();
                    }
                    Unit unit3 = unit;
                }
                finally {
                    this_$iv$iv$iv.setTowerDataMode(initialMode$iv$iv$iv);
                }
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv$iv.parents);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor) {
        Intrinsics.checkNotNullParameter(propertyAccessor, "propertyAccessor");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv$iv = this_$iv;
        boolean $i$f$withParent = false;
        this_$iv$iv.parents.add(propertyAccessor);
        try {
            boolean bl = false;
            Processor $this$visitPropertyAccessor_u24lambda_u2478 = new Processor(this_$iv);
            boolean bl2 = false;
            this.dumpContext(propertyAccessor, ContextCollector.ContextKind.SELF);
            this.processAnnotations($this$visitPropertyAccessor_u24lambda_u2478, propertyAccessor);
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$onActiveBody = false;
            if (this_$iv2.isActive || this_$iv2.shouldCollectBodyContext) {
                boolean bl3 = false;
                SessionHolder holder = this.getSessionHolder(propertyAccessor);
                BodyResolveContext.withPropertyAccessor$default(this.context, (FirProperty)propertyAccessor.getPropertySymbol().getFir(), propertyAccessor, holder, false, () -> ContextCollectorVisitor.visitPropertyAccessor$lambda$78$lambda$77$lambda$76(this, propertyAccessor, $this$visitPropertyAccessor_u24lambda_u2478), 8, null);
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv$iv.parents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitValueParameter(@NotNull FirValueParameter valueParameter2) {
        block7: {
            Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$withProcessor = false;
            ContextCollectorVisitor this_$iv$iv = this_$iv;
            boolean $i$f$withParent = false;
            this_$iv$iv.parents.add(valueParameter2);
            try {
                void this_$iv2;
                boolean bl = false;
                Processor $this$visitValueParameter_u24lambda_u2482 = new Processor(this_$iv);
                boolean bl2 = false;
                this.dumpContext(valueParameter2, ContextCollector.ContextKind.SELF);
                this.processAnnotations($this$visitValueParameter_u24lambda_u2482, valueParameter2);
                ContextCollectorVisitor this_$iv3 = this;
                boolean $i$f$onActiveBody = false;
                if (!this_$iv3.isActive && !this_$iv3.shouldCollectBodyContext) break block7;
                boolean bl3 = false;
                BodyResolveContext bodyResolveContext = this.context;
                FirSession session$iv = valueParameter2.getModuleData().getSession();
                boolean $i$f$withValueParameter = false;
                this_$iv2.storeValueParameterIfNeeded(valueParameter2, session$iv);
                void this_$iv$iv2 = this_$iv2;
                boolean $i$f$withContainer = false;
                this_$iv$iv2.getContainers().add(valueParameter2);
                try {
                    boolean bl4 = false;
                    this.dumpContext(valueParameter2, ContextCollector.ContextKind.BODY);
                    ContextCollectorVisitor this_$iv4 = this;
                    boolean $i$f$onActive = false;
                    if (this_$iv4.isActive) {
                        boolean bl5 = false;
                        $this$visitValueParameter_u24lambda_u2482.processChildren(valueParameter2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv$iv2.getContainers().removeLast();
                }
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv$iv.parents);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitAnonymousInitializer(@NotNull FirAnonymousInitializer anonymousInitializer) {
        block11: {
            Intrinsics.checkNotNullParameter(anonymousInitializer, "anonymousInitializer");
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$withProcessor = false;
            ContextCollectorVisitor this_$iv$iv = this_$iv;
            boolean $i$f$withParent = false;
            this_$iv$iv.parents.add(anonymousInitializer);
            try {
                void this_$iv2;
                boolean bl = false;
                Processor $this$visitAnonymousInitializer_u24lambda_u2486 = new Processor(this_$iv);
                boolean bl2 = false;
                this.dumpContext(anonymousInitializer, ContextCollector.ContextKind.SELF);
                this.processAnnotations($this$visitAnonymousInitializer_u24lambda_u2486, anonymousInitializer);
                ContextCollectorVisitor this_$iv3 = this;
                boolean $i$f$onActiveBody = false;
                if (!this_$iv3.isActive && !this_$iv3.shouldCollectBodyContext) break block11;
                boolean bl3 = false;
                BodyResolveContext bodyResolveContext = this.context;
                FirSession session$iv = anonymousInitializer.getModuleData().getSession();
                boolean $i$f$withAnonymousInitializer = false;
                void this_$iv$iv2 = this_$iv2;
                boolean $i$f$withTowerDataCleanup = false;
                FirTowerDataContext initialContext$iv$iv = this_$iv$iv2.getTowerDataContext();
                try {
                    Unit unit;
                    boolean bl4 = false;
                    FirLocalScope firLocalScope = this_$iv2.getPrimaryConstructorPureParametersScope();
                    if (firLocalScope != null) {
                        FirLocalScope it$iv = firLocalScope;
                        boolean bl5 = false;
                        this_$iv2.addLocalScope(it$iv);
                    }
                    this_$iv2.addLocalScope(new FirLocalScope(session$iv));
                    this_$iv2.addAnonymousInitializer(anonymousInitializer);
                    void this_$iv$iv3 = this_$iv2;
                    boolean $i$f$withContainer = false;
                    this_$iv$iv3.getContainers().add(anonymousInitializer);
                    try {
                        boolean bl6 = false;
                        this.dumpContext(anonymousInitializer, ContextCollector.ContextKind.BODY);
                        ContextCollectorVisitor this_$iv4 = this;
                        boolean $i$f$onActive = false;
                        if (this_$iv4.isActive) {
                            boolean bl7 = false;
                            FirLazyDeclarationResolverKt.lazyResolveToPhase(anonymousInitializer, FirResolvePhase.BODY_RESOLVE);
                            $this$visitAnonymousInitializer_u24lambda_u2486.processChildren(anonymousInitializer);
                        }
                        unit = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv$iv3.getContainers().removeLast();
                    }
                    Unit unit2 = unit;
                }
                finally {
                    this_$iv$iv2.replaceTowerDataContext(initialContext$iv$iv);
                }
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv$iv.parents);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction) {
        block13: {
            Intrinsics.checkNotNullParameter(anonymousFunction, "anonymousFunction");
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$withProcessor = false;
            ContextCollectorVisitor this_$iv$iv = this_$iv;
            boolean $i$f$withParent = false;
            this_$iv$iv.parents.add(anonymousFunction);
            try {
                boolean bl = false;
                Processor $this$visitAnonymousFunction_u24lambda_u2494 = new Processor(this_$iv);
                boolean bl2 = false;
                this.dumpContext(anonymousFunction, ContextCollector.ContextKind.SELF);
                this.processAnnotations($this$visitAnonymousFunction_u24lambda_u2494, anonymousFunction);
                ContextCollectorVisitor this_$iv2 = this;
                boolean $i$f$onActiveBody = false;
                if (!this_$iv2.isActive && !this_$iv2.shouldCollectBodyContext) break block13;
                boolean bl3 = false;
                BodyResolveContext this_$iv3 = this.context;
                boolean $i$f$withTypeParametersOf = false;
                if (((FirMemberDeclaration)anonymousFunction).getTypeParameters().isEmpty()) {
                    boolean bl4 = false;
                    $this$visitAnonymousFunction_u24lambda_u2494.processList((Collection<? extends FirElement>)anonymousFunction.getTypeParameters());
                    ContextCollectorVisitor this_$iv4 = this;
                    boolean $i$f$onActive = false;
                    if (this_$iv4.isActive) {
                        boolean bl5 = false;
                        $this$visitAnonymousFunction_u24lambda_u2494.process(anonymousFunction.getReceiverParameter());
                    }
                    this_$iv4 = this;
                    boolean $i$f$onActiveBody2 = false;
                    if (this_$iv4.isActive || this_$iv4.shouldCollectBodyContext) {
                        boolean bl6 = false;
                        this.context.withAnonymousFunction(anonymousFunction, this.bodyHolder, () -> ContextCollectorVisitor.visitAnonymousFunction$lambda$94$lambda$93$lambda$92$lambda$91$lambda$89(anonymousFunction, this, $this$visitAnonymousFunction_u24lambda_u2494));
                        ContextCollectorVisitor this_$iv5 = this;
                        boolean $i$f$onActive2 = false;
                        if (this_$iv5.isActive) {
                            boolean bl7 = false;
                            $this$visitAnonymousFunction_u24lambda_u2494.processChildren(anonymousFunction);
                        }
                    }
                    break block13;
                }
                FirMemberTypeParameterScope scope$iv = new FirMemberTypeParameterScope(anonymousFunction);
                BodyResolveContext this_$iv$iv2 = this_$iv3;
                boolean $i$f$withTowerDataCleanup = false;
                FirTowerDataContext initialContext$iv$iv = this_$iv$iv2.getTowerDataContext();
                try {
                    boolean bl8 = false;
                    this_$iv3.addNonLocalTowerDataElement(ImplicitReceiverUtilsKt.asTowerDataElement(scope$iv, false));
                    boolean bl9 = false;
                    $this$visitAnonymousFunction_u24lambda_u2494.processList((Collection<? extends FirElement>)anonymousFunction.getTypeParameters());
                    ContextCollectorVisitor this_$iv6 = this;
                    boolean $i$f$onActive = false;
                    if (this_$iv6.isActive) {
                        boolean bl10 = false;
                        $this$visitAnonymousFunction_u24lambda_u2494.process(anonymousFunction.getReceiverParameter());
                    }
                    this_$iv6 = this;
                    boolean $i$f$onActiveBody3 = false;
                    if (this_$iv6.isActive || this_$iv6.shouldCollectBodyContext) {
                        boolean bl11 = false;
                        this.context.withAnonymousFunction(anonymousFunction, this.bodyHolder, () -> ContextCollectorVisitor.visitAnonymousFunction$lambda$94$lambda$93$lambda$92$lambda$91$lambda$89(anonymousFunction, this, $this$visitAnonymousFunction_u24lambda_u2494));
                        ContextCollectorVisitor this_$iv7 = this;
                        boolean $i$f$onActive3 = false;
                        if (this_$iv7.isActive) {
                            boolean bl12 = false;
                            $this$visitAnonymousFunction_u24lambda_u2494.processChildren(anonymousFunction);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv$iv2.replaceTowerDataContext(initialContext$iv$iv);
                }
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv$iv.parents);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject) {
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv$iv = this_$iv;
        boolean $i$f$withParent = false;
        this_$iv$iv.parents.add(anonymousObject);
        try {
            boolean bl = false;
            Processor $this$visitAnonymousObject_u24lambda_u2498 = new Processor(this_$iv);
            boolean bl2 = false;
            this.dumpContext(anonymousObject, ContextCollector.ContextKind.SELF);
            this.processAnnotations($this$visitAnonymousObject_u24lambda_u2498, anonymousObject);
            ContextCollectorVisitor this_$iv2 = this;
            boolean $i$f$onActiveBody = false;
            if (this_$iv2.isActive || this_$iv2.shouldCollectBodyContext) {
                void this_$iv3;
                boolean bl3 = false;
                this.processAnonymousObjectHeader($this$visitAnonymousObject_u24lambda_u2498, anonymousObject);
                BodyResolveContext bodyResolveContext = this.context;
                SessionHolder holder$iv = this.bodyHolder;
                boolean $i$f$withAnonymousObject = false;
                this_$iv3.withScopesForClass(anonymousObject, holder$iv, (Function0)new Function0<Unit>((BodyResolveContext)this_$iv3, anonymousObject, this, anonymousObject, $this$visitAnonymousObject_u24lambda_u2498){
                    final /* synthetic */ BodyResolveContext this$0$inline_fun;
                    final /* synthetic */ FirAnonymousObject $anonymousObject;
                    final /* synthetic */ ContextCollectorVisitor this$0;
                    final /* synthetic */ FirAnonymousObject $anonymousObject$inlined;
                    final /* synthetic */ Processor $this_withProcessor$inlined;
                    {
                        this.this$0$inline_fun = $receiver;
                        this.$anonymousObject = $anonymousObject;
                        this.this$0 = contextCollectorVisitor;
                        this.$anonymousObject$inlined = firAnonymousObject;
                        this.$this_withProcessor$inlined = processor;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public final Unit invoke() {
                        Unit unit;
                        void this_$iv;
                        BodyResolveContext bodyResolveContext = this.this$0$inline_fun;
                        FirDeclaration declaration$iv = this.$anonymousObject;
                        boolean $i$f$withContainer = false;
                        this_$iv.getContainers().add(declaration$iv);
                        try {
                            boolean bl = false;
                            ContextCollectorVisitor.access$dumpContext(this.this$0, this.$anonymousObject$inlined, ContextCollector.ContextKind.BODY);
                            ContextCollectorVisitor this_$iv2 = this.this$0;
                            boolean $i$f$onActive = false;
                            if (ContextCollectorVisitor.access$isActive$p(this_$iv2)) {
                                boolean bl2 = false;
                                this.$this_withProcessor$inlined.processChildren(this.$anonymousObject$inlined);
                            }
                            unit = Unit.INSTANCE;
                        }
                        finally {
                            this_$iv.getContainers().removeLast();
                        }
                        return unit;
                    }
                });
            }
        }
        finally {
            CollectionsKt.removeLast((List)this_$iv$iv.parents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void visitBlock(@NotNull FirBlock block) {
        block6: {
            Intrinsics.checkNotNullParameter(block, "block");
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$withProcessor = false;
            ContextCollectorVisitor this_$iv$iv = this_$iv;
            boolean $i$f$withParent = false;
            this_$iv$iv.parents.add(block);
            try {
                void this_$iv2;
                boolean bl = false;
                Processor $this$visitBlock_u24lambda_u24101 = new Processor(this_$iv);
                boolean bl2 = false;
                this.dumpContext(block, ContextCollector.ContextKind.SELF);
                ContextCollectorVisitor this_$iv3 = this;
                boolean $i$f$onActiveBody = false;
                if (!this_$iv3.isActive && !this_$iv3.shouldCollectBodyContext) break block6;
                boolean bl3 = false;
                BodyResolveContext bodyResolveContext = this.context;
                FirSession session$iv = this.bodyHolder.getSession();
                boolean $i$f$forBlock = false;
                void this_$iv$iv2 = this_$iv2;
                boolean $i$f$withTowerDataCleanup = false;
                FirTowerDataContext initialContext$iv$iv = this_$iv$iv2.getTowerDataContext();
                try {
                    boolean bl4 = false;
                    this_$iv2.addLocalScope(new FirLocalScope(session$iv));
                    boolean bl5 = false;
                    $this$visitBlock_u24lambda_u24101.processChildren(block);
                    this.dumpContext(block, ContextCollector.ContextKind.BODY);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv$iv2.replaceTowerDataContext(initialContext$iv$iv);
                }
            }
            finally {
                CollectionsKt.removeLast((List)this_$iv$iv.parents);
            }
        }
    }

    private final void processRawAnnotations(Processor $this$processRawAnnotations, FirDeclaration declaration) {
        for (FirAnnotation annotation : declaration.getAnnotations()) {
            ContextCollectorVisitor this_$iv = this;
            boolean $i$f$onActive = false;
            if (!this_$iv.isActive) continue;
            boolean bl = false;
            $this$processRawAnnotations.process(annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processAnnotations(Processor $this$processAnnotations, FirDeclaration declaration) {
        BodyResolveContext this_$iv = this.context;
        boolean $i$f$withContainer = false;
        this_$iv.getContainers().add(declaration);
        try {
            boolean bl = false;
            this.processRawAnnotations($this$processAnnotations, declaration);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.getContainers().removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withProcessor(FirElement parent2, Function1<? super Processor, Unit> block) {
        boolean $i$f$withProcessor = false;
        ContextCollectorVisitor this_$iv = this;
        boolean $i$f$withParent = false;
        this_$iv.parents.add(parent2);
        try {
            boolean bl = false;
            block.invoke(new Processor(this));
        }
        finally {
            InlineMarker.finallyStart(1);
            CollectionsKt.removeLast((List)this_$iv.parents);
            InlineMarker.finallyEnd(1);
        }
    }

    private final void withInterceptor(Function0<Unit> block) {
        FirElement target;
        DesignationInterceptor designationInterceptor = this.designationPathInterceptor;
        FirElement firElement = target = designationInterceptor != null ? designationInterceptor.invoke() : null;
        if (target != null) {
            target.accept(this);
        } else {
            block.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withParent(FirElement parent2, Function0<Unit> block) {
        boolean $i$f$withParent = false;
        this.parents.add(parent2);
        try {
            block.invoke();
        }
        finally {
            InlineMarker.finallyStart(1);
            CollectionsKt.removeLast((List)this.parents);
            InlineMarker.finallyEnd(1);
        }
    }

    private final void onActive(Function0<Unit> block) {
        boolean $i$f$onActive = false;
        if (this.isActive) {
            block.invoke();
        }
    }

    private final void onActiveBody(Function0<Unit> block) {
        boolean $i$f$onActiveBody = false;
        if (this.isActive || this.shouldCollectBodyContext) {
            block.invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit collect$lambda$1(FirFile $file, ContextCollectorVisitor this$0) {
        void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
        ExceptionAttachmentBuilder exceptionAttachmentBuilder;
        String message$iv = "Designation path is empty";
        Throwable cause$iv = null;
        String attachmentName$iv = "info.txt";
        boolean $i$f$errorWithAttachment = false;
        boolean $i$f$buildErrorWithAttachment = false;
        KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
        KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
        boolean $i$f$buildAttachment = false;
        ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
        String string = attachmentName$iv;
        KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
        boolean bl = false;
        void $this$collect_u24lambda_u241_u24lambda_u240 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
        boolean bl2 = false;
        FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$collect_u24lambda_u241_u24lambda_u240, "file", $file);
        FirDesignationKt.withFirDesignationEntry((ExceptionAttachmentBuilder)$this$collect_u24lambda_u241_u24lambda_u240, "designation", this$0.designationPathInterceptor.getDesignation());
        kotlinExceptionWithAttachments.withAttachment(string, exceptionAttachmentBuilder.buildString());
        throw (Throwable)exception$iv$iv;
    }

    private static final Unit visitScript$lambda$12$lambda$11$lambda$10$lambda$9$lambda$8(Processor $this_withProcessor, FirScript $script) {
        $this_withProcessor.processChildren($script);
        return Unit.INSTANCE;
    }

    private static final Unit visitScript$lambda$12$lambda$11$lambda$10(ContextCollectorVisitor this$0, FirScript $script, Processor $this_withProcessor) {
        this$0.dumpContext($script, ContextCollector.ContextKind.BODY);
        ContextCollectorVisitor this_$iv = this$0;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl = false;
            this$0.withInterceptor(() -> ContextCollectorVisitor.visitScript$lambda$12$lambda$11$lambda$10$lambda$9$lambda$8($this_withProcessor, $script));
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitFile$lambda$16$lambda$15$lambda$14$lambda$13(Processor $this_withProcessor, FirFile $file) {
        $this_withProcessor.processChildren($file);
        return Unit.INSTANCE;
    }

    private static final Unit visitCodeFragment$lambda$17(ContextCollectorVisitor this$0, FirCodeFragment $codeFragment) {
        super.visitCodeFragment($codeFragment);
        return Unit.INSTANCE;
    }

    private static final Unit visitRegularClass$lambda$30$lambda$29$lambda$28$lambda$27$lambda$26$lambda$25(Processor $this_withProcessor, FirRegularClass $regularClass) {
        $this_withProcessor.processChildren($regularClass);
        return Unit.INSTANCE;
    }

    private static final Unit visitRegularClass$lambda$30$lambda$29$lambda$28$lambda$27(ContextCollectorVisitor this$0, FirRegularClass $regularClass, Processor $this_withProcessor) {
        this$0.dumpContext($regularClass, ContextCollector.ContextKind.BODY);
        ContextCollectorVisitor this_$iv = this$0;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl = false;
            this$0.withInterceptor(() -> ContextCollectorVisitor.visitRegularClass$lambda$30$lambda$29$lambda$28$lambda$27$lambda$26$lambda$25($this_withProcessor, $regularClass));
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitConstructor$lambda$41$lambda$40$lambda$39$lambda$35(Processor $this_withProcessor, FirConstructor $constructor, ContextCollectorVisitor this$0) {
        $this_withProcessor.processList((Collection<? extends FirElement>)$constructor.getValueParameters());
        this$0.dumpContext($constructor, ContextCollector.ContextKind.BODY);
        ContextCollectorVisitor this_$iv = this$0;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl = false;
            $this_withProcessor.process($constructor.getBody());
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitDanglingModifierList$lambda$50$lambda$49$lambda$48(ContextCollectorVisitor this$0, FirDanglingModifierList $danglingModifierList, Processor $this_withProcessor) {
        this$0.dumpContext($danglingModifierList, ContextCollector.ContextKind.BODY);
        ContextCollectorVisitor this_$iv = this$0;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl = false;
            $this_withProcessor.processChildren($danglingModifierList);
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitSimpleFunction$lambda$58$lambda$57$lambda$56$lambda$55$lambda$53(ContextCollectorVisitor this$0, FirSimpleFunction $simpleFunction, Processor $this_withProcessor) {
        this$0.dumpContext($simpleFunction, ContextCollector.ContextKind.BODY);
        $this_withProcessor.processList((Collection<? extends FirElement>)$simpleFunction.getContextParameters());
        $this_withProcessor.processList((Collection<? extends FirElement>)$simpleFunction.getValueParameters());
        ContextCollectorVisitor this_$iv = this$0;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl = false;
            $this_withProcessor.process($simpleFunction.getBody());
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitProperty$lambda$70$lambda$69$lambda$68$lambda$67$lambda$61(Processor $this_withProcessor, FirProperty $property) {
        $this_withProcessor.processList((Collection<? extends FirElement>)$property.getContextParameters());
        return Unit.INSTANCE;
    }

    private static final Unit visitProperty$lambda$70$lambda$69$lambda$68$lambda$67$lambda$66$lambda$64(Processor $this_withProcessor, FirProperty $property, ContextCollectorVisitor this$0) {
        $this_withProcessor.process($property.getInitializer());
        ContextCollectorVisitor this_$iv = this$0;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl = false;
            $this_withProcessor.process($property.getDelegate());
            ContextCollectorVisitor this_$iv2 = this$0;
            boolean $i$f$onActive2 = false;
            if (this_$iv2.isActive) {
                boolean bl2 = false;
                $this_withProcessor.process($property.getBackingField());
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitPropertyAccessor$lambda$78$lambda$77$lambda$76(ContextCollectorVisitor this$0, FirPropertyAccessor $propertyAccessor, Processor $this_withProcessor) {
        this$0.dumpContext($propertyAccessor, ContextCollector.ContextKind.BODY);
        ContextCollectorVisitor this_$iv = this$0;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl = false;
            $this_withProcessor.processChildren($propertyAccessor);
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitAnonymousFunction$lambda$94$lambda$93$lambda$92$lambda$91$lambda$89(FirAnonymousFunction $anonymousFunction, ContextCollectorVisitor this$0, Processor $this_withProcessor) {
        for (FirValueParameter contextParameter : $anonymousFunction.getContextParameters()) {
            this$0.context.storeValueParameterIfNeeded(contextParameter, this$0.bodyHolder.getSession());
        }
        for (FirValueParameter valueParameter2 : $anonymousFunction.getValueParameters()) {
            this$0.context.storeValueParameterIfNeeded(valueParameter2, this$0.bodyHolder.getSession());
        }
        this$0.dumpContext($anonymousFunction, ContextCollector.ContextKind.BODY);
        $this_withProcessor.processList((Collection<? extends FirElement>)$anonymousFunction.getContextParameters());
        $this_withProcessor.processList((Collection<? extends FirElement>)$anonymousFunction.getValueParameters());
        ContextCollectorVisitor this_$iv = this$0;
        boolean $i$f$onActive = false;
        if (this_$iv.isActive) {
            boolean bl = false;
            $this_withProcessor.process($anonymousFunction.getBody());
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$dumpContext(ContextCollectorVisitor $this, FirElement fir, ContextCollector.ContextKind kind) {
        $this.dumpContext(fir, kind);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollectorVisitor$ContextKey;", "", "element", "Lcom/intellij/psi/PsiElement;", "kind", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextKind;", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextKind;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getKind", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextKind;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "low-level-api-fir"})
    private static final class ContextKey {
        @NotNull
        private final PsiElement element;
        @NotNull
        private final ContextCollector.ContextKind kind;

        public ContextKey(@NotNull PsiElement element, @NotNull ContextCollector.ContextKind kind) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter((Object)kind, "kind");
            this.element = element;
            this.kind = kind;
        }

        @NotNull
        public final PsiElement getElement() {
            return this.element;
        }

        @NotNull
        public final ContextCollector.ContextKind getKind() {
            return this.kind;
        }

        @NotNull
        public final PsiElement component1() {
            return this.element;
        }

        @NotNull
        public final ContextCollector.ContextKind component2() {
            return this.kind;
        }

        @NotNull
        public final ContextKey copy(@NotNull PsiElement element, @NotNull ContextCollector.ContextKind kind) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter((Object)kind, "kind");
            return new ContextKey(element, kind);
        }

        public static /* synthetic */ ContextKey copy$default(ContextKey contextKey, PsiElement psiElement, ContextCollector.ContextKind contextKind, int n2, Object object) {
            if ((n2 & 1) != 0) {
                psiElement = contextKey.element;
            }
            if ((n2 & 2) != 0) {
                contextKind = contextKey.kind;
            }
            return contextKey.copy(psiElement, contextKind);
        }

        @NotNull
        public String toString() {
            return "ContextKey(element=" + this.element + ", kind=" + (Object)((Object)this.kind) + ')';
        }

        public int hashCode() {
            int result2 = this.element.hashCode();
            result2 = result2 * 31 + this.kind.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContextKey)) {
                return false;
            }
            ContextKey contextKey = (ContextKey)other;
            if (!Intrinsics.areEqual(this.element, contextKey.element)) {
                return false;
            }
            return this.kind == contextKey.kind;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollectorVisitor$FilteringVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "delegate", "elementsToSkip", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "<init>", "(Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;Ljava/util/Set;)V", "getDelegate", "()Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "getElementsToSkip", "()Ljava/util/Set;", "visitElement", "", "element", "low-level-api-fir"})
    private static final class FilteringVisitor
    extends FirVisitorVoid {
        @NotNull
        private final FirVisitorVoid delegate;
        @NotNull
        private final Set<FirElement> elementsToSkip;

        public FilteringVisitor(@NotNull FirVisitorVoid delegate, @NotNull Set<? extends FirElement> elementsToSkip) {
            Intrinsics.checkNotNullParameter(delegate, "delegate");
            Intrinsics.checkNotNullParameter(elementsToSkip, "elementsToSkip");
            this.delegate = delegate;
            this.elementsToSkip = elementsToSkip;
        }

        @NotNull
        public final FirVisitorVoid getDelegate() {
            return this.delegate;
        }

        @NotNull
        public final Set<FirElement> getElementsToSkip() {
            return this.elementsToSkip;
        }

        @Override
        public void visitElement(@NotNull FirElement element) {
            Intrinsics.checkNotNullParameter(element, "element");
            if (!this.elementsToSkip.contains(element)) {
                element.accept(this.delegate);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0007J\u0016\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollectorVisitor$Processor;", "", "delegate", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "<init>", "(Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;)V", "elementsToSkip", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/fir/FirElement;", "Lkotlin/collections/HashSet;", "process", "", "element", "processList", "elements", "", "processChildren", "low-level-api-fir"})
    private static final class Processor {
        @NotNull
        private final FirVisitorVoid delegate;
        @NotNull
        private final HashSet<FirElement> elementsToSkip;

        public Processor(@NotNull FirVisitorVoid delegate) {
            Intrinsics.checkNotNullParameter(delegate, "delegate");
            this.delegate = delegate;
            this.elementsToSkip = new HashSet();
        }

        public final void process(@Nullable FirElement element) {
            if (element != null) {
                element.accept(this.delegate);
                ((Collection)this.elementsToSkip).add(element);
            }
        }

        public final void processList(@NotNull Collection<? extends FirElement> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            for (FirElement firElement : elements) {
                this.process(firElement);
                ((Collection)this.elementsToSkip).add(firElement);
            }
        }

        public final void processChildren(@NotNull FirElement element) {
            Intrinsics.checkNotNullParameter(element, "element");
            FilteringVisitor visitor2 = new FilteringVisitor(this.delegate, (Set<? extends FirElement>)this.elementsToSkip);
            element.acceptChildren(visitor2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ContextCollector.ContextKind.values().length];
            try {
                nArray[ContextCollector.ContextKind.SELF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContextCollector.ContextKind.BODY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

