/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import java.lang.ref.WeakReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionValidityModificationTracker;
import org.jetbrains.kotlin.fir.BuiltinTypes;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH&J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001f\u001a\u00020\u001eJ\b\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\u0004\u0018\u00010\u001e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "Lorg/jetbrains/kotlin/fir/FirSession;", "ktModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "builtinTypes", "Lorg/jetbrains/kotlin/fir/BuiltinTypes;", "kind", "Lorg/jetbrains/kotlin/fir/FirSession$Kind;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;Lorg/jetbrains/kotlin/fir/BuiltinTypes;Lorg/jetbrains/kotlin/fir/FirSession$Kind;)V", "getKtModule", "()Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "getBuiltinTypes", "()Lorg/jetbrains/kotlin/fir/BuiltinTypes;", "getScopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "", "isValid", "()Z", "setValid$low_level_api_fir", "(Z)V", "createValidityTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "lazyDisposable", "Lkotlin/Lazy;", "Lcom/intellij/openapi/Disposable;", "requestDisposable", "requestedDisposableOrNull", "getRequestedDisposableOrNull$low_level_api_fir", "()Lcom/intellij/openapi/Disposable;", "toString", "", "low-level-api-fir"})
public abstract class LLFirSession
extends FirSession {
    @NotNull
    private final KaModule ktModule;
    @NotNull
    private final BuiltinTypes builtinTypes;
    private volatile boolean isValid;
    @NotNull
    private final Lazy<Disposable> lazyDisposable;

    public LLFirSession(@NotNull KaModule ktModule, @NotNull BuiltinTypes builtinTypes, @NotNull FirSession.Kind kind) {
        Intrinsics.checkNotNullParameter(ktModule, "ktModule");
        Intrinsics.checkNotNullParameter(builtinTypes, "builtinTypes");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        super(null, kind);
        this.ktModule = ktModule;
        this.builtinTypes = builtinTypes;
        this.isValid = true;
        this.lazyDisposable = LazyKt.lazy(() -> LLFirSession.lazyDisposable$lambda$0(this));
    }

    @NotNull
    public final KaModule getKtModule() {
        return this.ktModule;
    }

    @Override
    @NotNull
    public BuiltinTypes getBuiltinTypes() {
        return this.builtinTypes;
    }

    @NotNull
    public abstract ScopeSession getScopeSession();

    @NotNull
    public final Project getProject() {
        return this.ktModule.getProject();
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final void setValid$low_level_api_fir(boolean bl) {
        this.isValid = bl;
    }

    @NotNull
    public final ModificationTracker createValidityTracker() {
        return new LLFirSessionValidityModificationTracker(new WeakReference<LLFirSession>(this));
    }

    @NotNull
    public final Disposable requestDisposable() {
        return this.lazyDisposable.getValue();
    }

    @Nullable
    public final Disposable getRequestedDisposableOrNull$low_level_api_fir() {
        return this.lazyDisposable.isInitialized() ? this.lazyDisposable.getValue() : null;
    }

    @Override
    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + " for " + this.ktModule.getModuleDescription();
    }

    private static final Disposable lazyDisposable$lambda$0(LLFirSession this$0) {
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue(disposable, "newDisposable(...)");
        Disposable disposable2 = disposable;
        Disposer.register(LLFirSessionCache.Companion.getInstance(this$0.getProject()), disposable2);
        return disposable2;
    }
}

