/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.providers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDirectInheritorsProvider;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinModuleDependentsProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.low.level.api.fir.projectStructure.LLFirModuleDataKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.SealedClassInheritorsKt;
import org.jetbrains.kotlin.fir.declarations.SealedClassInheritorsProvider;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\r\u001a\u00020\u0010H\u0002J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLSealedInheritorsProvider;", "Lorg/jetbrains/kotlin/fir/declarations/SealedClassInheritorsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/name/ClassId;", "", "getCache", "()Ljava/util/concurrent/ConcurrentHashMap;", "getSealedClassInheritors", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "searchInheritors", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "searchInScope", "ktClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "classId", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "low-level-api-fir"})
public final class LLSealedInheritorsProvider
extends SealedClassInheritorsProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<ClassId, List<ClassId>> cache;

    public LLSealedInheritorsProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.project = project;
        this.cache = new ConcurrentHashMap();
    }

    @NotNull
    public final ConcurrentHashMap<ClassId, List<ClassId>> getCache() {
        return this.cache;
    }

    @Override
    @NotNull
    public List<ClassId> getSealedClassInheritors(@NotNull FirRegularClass firClass) {
        Intrinsics.checkNotNullParameter(firClass, "firClass");
        Lazy<List<ClassId>> lazy = SealedClassInheritorsKt.getSealedInheritorsAttr(firClass);
        if (lazy != null) {
            Lazy<List<ClassId>> it = lazy;
            boolean bl = false;
            return it.getValue();
        }
        ClassId classId = FirDeclarationUtilKt.getClassId(firClass);
        if (classId.isLocal()) {
            return CollectionsKt.emptyList();
        }
        List list = this.cache.computeIfAbsent(classId, arg_0 -> LLSealedInheritorsProvider.getSealedClassInheritors$lambda$2(arg_0 -> LLSealedInheritorsProvider.getSealedClassInheritors$lambda$1(this, firClass, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(list, "computeIfAbsent(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ClassId> searchInheritors(FirClass firClass) {
        GlobalSearchScope globalSearchScope;
        PsiElement psiElement = UtilsKt.getPsi(firClass);
        KtClass ktClass = psiElement instanceof KtClass ? (KtClass)psiElement : null;
        if (ktClass == null) {
            return CollectionsKt.emptyList();
        }
        KtClass ktClass2 = ktClass;
        KaModule classKtModule = LLFirModuleDataKt.getLlFirModuleData(firClass).getKtModule();
        KaModule ktModule = classKtModule instanceof KaDanglingFileModule ? ((KaDanglingFileModule)classKtModule).getContextModule() : classKtModule;
        FirMemberDeclaration $this$isExpect$iv = firClass;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            void $this$mapTo$iv$iv;
            Set<KaModule> refinementDependents = KotlinModuleDependentsProvider.Companion.getInstance(this.project).getRefinementDependents(ktModule);
            Iterable $this$map$iv = refinementDependents;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KaModule kaModule = (KaModule)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getContentScope());
            }
            globalSearchScope = GlobalSearchScope.union((Collection<? extends GlobalSearchScope>)CollectionsKt.plus((Collection)((List)destination$iv$iv), ktModule.getContentScope()));
        } else {
            globalSearchScope = ktModule.getContentScope();
        }
        GlobalSearchScope globalSearchScope2 = globalSearchScope;
        Intrinsics.checkNotNull(globalSearchScope2);
        GlobalSearchScope scope2 = globalSearchScope2;
        return this.searchInScope(ktClass2, FirDeclarationUtilKt.getClassId(firClass), scope2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ClassId> searchInScope(KtClass ktClass, ClassId classId, GlobalSearchScope scope2) {
        List list;
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        List list2 = KotlinDirectInheritorsProvider.Companion.getInstance(this.project).getDirectKotlinInheritors(ktClass, scope2, false);
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtClassOrObject it = (KtClassOrObject)element$iv$iv;
            boolean bl2 = false;
            if (it.getClassId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClassId it = (ClassId)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getPackageFqName(), classId.getPackageFqName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        list2 = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a2, T b2) {
                ClassId it = (ClassId)a2;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.toString());
                it = (ClassId)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.toString()));
            }
        });
        if (list2.isEmpty()) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        } else {
            list = list2;
        }
        return list;
    }

    private static final List getSealedClassInheritors$lambda$1(LLSealedInheritorsProvider this$0, FirRegularClass $firClass, ClassId it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.searchInheritors($firClass);
    }

    private static final List getSealedClassInheritors$lambda$2(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

