/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.DeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FirElementsRecorder;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FirElementContainerRecorder;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FirElementsRecorder;", "container", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declarationsToIgnore", "", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Ljava/util/Set;)V", "visitElement", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "low-level-api-fir"})
public abstract class FirElementContainerRecorder
extends FirElementsRecorder {
    @NotNull
    private final FirDeclaration container;
    @NotNull
    private final Set<FirDeclaration> declarationsToIgnore;

    public FirElementContainerRecorder(@NotNull FirDeclaration container, @NotNull Set<? extends FirDeclaration> declarationsToIgnore) {
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(declarationsToIgnore, "declarationsToIgnore");
        this.container = container;
        this.declarationsToIgnore = declarationsToIgnore;
    }

    @Override
    public void visitElement(@NotNull FirElement element, @NotNull Map<KtElement, FirElement> data2) {
        boolean recordElement;
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(data2, "data");
        if (element == this.container) {
            super.visitElement(element, data2);
            return;
        }
        boolean bl = element instanceof FirDeclaration ? !this.declarationsToIgnore.contains(element) : (recordElement = true);
        if (recordElement) {
            element.accept(DeclarationStructureElement.Recorder.INSTANCE, data2);
        }
    }
}

