/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProject;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00060\u0005\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R-\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/StandaloneAnalysisAPISession;", "", "kotlinCoreProjectEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "modulesWithFilesProvider", "Lkotlin/Function0;", "", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;", "", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;Lkotlin/jvm/functions/Function0;)V", "coreApplicationEnvironment", "Lcom/intellij/core/CoreApplicationEnvironment;", "getCoreApplicationEnvironment", "()Lcom/intellij/core/CoreApplicationEnvironment;", "application", "Lcom/intellij/openapi/application/Application;", "getApplication", "()Lcom/intellij/openapi/application/Application;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "modulesWithFiles", "getModulesWithFiles", "()Ljava/util/Map;", "modulesWithFiles$delegate", "Lkotlin/Lazy;", "analysis-api-standalone"})
public final class StandaloneAnalysisAPISession {
    @NotNull
    private final CoreApplicationEnvironment coreApplicationEnvironment;
    @NotNull
    private final Application application;
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy modulesWithFiles$delegate;

    public StandaloneAnalysisAPISession(@NotNull KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment, @NotNull Function0<? extends Map<KaSourceModule, ? extends List<? extends PsiFile>>> modulesWithFilesProvider) {
        Intrinsics.checkNotNullParameter(kotlinCoreProjectEnvironment, "kotlinCoreProjectEnvironment");
        Intrinsics.checkNotNullParameter(modulesWithFilesProvider, "modulesWithFilesProvider");
        CoreApplicationEnvironment coreApplicationEnvironment = kotlinCoreProjectEnvironment.getEnvironment();
        Intrinsics.checkNotNullExpressionValue(coreApplicationEnvironment, "getEnvironment(...)");
        this.coreApplicationEnvironment = coreApplicationEnvironment;
        MockApplication mockApplication = kotlinCoreProjectEnvironment.getEnvironment().getApplication();
        Intrinsics.checkNotNullExpressionValue(mockApplication, "getApplication(...)");
        this.application = mockApplication;
        MockProject mockProject = kotlinCoreProjectEnvironment.getProject();
        Intrinsics.checkNotNullExpressionValue(mockProject, "getProject(...)");
        this.project = mockProject;
        this.modulesWithFiles$delegate = LazyKt.lazy(modulesWithFilesProvider);
    }

    @NotNull
    public final CoreApplicationEnvironment getCoreApplicationEnvironment() {
        return this.coreApplicationEnvironment;
    }

    @NotNull
    public final Application getApplication() {
        return this.application;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Map<KaSourceModule, List<PsiFile>> getModulesWithFiles() {
        Lazy lazy = this.modulesWithFiles$delegate;
        return (Map)lazy.getValue();
    }
}

