/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.symbols.pointers;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaImplementationDetail;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.utils.KtSymbolUtilsKt;
import org.jetbrains.kotlin.analysis.api.impl.base.symbols.pointers.KaBaseCachedSymbolPointer;
import org.jetbrains.kotlin.analysis.api.symbols.KaFileSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaScriptSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.pointers.KaSymbolPointer;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0015J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/KaFirScriptSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBaseCachedSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaScriptSymbol;", "filePointer", "Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaFileSymbol;", "originalSymbol", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;Lorg/jetbrains/kotlin/analysis/api/symbols/KaScriptSymbol;)V", "restoreIfNotCached", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "pointsToTheSameSymbolAs", "", "other", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "analysis-api-fir"})
public final class KaFirScriptSymbolPointer
extends KaBaseCachedSymbolPointer<KaScriptSymbol> {
    @NotNull
    private final KaSymbolPointer<KaFileSymbol> filePointer;

    public KaFirScriptSymbolPointer(@NotNull KaSymbolPointer<? extends KaFileSymbol> filePointer, @Nullable KaScriptSymbol originalSymbol) {
        Intrinsics.checkNotNullParameter(filePointer, "filePointer");
        super((KaSymbol)originalSymbol);
        this.filePointer = filePointer;
    }

    @Override
    @KaImplementationDetail
    @Nullable
    protected KaScriptSymbol restoreIfNotCached(@NotNull KaSession analysisSession) {
        Object var6_6;
        Intrinsics.checkNotNullParameter(analysisSession, "analysisSession");
        if (!(analysisSession instanceof KaFirSession)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        KaFirSession $this$restoreIfNotCached_u24lambda_u240 = (KaFirSession)analysisSession;
        boolean bl = false;
        Object object = $this$restoreIfNotCached_u24lambda_u240.restoreSymbol(this.filePointer);
        Object v1 = object != null && (object = KtSymbolUtilsKt.getFirSymbol((KaSymbol)object)) != null ? ((FirBasedSymbol)object).getFir() : (var6_6 = null);
        FirFile firFile = var6_6 instanceof FirFile ? (FirFile)var6_6 : null;
        if (firFile == null) {
            return null;
        }
        FirFile file = firFile;
        FirDeclaration firDeclaration = CollectionsKt.singleOrNull(file.getDeclarations());
        FirScript firScript = firDeclaration instanceof FirScript ? (FirScript)firDeclaration : null;
        if (firScript == null) {
            return null;
        }
        FirScript script = firScript;
        return ((KaFirSession)analysisSession).getFirSymbolBuilder$analysis_api_fir().buildScriptSymbol(script.getSymbol());
    }

    @Override
    public boolean pointsToTheSameSymbolAs(@NotNull KaSymbolPointer<? extends KaSymbol> other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this == other || other instanceof KaFirScriptSymbolPointer && ((KaFirScriptSymbolPointer)other).filePointer.pointsToTheSameSymbolAs(this.filePointer);
    }
}

