/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.symbols.pointers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaImplementationDetail;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.utils.KtSymbolUtilsKt;
import org.jetbrains.kotlin.analysis.api.impl.base.symbols.pointers.KaBaseCachedSymbolPointer;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaEnumEntrySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.pointers.KaSymbolPointer;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0015J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/KaFirEnumEntrySymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBaseCachedSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaEnumEntrySymbol;", "ownerPointer", "Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;", "name", "Lorg/jetbrains/kotlin/name/Name;", "originalSymbol", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/analysis/api/symbols/KaEnumEntrySymbol;)V", "restoreIfNotCached", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "enumEntryByName", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "pointsToTheSameSymbolAs", "", "other", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "analysis-api-fir"})
public final class KaFirEnumEntrySymbolPointer
extends KaBaseCachedSymbolPointer<KaEnumEntrySymbol> {
    @NotNull
    private final KaSymbolPointer<KaClassSymbol> ownerPointer;
    @NotNull
    private final Name name;

    public KaFirEnumEntrySymbolPointer(@NotNull KaSymbolPointer<? extends KaClassSymbol> ownerPointer, @NotNull Name name, @Nullable KaEnumEntrySymbol originalSymbol) {
        Intrinsics.checkNotNullParameter(ownerPointer, "ownerPointer");
        Intrinsics.checkNotNullParameter(name, "name");
        super((KaSymbol)originalSymbol);
        this.ownerPointer = ownerPointer;
        this.name = name;
    }

    @Override
    @KaImplementationDetail
    @Nullable
    protected KaEnumEntrySymbol restoreIfNotCached(@NotNull KaSession analysisSession) {
        Intrinsics.checkNotNullParameter(analysisSession, "analysisSession");
        if (!(analysisSession instanceof KaFirSession)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        KaFirSession $this$restoreIfNotCached_u24lambda_u240 = (KaFirSession)analysisSession;
        boolean bl = false;
        KaClassSymbol owner = $this$restoreIfNotCached_u24lambda_u240.restoreSymbol(this.ownerPointer);
        Object object = owner;
        FirClass firClass = object != null && (object = KtSymbolUtilsKt.getFirSymbol((KaClassSymbol)object)) != null ? (FirClass)((FirBasedSymbol)object).getFir() : null;
        FirRegularClass firRegularClass = firClass instanceof FirRegularClass ? (FirRegularClass)firClass : null;
        if (firRegularClass == null) {
            return null;
        }
        FirRegularClass enumClass = firRegularClass;
        if (enumClass.getClassKind() != ClassKind.ENUM_CLASS) {
            return null;
        }
        FirEnumEntry firEnumEntry = this.enumEntryByName(enumClass, this.name);
        if (firEnumEntry == null) {
            return null;
        }
        FirEnumEntry enumEntry = firEnumEntry;
        return ((KaFirSession)analysisSession).getFirSymbolBuilder$analysis_api_fir().buildEnumEntrySymbol(enumEntry.getSymbol());
    }

    private final FirEnumEntry enumEntryByName(FirRegularClass $this$enumEntryByName, Name name) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$enumEntryByName.getDeclarations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirDeclaration member = (FirDeclaration)element$iv;
                boolean bl = false;
                if (!(member instanceof FirEnumEntry && Intrinsics.areEqual(((FirEnumEntry)member).getName(), name))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    public boolean pointsToTheSameSymbolAs(@NotNull KaSymbolPointer<? extends KaSymbol> other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return other == this || other instanceof KaFirEnumEntrySymbolPointer && Intrinsics.areEqual(((KaFirEnumEntrySymbolPointer)other).name, this.name) && ((KaFirEnumEntrySymbolPointer)other).ownerPointer.pointsToTheSameSymbolAs(this.ownerPointer);
    }
}

