/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KaUseSiteVisibilityChecker;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KaFirFileSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KaFirPsiJavaClassSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KaFirSymbol;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInaccessibleLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInvalidLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolVisibility;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.projectStructure.LLFirModuleDataKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001b\u0010\u0017\u001a\u0004\u0018\u00010\u0014*\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirUseSiteVisibilityChecker;", "Lorg/jetbrains/kotlin/analysis/api/components/KaUseSiteVisibilityChecker;", "positionModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "effectiveContainers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "dispatchReceiver", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "useSiteFile", "Lorg/jetbrains/kotlin/analysis/api/fir/symbols/KaFirFileSymbol;", "firResolveSession", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;Ljava/util/List;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/analysis/api/fir/symbols/KaFirFileSymbol;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;)V", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "isVisible", "", "candidateSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;", "isVisibleByPsi", "Lorg/jetbrains/kotlin/analysis/api/fir/symbols/KaFirPsiJavaClassSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/fir/symbols/KaFirPsiJavaClassSymbol;Lorg/jetbrains/kotlin/analysis/api/fir/symbols/KaFirFileSymbol;)Ljava/lang/Boolean;", "analysis-api-fir"})
final class KaFirUseSiteVisibilityChecker
implements KaUseSiteVisibilityChecker {
    @NotNull
    private final KaModule positionModule;
    @NotNull
    private final List<FirDeclaration> effectiveContainers;
    @Nullable
    private final FirExpression dispatchReceiver;
    @NotNull
    private final KaFirFileSymbol useSiteFile;
    @NotNull
    private final LLFirResolveSession firResolveSession;
    @NotNull
    private final KaLifetimeToken token;

    public KaFirUseSiteVisibilityChecker(@NotNull KaModule positionModule, @NotNull List<? extends FirDeclaration> effectiveContainers, @Nullable FirExpression dispatchReceiver, @NotNull KaFirFileSymbol useSiteFile, @NotNull LLFirResolveSession firResolveSession, @NotNull KaLifetimeToken token) {
        Intrinsics.checkNotNullParameter(positionModule, "positionModule");
        Intrinsics.checkNotNullParameter(effectiveContainers, "effectiveContainers");
        Intrinsics.checkNotNullParameter(useSiteFile, "useSiteFile");
        Intrinsics.checkNotNullParameter(firResolveSession, "firResolveSession");
        Intrinsics.checkNotNullParameter(token, "token");
        this.positionModule = positionModule;
        this.effectiveContainers = effectiveContainers;
        this.dispatchReceiver = dispatchReceiver;
        this.useSiteFile = useSiteFile;
        this.firResolveSession = firResolveSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KaLifetimeToken getToken() {
        return this.token;
    }

    @Override
    public boolean isVisible(@NotNull KaDeclarationSymbol candidateSymbol) {
        LLFirSession lLFirSession;
        FirExpression firExpression;
        Object it2;
        Intrinsics.checkNotNullParameter(candidateSymbol, "candidateSymbol");
        KaLifetimeOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        KaLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KaLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        KaLifetimeToken $this$assertIsValid$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsValid = false;
        if (!$this$assertIsValid$iv$iv$iv$iv.isValid()) {
            throw new KaInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValid$iv$iv$iv$iv + ": " + $this$assertIsValid$iv$iv$iv$iv.getInvalidationReason());
        }
        KaLifetimeToken $this$assertIsAccessible$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsAccessible = false;
        if (!$this$assertIsAccessible$iv$iv$iv$iv.isAccessible()) {
            throw new KaInaccessibleLifetimeOwnerAccessException($this$assertIsAccessible$iv$iv$iv$iv + " is inaccessible: " + $this$assertIsAccessible$iv$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        if (!(candidateSymbol instanceof KaFirSymbol)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (candidateSymbol instanceof KaFirPsiJavaClassSymbol) {
            Boolean bl2 = this.isVisibleByPsi((KaFirPsiJavaClassSymbol)candidateSymbol, this.useSiteFile);
            if (bl2 != null) {
                boolean it2 = bl2;
                boolean bl3 = false;
                return it2;
            }
        }
        FirMemberDeclaration firMemberDeclaration = (it2 = ((FirBasedSymbol)((KaFirSymbol)((Object)candidateSymbol)).getFirSymbol()).getFir()) instanceof FirMemberDeclaration ? (FirMemberDeclaration)it2 : null;
        if (firMemberDeclaration == null) {
            return true;
        }
        FirMemberDeclaration candidateDeclaration = firMemberDeclaration;
        boolean dispatchReceiverCanBeExplicit = candidateSymbol instanceof KaCallableSymbol && !((KaCallableSymbol)candidateSymbol).isExtension();
        boolean $i$f$runIf = false;
        if (dispatchReceiverCanBeExplicit) {
            boolean bl4 = false;
            firExpression = this.dispatchReceiver;
        } else {
            firExpression = null;
        }
        FirExpression explicitDispatchReceiver = firExpression;
        KaModule candidateModule = LLFirModuleDataKt.getLlFirModuleData(candidateDeclaration).getKtModule();
        if (this.positionModule instanceof KaDanglingFileModule && !Intrinsics.areEqual(candidateModule, this.positionModule)) {
            KaModule kaModule = this.positionModule;
            Intrinsics.checkNotNull(kaModule, "null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule");
            KaModule contextModule = ((KaDanglingFileModule)kaModule).getContextModule();
            lLFirSession = this.firResolveSession.getSessionFor(contextModule);
        } else {
            lLFirSession = this.firResolveSession.getSessionFor(this.positionModule);
        }
        LLFirSession effectiveSession = lLFirSession;
        return FirVisibilityChecker.isVisible$default(FirVisibilityCheckerKt.getVisibilityChecker(effectiveSession), candidateDeclaration, effectiveSession, (FirFile)((FirFileSymbol)this.useSiteFile.getFirSymbol()).getFir(), this.effectiveContainers, explicitDispatchReceiver, false, null, false, null, 480, null);
    }

    private final Boolean isVisibleByPsi(KaFirPsiJavaClassSymbol $this$isVisibleByPsi, KaFirFileSymbol useSiteFile) {
        Boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$isVisibleByPsi.getVisibility().ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                KaFirPsiJavaClassSymbol outerClass = $this$isVisibleByPsi.getOuterClass();
                if (outerClass == null) {
                    bl = true;
                    break;
                }
                bl = this.isVisibleByPsi(outerClass, useSiteFile);
                break;
            }
            case 3: {
                boolean isSamePackage = Intrinsics.areEqual($this$isVisibleByPsi.getClassId().getPackageFqName(), UtilsKt.getPackageFqName((FirFile)((FirFileSymbol)useSiteFile.getFirSymbol()).getFir()));
                if (!isSamePackage) {
                    bl = false;
                    break;
                }
                KaFirPsiJavaClassSymbol outerClass = $this$isVisibleByPsi.getOuterClass();
                if (outerClass == null) {
                    bl = true;
                    break;
                }
                bl = this.isVisibleByPsi(outerClass, useSiteFile);
                break;
            }
            default: {
                bl = null;
            }
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KaSymbolVisibility.values().length];
            try {
                nArray[KaSymbolVisibility.PRIVATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaSymbolVisibility.PUBLIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaSymbolVisibility.PACKAGE_PRIVATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

