/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KaImportOptimizer;
import org.jetbrains.kotlin.analysis.api.components.KaImportOptimizerResult;
import org.jetbrains.kotlin.analysis.api.fir.FirUtilsKt;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KaFirImportOptimizer;
import org.jetbrains.kotlin.analysis.api.fir.components.KaFirImportOptimizerKt;
import org.jetbrains.kotlin.analysis.api.fir.components.KaFirSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.components.TypeQualifier;
import org.jetbrains.kotlin.analysis.api.fir.references.KDocReferenceResolver;
import org.jetbrains.kotlin.analysis.api.fir.utils.KtSymbolUtilsKt;
import org.jetbrains.kotlin.analysis.api.impl.base.components.KaBaseSessionComponent;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInaccessibleLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInvalidLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaReceiverParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedError;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001\u0016B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirImportOptimizer;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseSessionComponent;", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "Lorg/jetbrains/kotlin/analysis/api/components/KaImportOptimizer;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirSessionComponent;", "analysisSessionProvider", "Lkotlin/Function0;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getAnalysisSessionProvider", "()Lkotlin/jvm/functions/Function0;", "analyzeImportsToOptimize", "Lorg/jetbrains/kotlin/analysis/api/components/KaImportOptimizerResult;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "importableFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "getImportableFqName", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;)Lorg/jetbrains/kotlin/name/FqName;", "collectReferencedEntities", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirImportOptimizer$ReferencedEntitiesResult;", "ReferencedEntitiesResult", "analysis-api-fir"})
public final class KaFirImportOptimizer
extends KaBaseSessionComponent<KaFirSession>
implements KaImportOptimizer,
KaFirSessionComponent {
    @NotNull
    private final Function0<KaFirSession> analysisSessionProvider;

    public KaFirImportOptimizer(@NotNull Function0<KaFirSession> analysisSessionProvider) {
        Intrinsics.checkNotNullParameter(analysisSessionProvider, "analysisSessionProvider");
        this.analysisSessionProvider = analysisSessionProvider;
    }

    @Override
    @NotNull
    public Function0<KaFirSession> getAnalysisSessionProvider() {
        return this.analysisSessionProvider;
    }

    @Override
    @NotNull
    public KaImportOptimizerResult analyzeImportsToOptimize(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter(file, "file");
        KaLifetimeOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        KaLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KaLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        KaLifetimeToken $this$assertIsValid$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsValid = false;
        if (!$this$assertIsValid$iv$iv$iv$iv.isValid()) {
            throw new KaInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValid$iv$iv$iv$iv + ": " + $this$assertIsValid$iv$iv$iv$iv.getInvalidationReason());
        }
        KaLifetimeToken $this$assertIsAccessible$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsAccessible = false;
        if (!$this$assertIsAccessible$iv$iv$iv$iv.isAccessible()) {
            throw new KaInaccessibleLifetimeOwnerAccessException($this$assertIsAccessible$iv$iv$iv$iv + " is inaccessible: " + $this$assertIsAccessible$iv$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        List<KtImportDirective> existingImports = file.getImportDirectives();
        if (existingImports.isEmpty()) {
            return new KaImportOptimizerResult(null, null, 3, null);
        }
        ReferencedEntitiesResult referencedEntitiesResult = this.collectReferencedEntities(file);
        Map<FqName, Set<Name>> usedDeclarations = referencedEntitiesResult.component1();
        Set<Name> unresolvedNames = referencedEntitiesResult.component2();
        return new KaImportOptimizerResult(usedDeclarations, unresolvedNames);
    }

    @Override
    @Nullable
    public FqName getImportableFqName(@NotNull KaSymbol $this$importableFqName) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter($this$importableFqName, "<this>");
        KaLifetimeOwner $this$withValidityAssertion$iv = $this$importableFqName;
        boolean $i$f$withValidityAssertion = false;
        KaLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KaLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        KaLifetimeToken $this$assertIsValid$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsValid = false;
        if (!$this$assertIsValid$iv$iv$iv$iv.isValid()) {
            throw new KaInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValid$iv$iv$iv$iv + ": " + $this$assertIsValid$iv$iv$iv$iv.getInvalidationReason());
        }
        KaLifetimeToken $this$assertIsAccessible$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsAccessible = false;
        if (!$this$assertIsAccessible$iv$iv$iv$iv.isAccessible()) {
            throw new KaInaccessibleLifetimeOwnerAccessException($this$assertIsAccessible$iv$iv$iv$iv + " is inaccessible: " + $this$assertIsAccessible$iv$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        KaSymbol kaSymbol = $this$importableFqName;
        if (kaSymbol instanceof KaClassLikeSymbol) {
            ClassId classId = ((KaClassLikeSymbol)$this$importableFqName).getClassId();
            fqName2 = classId != null ? classId.asSingleFqName() : null;
        } else {
            fqName2 = kaSymbol instanceof KaCallableSymbol ? org.jetbrains.kotlin.analysis.api.fir.utils.FirUtilsKt.computeImportableName(KtSymbolUtilsKt.getFirSymbol((KaCallableSymbol)$this$importableFqName)) : null;
        }
        return fqName2;
    }

    private final ReferencedEntitiesResult collectReferencedEntities(KtFile file) {
        FirFile firFile;
        FirFile $this$collectReferencedEntities_u24lambda_u242 = firFile = LowLevelFirApiFacadeKt.getOrBuildFirFile(file, this.getFirResolveSession());
        boolean bl = false;
        FirLazyDeclarationResolverKt.lazyResolveToPhaseRecursively($this$collectReferencedEntities_u24lambda_u242, FirResolvePhase.BODY_RESOLVE);
        FirFile firFile2 = firFile;
        Map usedImports = new LinkedHashMap();
        Set unresolvedNames = new LinkedHashSet();
        firFile2.accept(new FirVisitorVoid(unresolvedNames, usedImports){
            final /* synthetic */ Set<Name> $unresolvedNames;
            final /* synthetic */ Map<FqName, Set<Name>> $usedImports;
            {
                this.$unresolvedNames = $unresolvedNames;
                this.$usedImports = $usedImports;
            }

            public void visitElement(FirElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                element.acceptChildren(this);
            }

            public void visitFunctionCall(FirFunctionCall functionCall) {
                Intrinsics.checkNotNullParameter(functionCall, "functionCall");
                this.processFunctionCall(functionCall);
                super.visitFunctionCall(functionCall);
            }

            public void visitImplicitInvokeCall(FirImplicitInvokeCall implicitInvokeCall) {
                Intrinsics.checkNotNullParameter(implicitInvokeCall, "implicitInvokeCall");
                this.processImplicitFunctionCall(implicitInvokeCall);
                super.visitImplicitInvokeCall(implicitInvokeCall);
            }

            public void visitComponentCall(FirComponentCall componentCall) {
                Intrinsics.checkNotNullParameter(componentCall, "componentCall");
                this.processFunctionCall(componentCall);
                super.visitComponentCall(componentCall);
            }

            public void visitPropertyAccessExpression(FirPropertyAccessExpression propertyAccessExpression) {
                Intrinsics.checkNotNullParameter(propertyAccessExpression, "propertyAccessExpression");
                this.processPropertyAccessExpression(propertyAccessExpression);
                super.visitPropertyAccessExpression(propertyAccessExpression);
            }

            public void visitResolvedTypeRef(FirResolvedTypeRef resolvedTypeRef) {
                Intrinsics.checkNotNullParameter(resolvedTypeRef, "resolvedTypeRef");
                this.processTypeRef(resolvedTypeRef);
                FirTypeRef firTypeRef = resolvedTypeRef.getDelegatedTypeRef();
                if (firTypeRef != null) {
                    firTypeRef.accept(this);
                }
                super.visitTypeRef(resolvedTypeRef);
            }

            public void visitErrorTypeRef(FirErrorTypeRef errorTypeRef) {
                Intrinsics.checkNotNullParameter(errorTypeRef, "errorTypeRef");
                this.processTypeRef(errorTypeRef);
                this.processErrorTypeRef(errorTypeRef);
                FirTypeRef firTypeRef = errorTypeRef.getDelegatedTypeRef();
                if (firTypeRef != null) {
                    firTypeRef.accept(this);
                }
                super.visitErrorTypeRef(errorTypeRef);
            }

            public void visitCallableReferenceAccess(FirCallableReferenceAccess callableReferenceAccess) {
                Intrinsics.checkNotNullParameter(callableReferenceAccess, "callableReferenceAccess");
                this.processCallableReferenceAccess(callableReferenceAccess);
                super.visitCallableReferenceAccess(callableReferenceAccess);
            }

            public void visitResolvedQualifier(FirResolvedQualifier resolvedQualifier) {
                Intrinsics.checkNotNullParameter(resolvedQualifier, "resolvedQualifier");
                this.processResolvedQualifier(resolvedQualifier);
                super.visitResolvedQualifier(resolvedQualifier);
            }

            public void visitErrorResolvedQualifier(FirErrorResolvedQualifier errorResolvedQualifier) {
                Intrinsics.checkNotNullParameter(errorResolvedQualifier, "errorResolvedQualifier");
                this.processResolvedQualifier(errorResolvedQualifier);
                super.visitErrorResolvedQualifier(errorResolvedQualifier);
            }

            private final void processErrorNameReference(FirResolvable resolvable) {
                FirReference firReference = resolvable.getCalleeReference();
                FirErrorNamedReference firErrorNamedReference = firReference instanceof FirErrorNamedReference ? (FirErrorNamedReference)firReference : null;
                if (firErrorNamedReference == null) {
                    return;
                }
                FirErrorNamedReference nameReference = firErrorNamedReference;
                Name name = KaFirImportOptimizerKt.access$getUnresolvedName(nameReference);
                if (name == null) {
                    return;
                }
                Name name2 = name;
                ((Collection)this.$unresolvedNames).add(name2);
            }

            private final void processErrorTypeRef(FirErrorTypeRef typeRef) {
                ConeDiagnostic coneDiagnostic = typeRef.getDiagnostic();
                ConeUnresolvedError coneUnresolvedError = coneDiagnostic instanceof ConeUnresolvedError ? (ConeUnresolvedError)coneDiagnostic : null;
                if (coneUnresolvedError == null) {
                    return;
                }
                ConeUnresolvedError diagnostic = coneUnresolvedError;
                Name name = KaFirImportOptimizerKt.access$getUnresolvedName(diagnostic);
                if (name == null) {
                    return;
                }
                Name name2 = name;
                ((Collection)this.$unresolvedNames).add(name2);
            }

            private final void processFunctionCall(FirFunctionCall functionCall) {
                if (KaFirImportOptimizerKt.access$getDispatchedWithoutImport(functionCall)) {
                    return;
                }
                this.processErrorNameReference(functionCall);
                Name name = KaFirImportOptimizerKt.access$getFunctionReferenceName(functionCall);
                if (name == null) {
                    return;
                }
                Name referencesByName = name;
                this.saveCallable(functionCall, referencesByName);
            }

            private final void processImplicitFunctionCall(FirImplicitInvokeCall implicitInvokeCall) {
                this.processErrorNameReference(implicitInvokeCall);
                this.saveCallable(implicitInvokeCall, OperatorNameConventions.INVOKE);
            }

            private final void processPropertyAccessExpression(FirPropertyAccessExpression propertyAccessExpression) {
                if (KaFirImportOptimizerKt.access$getDispatchedWithoutImport(propertyAccessExpression)) {
                    return;
                }
                this.processErrorNameReference(propertyAccessExpression);
                Name name = KaFirImportOptimizerKt.access$getPropertyReferenceName(propertyAccessExpression);
                if (name == null) {
                    return;
                }
                Name referencedByName = name;
                this.saveCallable(propertyAccessExpression, referencedByName);
            }

            private final void processTypeRef(FirResolvedTypeRef resolvedTypeRef) {
                TypeQualifier typeQualifier = TypeQualifier.Companion.createFor(resolvedTypeRef);
                if (typeQualifier == null) {
                    return;
                }
                TypeQualifier wholeQualifier = typeQualifier;
                this.processTypeQualifier(wholeQualifier);
            }

            private final void processCallableReferenceAccess(FirCallableReferenceAccess callableReferenceAccess) {
                if (KaFirImportOptimizerKt.access$getDispatchedWithoutImport(callableReferenceAccess)) {
                    return;
                }
                this.processErrorNameReference(callableReferenceAccess);
                Name name = KaFirImportOptimizerKt.access$getCallableReferenceName(callableReferenceAccess);
                if (name == null) {
                    return;
                }
                Name referencedByName = name;
                this.saveCallable(callableReferenceAccess, referencedByName);
            }

            private final void processResolvedQualifier(FirResolvedQualifier resolvedQualifier) {
                TypeQualifier typeQualifier = TypeQualifier.Companion.createFor(resolvedQualifier);
                if (typeQualifier == null) {
                    return;
                }
                TypeQualifier wholeQualifier = typeQualifier;
                this.processTypeQualifier(wholeQualifier);
            }

            private final void processTypeQualifier(TypeQualifier qualifier) {
                TypeQualifier mostOuterTypeQualifier = SequencesKt.last(SequencesKt.generateSequence(qualifier, collectReferencedEntities.1::processTypeQualifier$lambda$0));
                if (mostOuterTypeQualifier.isQualified()) {
                    return;
                }
                this.saveType(mostOuterTypeQualifier);
            }

            private final void saveType(TypeQualifier qualifier) {
                FqName importableName = qualifier.getReferencedClassId().asSingleFqName();
                Name referencedByName = qualifier.getReferencedByName();
                KaFirImportOptimizer.access$collectReferencedEntities$saveReferencedItem(this.$usedImports, importableName, referencedByName);
            }

            private final void saveCallable(FirQualifiedAccessExpression qualifiedCall, Name referencedByName) {
                FqName fqName2 = this.importableNameForReferencedSymbol(qualifiedCall);
                if (fqName2 == null) {
                    return;
                }
                FqName importableName = fqName2;
                KaFirImportOptimizer.access$collectReferencedEntities$saveReferencedItem(this.$usedImports, importableName, referencedByName);
            }

            private final FqName importableNameForReferencedSymbol(FirQualifiedAccessExpression qualifiedCall) {
                FqName fqName2 = this.importableNameForImplicitlyDispatchedCallable(qualifiedCall);
                if (fqName2 == null) {
                    FirCallableSymbol firCallableSymbol = KaFirImportOptimizerKt.access$getReferencedCallableSymbol(qualifiedCall);
                    fqName2 = firCallableSymbol != null ? org.jetbrains.kotlin.analysis.api.fir.utils.FirUtilsKt.computeImportableName(firCallableSymbol) : null;
                }
                return fqName2;
            }

            private final FqName importableNameForImplicitlyDispatchedCallable(FirQualifiedAccessExpression $this$importableNameForImplicitlyDispatchedCallable) {
                FirExpression dispatchReceiver = $this$importableNameForImplicitlyDispatchedCallable.getDispatchReceiver();
                if (!(dispatchReceiver instanceof FirResolvedQualifier) || !FirUtilsKt.isImplicitDispatchReceiver((FirResolvedQualifier)dispatchReceiver)) {
                    return null;
                }
                ClassId classId = ((FirResolvedQualifier)dispatchReceiver).getClassId();
                if (classId == null) {
                    return null;
                }
                ClassId dispatcherClass = classId;
                Object object = KaFirImportOptimizerKt.access$getReferencedCallableSymbol($this$importableNameForImplicitlyDispatchedCallable);
                if (object == null || (object = ((FirCallableSymbol)object).getName()) == null) {
                    return null;
                }
                Object referencedSymbolName = object;
                return new CallableId(dispatcherClass, (Name)referencedSymbolName).asSingleFqName();
            }

            private static final TypeQualifier processTypeQualifier$lambda$0(TypeQualifier it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getOuterTypeQualifier();
            }
        });
        file.accept(new KtTreeVisitorVoid(this, unresolvedNames, usedImports){
            final /* synthetic */ KaFirImportOptimizer this$0;
            final /* synthetic */ Set<Name> $unresolvedNames;
            final /* synthetic */ Map<FqName, Set<Name>> $usedImports;
            {
                this.this$0 = $receiver;
                this.$unresolvedNames = $unresolvedNames;
                this.$usedImports = $usedImports;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                super.visitElement(element);
                if (element instanceof KDocLink) {
                    this.visitKDocLink((KDocLink)element);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void visitKDocLink(KDocLink docLink) {
                void $this$forEach$iv;
                List list;
                PsiElement $this$getChildOfType$iv = docLink;
                boolean $i$f$getChildOfType22 = false;
                KDocName kDocName = PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KDocName.class);
                if (kDocName == null) {
                    return;
                }
                KDocName docName = kDocName;
                FqName qualifiedNameAsFqName = docName.getQualifiedNameAsFqName();
                Object $i$f$getChildOfType22 = this.this$0.getAnalysisSession();
                Object object = this.$unresolvedNames;
                KaFirSession $this$visitKDocLink_u24lambda_u241 = (KaFirSession)$i$f$getChildOfType22;
                boolean bl = false;
                Collection<KaSymbol> resolvedSymbols = KDocReferenceResolver.INSTANCE.resolveKdocFqName$analysis_api_fir($this$visitKDocLink_u24lambda_u241.getUseSiteSession(), qualifiedNameAsFqName, qualifiedNameAsFqName, docLink);
                if (resolvedSymbols.isEmpty()) {
                    ((Collection)object).add(qualifiedNameAsFqName.shortName());
                    list = CollectionsKt.emptyList();
                } else {
                    void $this$flatMapTo$iv$iv;
                    Iterable $this$flatMap$iv = resolvedSymbols;
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                        KaSymbol it = (KaSymbol)element$iv$iv;
                        boolean bl2 = false;
                        Iterable list$iv$iv = this.toImportableFqNames(it, qualifiedNameAsFqName);
                        CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                }
                List importableNames = list;
                $i$f$getChildOfType22 = importableNames;
                object = this.$usedImports;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    FqName importableName = (FqName)element$iv;
                    boolean bl3 = false;
                    KaFirImportOptimizer.access$collectReferencedEntities$saveReferencedItem((Map)object, importableName, importableName.shortName());
                }
            }

            private final List<FqName> toImportableFqNames(KaSymbol symbol, FqName qualifiedNameAsFqName) {
                List<E> list;
                List<E> $this$toImportableFqNames_u24lambda_u243 = list = CollectionsKt.createListBuilder();
                boolean bl = false;
                KaSymbol kaSymbol = symbol;
                if (kaSymbol instanceof KaCallableSymbol) {
                    FqName classFqName;
                    CallableId callableId = ((KaCallableSymbol)symbol).getCallableId();
                    if (callableId == null) {
                        return CollectionsKt.emptyList();
                    }
                    CallableId callableId2 = callableId;
                    FqName fqName2 = callableId2.asSingleFqName();
                    ClassId classId = callableId2.getClassId();
                    FqName fqName3 = classFqName = classId != null ? classId.asSingleFqName() : null;
                    if (classFqName != null) {
                        if (!Intrinsics.areEqual(classFqName, qualifiedNameAsFqName)) {
                            ((Collection)$this$toImportableFqNames_u24lambda_u243).add(classFqName);
                        }
                    } else if (!Intrinsics.areEqual(fqName2, qualifiedNameAsFqName)) {
                        FqName receiverFqName;
                        ((Collection)$this$toImportableFqNames_u24lambda_u243).add(fqName2);
                        KaReceiverParameterSymbol kaReceiverParameterSymbol = ((KaCallableSymbol)symbol).getReceiverParameter();
                        KaType kaType = kaReceiverParameterSymbol != null ? kaReceiverParameterSymbol.getReturnType() : null;
                        KaClassType receiverClassType = kaType instanceof KaClassType ? (KaClassType)kaType : null;
                        Object object = receiverClassType;
                        FqName fqName4 = object != null && (object = ((KaClassType)object).getClassId()) != null ? ((ClassId)object).asSingleFqName() : (receiverFqName = null);
                        if (receiverFqName != null && qualifiedNameAsFqName.pathSegments().size() > 1) {
                            ((Collection)$this$toImportableFqNames_u24lambda_u243).add(receiverFqName);
                        }
                    }
                } else if (kaSymbol instanceof KaClassLikeSymbol) {
                    FqName fqName5;
                    ClassId classId = ((KaClassLikeSymbol)symbol).getClassId();
                    FqName fqName6 = fqName5 = classId != null ? classId.asSingleFqName() : null;
                    if (fqName5 != null && !Intrinsics.areEqual(fqName5, qualifiedNameAsFqName)) {
                        ((Collection)$this$toImportableFqNames_u24lambda_u243).add(fqName5);
                    }
                }
                return CollectionsKt.build(list);
            }
        });
        return new ReferencedEntitiesResult(usedImports, unresolvedNames);
    }

    private static final void collectReferencedEntities$saveReferencedItem(Map<FqName, Set<Name>> usedImports, FqName importableName, Name referencedByName) {
        Set set;
        Map<FqName, Set<Name>> $this$getOrPut$iv = usedImports;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(importableName);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new HashSet();
            $this$getOrPut$iv.put(importableName, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        ((Collection)set).add(referencedByName);
    }

    public static final /* synthetic */ void access$collectReferencedEntities$saveReferencedItem(Map usedImports, FqName importableName, Name referencedByName) {
        KaFirImportOptimizer.collectReferencedEntities$saveReferencedItem(usedImports, importableName, referencedByName);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J5\u0010\u0010\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirImportOptimizer$ReferencedEntitiesResult;", "", "usedImports", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/name/Name;", "unresolvedNames", "<init>", "(Ljava/util/Map;Ljava/util/Set;)V", "getUsedImports", "()Ljava/util/Map;", "getUnresolvedNames", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "analysis-api-fir"})
    private static final class ReferencedEntitiesResult {
        @NotNull
        private final Map<FqName, Set<Name>> usedImports;
        @NotNull
        private final Set<Name> unresolvedNames;

        public ReferencedEntitiesResult(@NotNull Map<FqName, ? extends Set<Name>> usedImports, @NotNull Set<Name> unresolvedNames) {
            Intrinsics.checkNotNullParameter(usedImports, "usedImports");
            Intrinsics.checkNotNullParameter(unresolvedNames, "unresolvedNames");
            this.usedImports = usedImports;
            this.unresolvedNames = unresolvedNames;
        }

        @NotNull
        public final Map<FqName, Set<Name>> getUsedImports() {
            return this.usedImports;
        }

        @NotNull
        public final Set<Name> getUnresolvedNames() {
            return this.unresolvedNames;
        }

        @NotNull
        public final Map<FqName, Set<Name>> component1() {
            return this.usedImports;
        }

        @NotNull
        public final Set<Name> component2() {
            return this.unresolvedNames;
        }

        @NotNull
        public final ReferencedEntitiesResult copy(@NotNull Map<FqName, ? extends Set<Name>> usedImports, @NotNull Set<Name> unresolvedNames) {
            Intrinsics.checkNotNullParameter(usedImports, "usedImports");
            Intrinsics.checkNotNullParameter(unresolvedNames, "unresolvedNames");
            return new ReferencedEntitiesResult(usedImports, unresolvedNames);
        }

        public static /* synthetic */ ReferencedEntitiesResult copy$default(ReferencedEntitiesResult referencedEntitiesResult, Map map2, Set set, int n2, Object object) {
            if ((n2 & 1) != 0) {
                map2 = referencedEntitiesResult.usedImports;
            }
            if ((n2 & 2) != 0) {
                set = referencedEntitiesResult.unresolvedNames;
            }
            return referencedEntitiesResult.copy(map2, set);
        }

        @NotNull
        public String toString() {
            return "ReferencedEntitiesResult(usedImports=" + this.usedImports + ", unresolvedNames=" + this.unresolvedNames + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.usedImports).hashCode();
            result2 = result2 * 31 + ((Object)this.unresolvedNames).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReferencedEntitiesResult)) {
                return false;
            }
            ReferencedEntitiesResult referencedEntitiesResult = (ReferencedEntitiesResult)other;
            if (!Intrinsics.areEqual(this.usedImports, referencedEntitiesResult.usedImports)) {
                return false;
            }
            return Intrinsics.areEqual(this.unresolvedNames, referencedEntitiesResult.unresolvedNames);
        }
    }
}

