/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.evt;

import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.stream.util.XMLEventConsumer;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.ri.EmptyIterator;
import org.codehaus.stax2.ri.evt.AttributeEventImpl;
import org.codehaus.stax2.ri.evt.CharactersEventImpl;
import org.codehaus.stax2.ri.evt.CommentEventImpl;
import org.codehaus.stax2.ri.evt.DTDEventImpl;
import org.codehaus.stax2.ri.evt.EndDocumentEventImpl;
import org.codehaus.stax2.ri.evt.EndElementEventImpl;
import org.codehaus.stax2.ri.evt.EntityReferenceEventImpl;
import org.codehaus.stax2.ri.evt.NamespaceEventImpl;
import org.codehaus.stax2.ri.evt.ProcInstrEventImpl;
import org.codehaus.stax2.ri.evt.StartDocumentEventImpl;
import org.codehaus.stax2.ri.evt.StartElementEventImpl;

public class Stax2EventAllocatorImpl
implements XMLEventAllocator {
    @Override
    public XMLEvent allocate(XMLStreamReader r2) throws XMLStreamException {
        Location loc = this.getLocation(r2);
        switch (r2.getEventType()) {
            case 12: {
                return new CharactersEventImpl(loc, r2.getText(), true);
            }
            case 4: {
                return new CharactersEventImpl(loc, r2.getText(), false);
            }
            case 5: {
                return new CommentEventImpl(loc, r2.getText());
            }
            case 11: {
                return this.createDTD(r2, loc);
            }
            case 8: {
                return new EndDocumentEventImpl(loc);
            }
            case 2: {
                return new EndElementEventImpl(loc, r2);
            }
            case 3: {
                return new ProcInstrEventImpl(loc, r2.getPITarget(), r2.getPIData());
            }
            case 6: {
                CharactersEventImpl ch = new CharactersEventImpl(loc, r2.getText(), false);
                ch.setWhitespaceStatus(true);
                return ch;
            }
            case 7: {
                return new StartDocumentEventImpl(loc, r2);
            }
            case 1: {
                return this.createStartElement(r2, loc);
            }
            case 9: {
                return this.createEntityReference(r2, loc);
            }
        }
        throw new XMLStreamException("Unrecognized event type " + r2.getEventType() + ".");
    }

    @Override
    public void allocate(XMLStreamReader r2, XMLEventConsumer consumer) throws XMLStreamException {
        consumer.add(this.allocate(r2));
    }

    @Override
    public XMLEventAllocator newInstance() {
        return new Stax2EventAllocatorImpl();
    }

    protected Location getLocation(XMLStreamReader r2) {
        return r2.getLocation();
    }

    protected EntityReference createEntityReference(XMLStreamReader r2, Location loc) throws XMLStreamException {
        return new EntityReferenceEventImpl(loc, r2.getLocalName());
    }

    protected DTD createDTD(XMLStreamReader r2, Location loc) throws XMLStreamException {
        if (r2 instanceof XMLStreamReader2) {
            XMLStreamReader2 sr2 = (XMLStreamReader2)r2;
            DTDInfo dtd = sr2.getDTDInfo();
            return new DTDEventImpl(loc, dtd.getDTDRootName(), dtd.getDTDSystemId(), dtd.getDTDPublicId(), dtd.getDTDInternalSubset(), dtd.getProcessedDTD());
        }
        return new DTDEventImpl(loc, null, r2.getText());
    }

    protected StartElement createStartElement(XMLStreamReader r2, Location loc) throws XMLStreamException {
        ArrayList<NamespaceEventImpl> ns;
        ArrayList<AttributeEventImpl> attrs;
        int attrCount;
        NamespaceContext nsCtxt = null;
        if (r2 instanceof XMLStreamReader2) {
            nsCtxt = ((XMLStreamReader2)r2).getNonTransientNamespaceContext();
        }
        if ((attrCount = r2.getAttributeCount()) < 1) {
            attrs = null;
        } else {
            attrs = new ArrayList<AttributeEventImpl>(attrCount);
            for (int i2 = 0; i2 < attrCount; ++i2) {
                QName aname = r2.getAttributeName(i2);
                attrs.add(new AttributeEventImpl(loc, aname, r2.getAttributeValue(i2), r2.isAttributeSpecified(i2)));
            }
        }
        int nsCount = r2.getNamespaceCount();
        if (nsCount < 1) {
            ns = null;
        } else {
            ns = new ArrayList<NamespaceEventImpl>(nsCount);
            for (int i3 = 0; i3 < nsCount; ++i3) {
                ns.add(NamespaceEventImpl.constructNamespace(loc, r2.getNamespacePrefix(i3), r2.getNamespaceURI(i3)));
            }
        }
        return StartElementEventImpl.construct(loc, r2.getName(), attrs == null ? EmptyIterator.getInstance() : attrs.iterator(), ns == null ? EmptyIterator.getInstance() : ns.iterator(), nsCtxt);
    }
}

