/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.evt;

import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.ri.evt.BaseEventImpl;

public class AttributeEventImpl
extends BaseEventImpl
implements Attribute {
    final QName mName;
    final String mValue;
    final boolean mWasSpecified;

    public AttributeEventImpl(Location loc, String localName, String uri, String prefix, String value2, boolean wasSpecified) {
        super(loc);
        this.mValue = value2;
        if (prefix == null) {
            this.mName = uri == null ? new QName(localName) : new QName(uri, localName);
        } else {
            if (uri == null) {
                uri = "";
            }
            this.mName = new QName(uri, localName, prefix);
        }
        this.mWasSpecified = wasSpecified;
    }

    public AttributeEventImpl(Location loc, QName name, String value2, boolean wasSpecified) {
        super(loc);
        this.mName = name;
        this.mValue = value2;
        this.mWasSpecified = wasSpecified;
    }

    @Override
    public int getEventType() {
        return 10;
    }

    @Override
    public boolean isAttribute() {
        return true;
    }

    @Override
    public void writeAsEncodedUnicode(Writer w2) throws XMLStreamException {
        String prefix = this.mName.getPrefix();
        try {
            if (prefix != null && prefix.length() > 0) {
                w2.write(prefix);
                w2.write(58);
            }
            w2.write(this.mName.getLocalPart());
            w2.write(61);
            w2.write(34);
            AttributeEventImpl.writeEscapedAttrValue(w2, this.mValue);
            w2.write(34);
        }
        catch (IOException ie) {
            this.throwFromIOE(ie);
        }
    }

    @Override
    public void writeUsing(XMLStreamWriter2 w2) throws XMLStreamException {
        QName n2 = this.mName;
        w2.writeAttribute(n2.getPrefix(), n2.getLocalPart(), n2.getNamespaceURI(), this.mValue);
    }

    @Override
    public String getDTDType() {
        return "CDATA";
    }

    @Override
    public QName getName() {
        return this.mName;
    }

    @Override
    public String getValue() {
        return this.mValue;
    }

    @Override
    public boolean isSpecified() {
        return this.mWasSpecified;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (!(o2 instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)o2;
        if (this.mName.equals(other.getName()) && this.mValue.equals(other.getValue()) && this.isSpecified() == other.isSpecified()) {
            return AttributeEventImpl.stringsWithNullsEqual(this.getDTDType(), other.getDTDType());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.mName.hashCode() ^ this.mValue.hashCode();
    }

    protected static void writeEscapedAttrValue(Writer w2, String value2) throws IOException {
        int i2 = 0;
        int len = value2.length();
        do {
            int start = i2;
            char c2 = '\u0000';
            while (i2 < len && (c2 = value2.charAt(i2)) != '<' && c2 != '&' && c2 != '\"') {
                ++i2;
            }
            int outLen = i2 - start;
            if (outLen > 0) {
                w2.write(value2, start, outLen);
            }
            if (i2 >= len) continue;
            if (c2 == '<') {
                w2.write("&lt;");
                continue;
            }
            if (c2 == '&') {
                w2.write("&amp;");
                continue;
            }
            if (c2 != '\"') continue;
            w2.write("&quot;");
        } while (++i2 < len);
    }
}

