/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableList;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.implementations.immutableList.AbstractPersistentList;
import kotlinx.collections.immutable.implementations.immutableList.BufferIterator;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVector;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import kotlinx.collections.immutable.internal.CommonFunctionsKt;
import kotlinx.collections.immutable.internal.ListImplementation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010*\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u0000\u0018\u0000 /*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0003:\u0001/B\u0017\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\t\u001a\u00028\u0000H\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00028\u0000H\u0017\u00a2\u0006\u0004\b\u000b\u0010\u000fJ+\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0015J\u001f\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0016\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0018\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\rH\u0096\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\r2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\r2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b \u0010\u001fJ\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000!2\u0006\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\"\u0010#J)\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020%0$H\u0017\u00a2\u0006\u0004\b'\u0010(J\u001d\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b)\u0010*J%\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00028\u0000H\u0017\u00a2\u0006\u0004\b+\u0010\u000fR\u001c\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010,R\u0014\u0010\u0016\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010."}, d2={"Lkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector;", "E", "Lkotlinx/collections/immutable/ImmutableList;", "Lkotlinx/collections/immutable/implementations/immutableList/AbstractPersistentList;", "", "", "buffer", "<init>", "([Ljava/lang/Object;)V", "element", "Lkotlinx/collections/immutable/PersistentList;", "add", "(Ljava/lang/Object;)Lkotlinx/collections/immutable/PersistentList;", "", "index", "(ILjava/lang/Object;)Lkotlinx/collections/immutable/PersistentList;", "", "c", "addAll", "(ILjava/util/Collection;)Lkotlinx/collections/immutable/PersistentList;", "elements", "(Ljava/util/Collection;)Lkotlinx/collections/immutable/PersistentList;", "size", "bufferOfSize", "(I)[Ljava/lang/Object;", "Lkotlinx/collections/immutable/PersistentList$Builder;", "builder", "()Lkotlinx/collections/immutable/PersistentList$Builder;", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "lastIndexOf", "", "listIterator", "(I)Ljava/util/ListIterator;", "Lkotlin/Function1;", "", "predicate", "removeAll", "(Lkotlin/jvm/functions/Function1;)Lkotlinx/collections/immutable/PersistentList;", "removeAt", "(I)Lkotlinx/collections/immutable/PersistentList;", "set", "[Ljava/lang/Object;", "getSize", "()I", "Companion"})
public final class SmallPersistentVector<E>
extends AbstractPersistentList<E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object[] buffer;
    @NotNull
    private static final SmallPersistentVector EMPTY;

    public SmallPersistentVector(@NotNull Object[] buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.buffer = buffer;
        CommonFunctionsKt.assert(this.buffer.length <= 32);
    }

    @Override
    public int getSize() {
        return this.buffer.length;
    }

    private final Object[] bufferOfSize(int size) {
        return new Object[size];
    }

    @Override
    @NotNull
    public PersistentList<E> add(E element) {
        if (this.size() < 32) {
            Object[] objectArray = Arrays.copyOf(this.buffer, this.size() + 1);
            Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
            Object[] newBuffer = objectArray;
            newBuffer[this.size()] = element;
            return new SmallPersistentVector<E>(newBuffer);
        }
        Object[] tail = UtilsKt.presizedBufferWith(element);
        return new PersistentVector(this.buffer, tail, this.size() + 1, 0);
    }

    @Override
    @NotNull
    public PersistentList<E> addAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (this.size() + elements.size() <= 32) {
            Object[] objectArray = Arrays.copyOf(this.buffer, this.size() + elements.size());
            Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
            Object[] newBuffer = objectArray;
            int index2 = this.size();
            for (E element : elements) {
                newBuffer[index2++] = element;
            }
            return new SmallPersistentVector<E>(newBuffer);
        }
        PersistentList $this$mutate$iv = this;
        boolean $i$f$mutate = false;
        PersistentList.Builder builder2 = $this$mutate$iv.builder();
        List it = builder2;
        boolean bl = false;
        it.addAll(elements);
        return builder2.build();
    }

    @Override
    @NotNull
    public PersistentList<E> removeAll(@NotNull Function1<? super E, Boolean> predicate) {
        PersistentList persistentList;
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        Object[] newBuffer = this.buffer;
        int newSize = this.size();
        boolean anyRemoved = false;
        int n2 = this.size();
        for (int index2 = 0; index2 < n2; ++index2) {
            Object element = this.buffer[index2];
            if (predicate.invoke(element).booleanValue()) {
                if (anyRemoved) continue;
                Intrinsics.checkNotNullExpressionValue(Arrays.copyOf(this.buffer, this.buffer.length), "copyOf(...)");
                newSize = index2;
                anyRemoved = true;
                continue;
            }
            if (!anyRemoved) continue;
            newBuffer[newSize++] = element;
        }
        int n3 = newSize;
        if (n3 == this.size()) {
            persistentList = this;
        } else if (n3 == 0) {
            persistentList = EMPTY;
        } else {
            Object[] objectArray = newBuffer;
            int n4 = 0;
            persistentList = new SmallPersistentVector<E>(ArraysKt.copyOfRange(objectArray, n4, newSize));
        }
        return persistentList;
    }

    @Override
    @NotNull
    public PersistentList<E> addAll(int index2, @NotNull Collection<? extends E> c2) {
        Intrinsics.checkNotNullParameter(c2, "c");
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index2, this.size());
        if (this.size() + c2.size() <= 32) {
            Object[] newBuffer = this.bufferOfSize(this.size() + c2.size());
            ArraysKt.copyInto$default(this.buffer, newBuffer, 0, 0, index2, 6, null);
            ArraysKt.copyInto(this.buffer, newBuffer, index2 + c2.size(), index2, this.size());
            int position = index2;
            for (E element : c2) {
                newBuffer[position++] = element;
            }
            return new SmallPersistentVector<E>(newBuffer);
        }
        PersistentList $this$mutate$iv = this;
        boolean $i$f$mutate = false;
        PersistentList.Builder builder2 = $this$mutate$iv.builder();
        List it = builder2;
        boolean bl = false;
        it.addAll(index2, c2);
        return builder2.build();
    }

    @Override
    @NotNull
    public PersistentList<E> add(int index2, E element) {
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index2, this.size());
        if (index2 == this.size()) {
            return this.add(element);
        }
        if (this.size() < 32) {
            Object[] newBuffer = this.bufferOfSize(this.size() + 1);
            ArraysKt.copyInto$default(this.buffer, newBuffer, 0, 0, index2, 6, null);
            ArraysKt.copyInto(this.buffer, newBuffer, index2 + 1, index2, this.size());
            newBuffer[index2] = element;
            return new SmallPersistentVector<E>(newBuffer);
        }
        Object[] objectArray = Arrays.copyOf(this.buffer, this.buffer.length);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        Object[] root = objectArray;
        ArraysKt.copyInto(this.buffer, root, index2 + 1, index2, this.size() - 1);
        root[index2] = element;
        Object[] tail = UtilsKt.presizedBufferWith(this.buffer[31]);
        return new PersistentVector(root, tail, this.size() + 1, 0);
    }

    @Override
    @NotNull
    public PersistentList<E> removeAt(int index2) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index2, this.size());
        if (this.size() == 1) {
            return EMPTY;
        }
        Object[] objectArray = Arrays.copyOf(this.buffer, this.size() - 1);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        Object[] newBuffer = objectArray;
        ArraysKt.copyInto(this.buffer, newBuffer, index2, index2 + 1, this.size());
        return new SmallPersistentVector<E>(newBuffer);
    }

    @Override
    @NotNull
    public PersistentList.Builder<E> builder() {
        return new PersistentVectorBuilder(this, null, this.buffer, 0);
    }

    @Override
    public int indexOf(Object element) {
        return ArraysKt.indexOf(this.buffer, element);
    }

    @Override
    public int lastIndexOf(Object element) {
        return ArraysKt.lastIndexOf(this.buffer, element);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index2) {
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index2, this.size());
        return new BufferIterator<Object>(this.buffer, index2, this.size());
    }

    @Override
    public E get(int index2) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index2, this.size());
        return (E)this.buffer[index2];
    }

    @Override
    @NotNull
    public PersistentList<E> set(int index2, E element) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index2, this.size());
        Object[] objectArray = Arrays.copyOf(this.buffer, this.buffer.length);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        Object[] newBuffer = objectArray;
        newBuffer[index2] = element;
        return new SmallPersistentVector<E>(newBuffer);
    }

    static {
        boolean $i$f$emptyArray = false;
        EMPTY = new SmallPersistentVector(new Object[0]);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t"}, d2={"Lkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector$Companion;", "", "<init>", "()V", "Lkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector;", "", "EMPTY", "Lkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector;", "getEMPTY", "()Lkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SmallPersistentVector getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

