/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableList;

import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableListIterator;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.implementations.immutableList.AbstractListIterator;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import kotlinx.collections.immutable.implementations.immutableList.TrieIterator;
import kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0003B\u001d\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0010\u0010\u0011\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u000fJ\u000f\u0010\u0015\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u000fJ\u0017\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0016\u0010\rJ\u000f\u0010\u0017\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u000fR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR\u001e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001c8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e"}, d2={"Lkotlinx/collections/immutable/implementations/immutableList/PersistentVectorMutableIterator;", "T", "", "Lkotlinx/collections/immutable/implementations/immutableList/AbstractListIterator;", "Lkotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;", "builder", "", "index", "<init>", "(Lkotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;I)V", "element", "", "add", "(Ljava/lang/Object;)V", "checkForComodification", "()V", "checkHasIterated", "next", "()Ljava/lang/Object;", "previous", "remove", "reset", "set", "setupTrieIterator", "Lkotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;", "expectedModCount", "I", "lastIteratedIndex", "Lkotlinx/collections/immutable/implementations/immutableList/TrieIterator;", "trieIterator", "Lkotlinx/collections/immutable/implementations/immutableList/TrieIterator;"})
public final class PersistentVectorMutableIterator<T>
extends AbstractListIterator<T>
implements ListIterator<T>,
KMutableListIterator {
    @NotNull
    private final PersistentVectorBuilder<T> builder;
    private int expectedModCount;
    @Nullable
    private TrieIterator<? extends T> trieIterator;
    private int lastIteratedIndex;

    public PersistentVectorMutableIterator(@NotNull PersistentVectorBuilder<T> builder2, int index2) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        super(index2, builder2.size());
        this.builder = builder2;
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
        this.lastIteratedIndex = -1;
        this.setupTrieIterator();
    }

    @Override
    public T previous() {
        this.checkForComodification();
        this.checkHasPrevious$kotlinx_collections_immutable();
        this.lastIteratedIndex = this.getIndex() - 1;
        TrieIterator<T> trieIterator = this.trieIterator;
        if (trieIterator == null) {
            Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
            this.setIndex(this.getIndex() + -1);
            return (T)objectArray[this.getIndex()];
        }
        TrieIterator<T> trieIterator2 = trieIterator;
        if (this.getIndex() > trieIterator2.getSize()) {
            Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
            this.setIndex(this.getIndex() + -1);
            return (T)objectArray[this.getIndex() - trieIterator2.getSize()];
        }
        int n2 = this.getIndex();
        this.setIndex(n2 + -1);
        return trieIterator2.previous();
    }

    @Override
    public T next() {
        this.checkForComodification();
        this.checkHasNext$kotlinx_collections_immutable();
        this.lastIteratedIndex = this.getIndex();
        TrieIterator<T> trieIterator = this.trieIterator;
        if (trieIterator == null) {
            Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
            int n2 = this.getIndex();
            this.setIndex(n2 + 1);
            return (T)objectArray[n2];
        }
        TrieIterator<T> trieIterator2 = trieIterator;
        if (trieIterator2.hasNext()) {
            int n3 = this.getIndex();
            this.setIndex(n3 + 1);
            return trieIterator2.next();
        }
        Object[] objectArray = this.builder.getTail$kotlinx_collections_immutable();
        int n4 = this.getIndex();
        this.setIndex(n4 + 1);
        return (T)objectArray[n4 - trieIterator2.getSize()];
    }

    private final void reset() {
        this.setSize(this.builder.size());
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
        this.lastIteratedIndex = -1;
        this.setupTrieIterator();
    }

    private final void setupTrieIterator() {
        Object[] root = this.builder.getRoot$kotlinx_collections_immutable();
        if (root == null) {
            this.trieIterator = null;
            return;
        }
        int trieSize = UtilsKt.rootSize(this.builder.size());
        int trieIndex = RangesKt.coerceAtMost(this.getIndex(), trieSize);
        int trieHeight = this.builder.getRootShift$kotlinx_collections_immutable() / 5 + 1;
        if (this.trieIterator == null) {
            this.trieIterator = new TrieIterator(root, trieIndex, trieSize, trieHeight);
        } else {
            TrieIterator<T> trieIterator = this.trieIterator;
            Intrinsics.checkNotNull(trieIterator);
            trieIterator.reset$kotlinx_collections_immutable(root, trieIndex, trieSize, trieHeight);
        }
    }

    @Override
    public void add(T element) {
        this.checkForComodification();
        this.builder.add(this.getIndex(), element);
        int n2 = this.getIndex();
        this.setIndex(n2 + 1);
        this.reset();
    }

    @Override
    public void remove() {
        this.checkForComodification();
        this.checkHasIterated();
        this.builder.remove(this.lastIteratedIndex);
        if (this.lastIteratedIndex < this.getIndex()) {
            this.setIndex(this.lastIteratedIndex);
        }
        this.reset();
    }

    @Override
    public void set(T element) {
        this.checkForComodification();
        this.checkHasIterated();
        this.builder.set(this.lastIteratedIndex, element);
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
        this.setupTrieIterator();
    }

    private final void checkForComodification() {
        if (this.expectedModCount != this.builder.getModCount$kotlinx_collections_immutable()) {
            throw new ConcurrentModificationException();
        }
    }

    private final void checkHasIterated() {
        if (this.lastIteratedIndex == -1) {
            throw new IllegalStateException();
        }
    }
}

