/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableList;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.implementations.immutableList.AbstractListIterator;
import kotlinx.collections.immutable.implementations.immutableList.TrieIterator;
import kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B=\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\bX\u0089\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0010R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013"}, d2={"Lkotlinx/collections/immutable/implementations/immutableList/PersistentVectorIterator;", "T", "Lkotlinx/collections/immutable/implementations/immutableList/AbstractListIterator;", "", "", "root", "tail", "", "index", "size", "trieHeight", "<init>", "([Ljava/lang/Object;[Ljava/lang/Object;III)V", "next", "()Ljava/lang/Object;", "previous", "[Ljava/lang/Object;", "Lkotlinx/collections/immutable/implementations/immutableList/TrieIterator;", "trieIterator", "Lkotlinx/collections/immutable/implementations/immutableList/TrieIterator;"})
public final class PersistentVectorIterator<T>
extends AbstractListIterator<T> {
    @NotNull
    public final T[] tail;
    @NotNull
    private final TrieIterator<T> trieIterator;

    public PersistentVectorIterator(@NotNull Object[] root, @NotNull T[] tail, int index2, int size, int trieHeight) {
        Intrinsics.checkNotNullParameter(root, "root");
        Intrinsics.checkNotNullParameter(tail, "tail");
        super(index2, size);
        this.tail = tail;
        int trieSize = UtilsKt.rootSize(size);
        int trieIndex = RangesKt.coerceAtMost(index2, trieSize);
        this.trieIterator = new TrieIterator(root, trieIndex, trieSize, trieHeight);
    }

    @Override
    public T next() {
        this.checkHasNext$kotlinx_collections_immutable();
        if (this.trieIterator.hasNext()) {
            int n2 = this.getIndex();
            this.setIndex(n2 + 1);
            return this.trieIterator.next();
        }
        int n3 = this.getIndex();
        this.setIndex(n3 + 1);
        return this.tail[n3 - this.trieIterator.getSize()];
    }

    @Override
    public T previous() {
        this.checkHasPrevious$kotlinx_collections_immutable();
        if (this.getIndex() > this.trieIterator.getSize()) {
            this.setIndex(this.getIndex() + -1);
            return this.tail[this.getIndex() - this.trieIterator.getSize()];
        }
        int n2 = this.getIndex();
        this.setIndex(n2 + -1);
        return this.trieIterator.previous();
    }
}

