/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

public final class OperatorNameConventions {
    @NotNull
    public static final OperatorNameConventions INSTANCE = new OperatorNameConventions();
    @NotNull
    public static final Name GET_VALUE;
    @NotNull
    public static final Name SET_VALUE;
    @NotNull
    public static final Name PROVIDE_DELEGATE;
    @NotNull
    public static final Name EQUALS;
    @NotNull
    public static final Name COMPARE_TO;
    @NotNull
    public static final Name CONTAINS;
    @NotNull
    public static final Name INVOKE;
    @NotNull
    public static final Name ITERATOR;
    @NotNull
    public static final Name GET;
    @NotNull
    public static final Name SET;
    @NotNull
    public static final Name NEXT;
    @NotNull
    public static final Name HAS_NEXT;
    @NotNull
    public static final Name TO_STRING;
    @NotNull
    public static final Regex COMPONENT_REGEX;
    @NotNull
    public static final Name AND;
    @NotNull
    public static final Name OR;
    @NotNull
    public static final Name XOR;
    @NotNull
    public static final Name INV;
    @NotNull
    public static final Name SHL;
    @NotNull
    public static final Name SHR;
    @NotNull
    public static final Name USHR;
    @NotNull
    public static final Name INC;
    @NotNull
    public static final Name DEC;
    @NotNull
    public static final Name PLUS;
    @NotNull
    public static final Name MINUS;
    @NotNull
    public static final Name NOT;
    @NotNull
    public static final Name UNARY_MINUS;
    @NotNull
    public static final Name UNARY_PLUS;
    @NotNull
    public static final Name TIMES;
    @NotNull
    public static final Name DIV;
    @NotNull
    public static final Name MOD;
    @NotNull
    public static final Name REM;
    @NotNull
    public static final Name RANGE_TO;
    @NotNull
    public static final Name TIMES_ASSIGN;
    @NotNull
    public static final Name DIV_ASSIGN;
    @NotNull
    public static final Name MOD_ASSIGN;
    @NotNull
    public static final Name REM_ASSIGN;
    @NotNull
    public static final Name PLUS_ASSIGN;
    @NotNull
    public static final Name MINUS_ASSIGN;
    @NotNull
    public static final Set<Name> UNARY_OPERATION_NAMES;
    @NotNull
    public static final Set<Name> SIMPLE_UNARY_OPERATION_NAMES;
    @NotNull
    public static final Set<Name> BINARY_OPERATION_NAMES;
    @NotNull
    public static final Set<Name> ASSIGNMENT_OPERATIONS;
    @NotNull
    public static final Set<Name> DELEGATED_PROPERTY_OPERATORS;

    private OperatorNameConventions() {
    }

    static {
        Name[] nameArray = Name.identifier("getValue");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"getValue\")");
        GET_VALUE = nameArray;
        nameArray = Name.identifier("setValue");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"setValue\")");
        SET_VALUE = nameArray;
        nameArray = Name.identifier("provideDelegate");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"provideDelegate\")");
        PROVIDE_DELEGATE = nameArray;
        nameArray = Name.identifier("equals");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"equals\")");
        EQUALS = nameArray;
        nameArray = Name.identifier("compareTo");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"compareTo\")");
        COMPARE_TO = nameArray;
        nameArray = Name.identifier("contains");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"contains\")");
        CONTAINS = nameArray;
        nameArray = Name.identifier("invoke");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"invoke\")");
        INVOKE = nameArray;
        nameArray = Name.identifier("iterator");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"iterator\")");
        ITERATOR = nameArray;
        nameArray = Name.identifier("get");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"get\")");
        GET = nameArray;
        nameArray = Name.identifier("set");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"set\")");
        SET = nameArray;
        nameArray = Name.identifier("next");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"next\")");
        NEXT = nameArray;
        nameArray = Name.identifier("hasNext");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"hasNext\")");
        HAS_NEXT = nameArray;
        nameArray = Name.identifier("toString");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"toString\")");
        TO_STRING = nameArray;
        COMPONENT_REGEX = new Regex("component\\d+");
        nameArray = Name.identifier("and");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"and\")");
        AND = nameArray;
        nameArray = Name.identifier("or");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"or\")");
        OR = nameArray;
        nameArray = Name.identifier("xor");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"xor\")");
        XOR = nameArray;
        nameArray = Name.identifier("inv");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"inv\")");
        INV = nameArray;
        nameArray = Name.identifier("shl");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"shl\")");
        SHL = nameArray;
        nameArray = Name.identifier("shr");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"shr\")");
        SHR = nameArray;
        nameArray = Name.identifier("ushr");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"ushr\")");
        USHR = nameArray;
        nameArray = Name.identifier("inc");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"inc\")");
        INC = nameArray;
        nameArray = Name.identifier("dec");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"dec\")");
        DEC = nameArray;
        nameArray = Name.identifier("plus");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"plus\")");
        PLUS = nameArray;
        nameArray = Name.identifier("minus");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"minus\")");
        MINUS = nameArray;
        nameArray = Name.identifier("not");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"not\")");
        NOT = nameArray;
        nameArray = Name.identifier("unaryMinus");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"unaryMinus\")");
        UNARY_MINUS = nameArray;
        nameArray = Name.identifier("unaryPlus");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"unaryPlus\")");
        UNARY_PLUS = nameArray;
        nameArray = Name.identifier("times");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"times\")");
        TIMES = nameArray;
        nameArray = Name.identifier("div");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"div\")");
        DIV = nameArray;
        nameArray = Name.identifier("mod");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"mod\")");
        MOD = nameArray;
        nameArray = Name.identifier("rem");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"rem\")");
        REM = nameArray;
        nameArray = Name.identifier("rangeTo");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"rangeTo\")");
        RANGE_TO = nameArray;
        nameArray = Name.identifier("timesAssign");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"timesAssign\")");
        TIMES_ASSIGN = nameArray;
        nameArray = Name.identifier("divAssign");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"divAssign\")");
        DIV_ASSIGN = nameArray;
        nameArray = Name.identifier("modAssign");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"modAssign\")");
        MOD_ASSIGN = nameArray;
        nameArray = Name.identifier("remAssign");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"remAssign\")");
        REM_ASSIGN = nameArray;
        nameArray = Name.identifier("plusAssign");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"plusAssign\")");
        PLUS_ASSIGN = nameArray;
        nameArray = Name.identifier("minusAssign");
        Intrinsics.checkNotNullExpressionValue(nameArray, "identifier(\"minusAssign\")");
        MINUS_ASSIGN = nameArray;
        nameArray = new Name[]{INC, DEC, UNARY_PLUS, UNARY_MINUS, NOT};
        UNARY_OPERATION_NAMES = SetsKt.setOf(nameArray);
        nameArray = new Name[]{UNARY_PLUS, UNARY_MINUS, NOT};
        SIMPLE_UNARY_OPERATION_NAMES = SetsKt.setOf(nameArray);
        nameArray = new Name[]{TIMES, PLUS, MINUS, DIV, MOD, REM, RANGE_TO};
        BINARY_OPERATION_NAMES = SetsKt.setOf(nameArray);
        nameArray = new Name[]{TIMES_ASSIGN, DIV_ASSIGN, MOD_ASSIGN, REM_ASSIGN, PLUS_ASSIGN, MINUS_ASSIGN};
        ASSIGNMENT_OPERATIONS = SetsKt.setOf(nameArray);
        nameArray = new Name[]{GET_VALUE, SET_VALUE, PROVIDE_DELEGATE};
        DELEGATED_PROPERTY_OPERATORS = SetsKt.setOf(nameArray);
    }
}

