/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorEquivalenceForOverrides;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.OverridingUtil;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorEquivalenceForOverrides {
    @NotNull
    public static final DescriptorEquivalenceForOverrides INSTANCE = new DescriptorEquivalenceForOverrides();

    private DescriptorEquivalenceForOverrides() {
    }

    public final boolean areEquivalent(@Nullable DeclarationDescriptor a2, @Nullable DeclarationDescriptor b2, boolean allowCopiesFromTheSameDeclaration, boolean distinguishExpectsAndNonExpects) {
        return a2 instanceof ClassDescriptor && b2 instanceof ClassDescriptor ? this.areClassesEquivalent((ClassDescriptor)a2, (ClassDescriptor)b2) : (a2 instanceof TypeParameterDescriptor && b2 instanceof TypeParameterDescriptor ? DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, (TypeParameterDescriptor)a2, (TypeParameterDescriptor)b2, allowCopiesFromTheSameDeclaration, null, 8, null) : (a2 instanceof CallableDescriptor && b2 instanceof CallableDescriptor ? DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$default(this, (CallableDescriptor)a2, (CallableDescriptor)b2, allowCopiesFromTheSameDeclaration, distinguishExpectsAndNonExpects, false, KotlinTypeRefiner.Default.INSTANCE, 16, null) : (a2 instanceof PackageFragmentDescriptor && b2 instanceof PackageFragmentDescriptor ? Intrinsics.areEqual(((PackageFragmentDescriptor)a2).getFqName(), ((PackageFragmentDescriptor)b2).getFqName()) : Intrinsics.areEqual(a2, b2))));
    }

    public static /* synthetic */ boolean areEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        return descriptorEquivalenceForOverrides.areEquivalent(declarationDescriptor, declarationDescriptor2, bl, bl2);
    }

    private final boolean areClassesEquivalent(ClassDescriptor a2, ClassDescriptor b2) {
        return Intrinsics.areEqual(a2.getTypeConstructor(), b2.getTypeConstructor());
    }

    public final boolean areTypeParametersEquivalent(@NotNull TypeParameterDescriptor a2, @NotNull TypeParameterDescriptor b2, boolean allowCopiesFromTheSameDeclaration, @NotNull Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables) {
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        Intrinsics.checkNotNullParameter(equivalentCallables, "equivalentCallables");
        if (Intrinsics.areEqual(a2, b2)) {
            return true;
        }
        if (Intrinsics.areEqual(a2.getContainingDeclaration(), b2.getContainingDeclaration())) {
            return false;
        }
        if (!this.ownersEquivalent(a2, b2, equivalentCallables, allowCopiesFromTheSameDeclaration)) {
            return false;
        }
        return a2.getIndex() == b2.getIndex();
    }

    public static /* synthetic */ boolean areTypeParametersEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, TypeParameterDescriptor typeParameterDescriptor, TypeParameterDescriptor typeParameterDescriptor2, boolean bl, Function2 function2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            function2 = areTypeParametersEquivalent.1.INSTANCE;
        }
        return descriptorEquivalenceForOverrides.areTypeParametersEquivalent(typeParameterDescriptor, typeParameterDescriptor2, bl, function2);
    }

    private final SourceElement singleSource(CallableDescriptor $this$singleSource) {
        DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides = this;
        CallableDescriptor callableDescriptor = $this$singleSource;
        while (true) {
            DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides2 = descriptorEquivalenceForOverrides;
            CallableDescriptor callableDescriptor2 = callableDescriptor;
            if (!(callableDescriptor2 instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)callableDescriptor2).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                return callableDescriptor2.getSource();
            }
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)callableDescriptor2).getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, "overriddenDescriptors");
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (callableMemberDescriptor == null) break;
            descriptorEquivalenceForOverrides = descriptorEquivalenceForOverrides2;
            callableDescriptor = callableMemberDescriptor;
        }
        return null;
    }

    public final boolean areCallableDescriptorsEquivalent(@NotNull CallableDescriptor a2, @NotNull CallableDescriptor b2, boolean allowCopiesFromTheSameDeclaration, boolean distinguishExpectsAndNonExpects, boolean ignoreReturnType, @NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        if (Intrinsics.areEqual(a2, b2)) {
            return true;
        }
        if (!Intrinsics.areEqual(a2.getName(), b2.getName())) {
            return false;
        }
        if (distinguishExpectsAndNonExpects && a2 instanceof MemberDescriptor && b2 instanceof MemberDescriptor && ((MemberDescriptor)((Object)a2)).isExpect() != ((MemberDescriptor)((Object)b2)).isExpect()) {
            return false;
        }
        if (Intrinsics.areEqual(a2.getContainingDeclaration(), b2.getContainingDeclaration())) {
            if (!allowCopiesFromTheSameDeclaration) {
                return false;
            }
            if (!Intrinsics.areEqual(this.singleSource(a2), this.singleSource(b2))) {
                return false;
            }
        }
        if (DescriptorUtils.isLocal(a2) || DescriptorUtils.isLocal(b2)) {
            return false;
        }
        if (!this.ownersEquivalent(a2, b2, areCallableDescriptorsEquivalent.1.INSTANCE, allowCopiesFromTheSameDeclaration)) {
            return false;
        }
        OverridingUtil overridingUtil2 = OverridingUtil.create(kotlinTypeRefiner, new KotlinTypeChecker.TypeConstructorEquality(allowCopiesFromTheSameDeclaration, a2, b2){
            final /* synthetic */ boolean $allowCopiesFromTheSameDeclaration;
            final /* synthetic */ CallableDescriptor $a;
            final /* synthetic */ CallableDescriptor $b;
            {
                this.$allowCopiesFromTheSameDeclaration = $allowCopiesFromTheSameDeclaration;
                this.$a = $a;
                this.$b = $b;
            }

            public final boolean equals(@NotNull TypeConstructor c1, @NotNull TypeConstructor c2) {
                Intrinsics.checkNotNullParameter(c1, "c1");
                Intrinsics.checkNotNullParameter(c2, "c2");
                if (Intrinsics.areEqual(c1, c2)) {
                    return true;
                }
                ClassifierDescriptor d1 = c1.getDeclarationDescriptor();
                ClassifierDescriptor d2 = c2.getDeclarationDescriptor();
                if (!(d1 instanceof TypeParameterDescriptor) || !(d2 instanceof TypeParameterDescriptor)) {
                    return false;
                }
                return DescriptorEquivalenceForOverrides.INSTANCE.areTypeParametersEquivalent((TypeParameterDescriptor)d1, (TypeParameterDescriptor)d2, this.$allowCopiesFromTheSameDeclaration, (Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean>)new Function2<DeclarationDescriptor, DeclarationDescriptor, Boolean>(this.$a, this.$b){
                    final /* synthetic */ CallableDescriptor $a;
                    final /* synthetic */ CallableDescriptor $b;
                    {
                        this.$a = $a;
                        this.$b = $b;
                        super(2);
                    }

                    @NotNull
                    public final Boolean invoke(@Nullable DeclarationDescriptor x2, @Nullable DeclarationDescriptor y2) {
                        return Intrinsics.areEqual(x2, this.$a) && Intrinsics.areEqual(y2, this.$b);
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue(overridingUtil2, "a: CallableDescriptor,\n \u2026= a && y == b }\n        }");
        OverridingUtil overridingUtil3 = overridingUtil2;
        return overridingUtil3.isOverridableBy(a2, b2, null, !ignoreReturnType).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE && overridingUtil3.isOverridableBy(b2, a2, null, !ignoreReturnType).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
    }

    public static /* synthetic */ boolean areCallableDescriptorsEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, boolean bl, boolean bl2, boolean bl3, KotlinTypeRefiner kotlinTypeRefiner, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x10) != 0) {
            bl3 = false;
        }
        return descriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent(callableDescriptor, callableDescriptor2, bl, bl2, bl3, kotlinTypeRefiner);
    }

    private final boolean ownersEquivalent(DeclarationDescriptor a2, DeclarationDescriptor b2, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables, boolean allowCopiesFromTheSameDeclaration) {
        DeclarationDescriptor aOwner = a2.getContainingDeclaration();
        DeclarationDescriptor bOwner = b2.getContainingDeclaration();
        return aOwner instanceof CallableMemberDescriptor || bOwner instanceof CallableMemberDescriptor ? equivalentCallables.invoke(aOwner, bOwner) : DescriptorEquivalenceForOverrides.areEquivalent$default(this, aOwner, bOwner, allowCopiesFromTheSameDeclaration, false, 8, null);
    }

    public final boolean areTypeParametersEquivalent(@NotNull TypeParameterDescriptor a2, @NotNull TypeParameterDescriptor b2, boolean allowCopiesFromTheSameDeclaration) {
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        return DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, a2, b2, allowCopiesFromTheSameDeclaration, null, 8, null);
    }
}

