/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.Java8ParameterNamesLoader;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaModifierListOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaValueParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReflectJavaMember
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaMember {
    @NotNull
    public abstract Member getMember();

    @Override
    @NotNull
    public AnnotatedElement getElement() {
        return (AnnotatedElement)((Object)this.getMember());
    }

    @Override
    public int getModifiers() {
        return this.getMember().getModifiers();
    }

    @Override
    @NotNull
    public Name getName() {
        Name name;
        String string = this.getMember().getName();
        if (string == null) {
            name = SpecialNames.NO_NAME_PROVIDED;
        } else {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            Name name2 = Name.identifier(it);
            Intrinsics.checkNotNullExpressionValue(name2, "member.name?.let { Name.\u2026ialNames.NO_NAME_PROVIDED");
            name = name2;
        }
        return name;
    }

    @Override
    @NotNull
    public ReflectJavaClass getContainingClass() {
        Class<?> clazz = this.getMember().getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, "member.declaringClass");
        return new ReflectJavaClass(clazz);
    }

    @NotNull
    protected final List<JavaValueParameter> getValueParameters(@NotNull Type[] parameterTypes, @NotNull Annotation[][] parameterAnnotations, boolean isVararg) {
        int n2;
        int n3;
        List<String> names;
        Intrinsics.checkNotNullParameter(parameterTypes, "parameterTypes");
        Intrinsics.checkNotNullParameter(parameterAnnotations, "parameterAnnotations");
        ArrayList<ReflectJavaValueParameter> result2 = new ArrayList<ReflectJavaValueParameter>(parameterTypes.length);
        List<String> list = names = Java8ParameterNamesLoader.INSTANCE.loadParameterNames(this.getMember());
        if (list == null) {
            n3 = 0;
        } else {
            n2 = list.size();
            n3 = n2 - parameterTypes.length;
        }
        int shift = n3;
        int n4 = 0;
        n2 = parameterTypes.length;
        while (n4 < n2) {
            String string;
            int i2 = n4++;
            ReflectJavaType type2 = ReflectJavaType.Factory.create(parameterTypes[i2]);
            List<String> list2 = names;
            if (list2 == null) {
                string = null;
            } else {
                List<String> list3;
                List<String> $this$getValueParameters_u24lambda_u2d1 = list3 = list2;
                boolean bl = false;
                String string2 = CollectionsKt.getOrNull($this$getValueParameters_u24lambda_u2d1, i2 + shift);
                if (string2 == null) {
                    throw new IllegalStateException(("No parameter with index " + i2 + '+' + shift + " (name=" + this.getName() + " type=" + type2 + ") in " + this).toString());
                }
                string = string2;
            }
            String name = string;
            boolean isParamVararg = isVararg && i2 == ArraysKt.getLastIndex(parameterTypes);
            result2.add(new ReflectJavaValueParameter(type2, parameterAnnotations[i2], name, isParamVararg));
        }
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ReflectJavaMember && Intrinsics.areEqual(this.getMember(), ((ReflectJavaMember)other).getMember());
    }

    public int hashCode() {
        return this.getMember().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + ": " + this.getMember();
    }

    @Override
    @Nullable
    public ReflectJavaAnnotation findAnnotation(@NotNull FqName fqName2) {
        return ReflectJavaAnnotationOwner.DefaultImpls.findAnnotation(this, fqName2);
    }

    @NotNull
    public List<ReflectJavaAnnotation> getAnnotations() {
        return ReflectJavaAnnotationOwner.DefaultImpls.getAnnotations(this);
    }

    @Override
    public boolean isAbstract() {
        return ReflectJavaModifierListOwner.DefaultImpls.isAbstract(this);
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return ReflectJavaAnnotationOwner.DefaultImpls.isDeprecatedInJavaDoc(this);
    }

    @Override
    public boolean isFinal() {
        return ReflectJavaModifierListOwner.DefaultImpls.isFinal(this);
    }

    @Override
    public boolean isStatic() {
        return ReflectJavaModifierListOwner.DefaultImpls.isStatic(this);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return ReflectJavaModifierListOwner.DefaultImpls.getVisibility(this);
    }
}

