/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.internal.KTypeImpl;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0017\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u0000H\u0001\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0017\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u0000H\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0003\u001a\u001f\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0000H\u0001\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0013\u0010\n\u001a\u00020\t*\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000b"}, d2={"Lkotlin/reflect/KType;", "type", "createMutableCollectionKType", "(Lkotlin/reflect/KType;)Lkotlin/reflect/KType;", "createNothingType", "lowerBound", "upperBound", "createPlatformKType", "(Lkotlin/reflect/KType;Lkotlin/reflect/KType;)Lkotlin/reflect/KType;", "Lkotlin/reflect/jvm/internal/impl/descriptors/ClassDescriptor;", "readOnlyToMutable", "(Lkotlin/reflect/jvm/internal/impl/descriptors/ClassDescriptor;)Lkotlin/reflect/jvm/internal/impl/descriptors/ClassDescriptor;"})
public final class TypeOfImplKt {
    @NotNull
    public static final KType createPlatformKType(@NotNull KType lowerBound, @NotNull KType upperBound) {
        Intrinsics.checkNotNullParameter(lowerBound, "lowerBound");
        Intrinsics.checkNotNullParameter(upperBound, "upperBound");
        return new KTypeImpl(KotlinTypeFactory.flexibleType((SimpleType)((KTypeImpl)lowerBound).getType(), (SimpleType)((KTypeImpl)upperBound).getType()), null, 2, null);
    }

    @NotNull
    public static final KType createMutableCollectionKType(@NotNull KType type2) {
        Object object;
        Intrinsics.checkNotNullParameter(type2, "type");
        KotlinType kotlinType = ((KTypeImpl)type2).getType();
        boolean bl = kotlinType instanceof SimpleType;
        if (!bl) {
            boolean bl2 = false;
            String string = Intrinsics.stringPlus("Non-simple type cannot be a mutable collection type: ", type2);
            throw new IllegalArgumentException(string.toString());
        }
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        Object object2 = object = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (object == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Non-class type cannot be a mutable collection type: ", type2));
        }
        ClassDescriptor classifier2 = object;
        SimpleType simpleType2 = (SimpleType)kotlinType;
        object = TypeOfImplKt.readOnlyToMutable(classifier2).getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(object, "classifier.readOnlyToMutable().typeConstructor");
        return new KTypeImpl(KotlinTypeFactory.simpleType$default(simpleType2, null, (TypeConstructor)object, null, false, 26, null), null, 2, null);
    }

    private static final ClassDescriptor readOnlyToMutable(ClassDescriptor $this$readOnlyToMutable) {
        Object object = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable(DescriptorUtilsKt.getFqNameUnsafe($this$readOnlyToMutable));
        if (object == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Not a readonly collection: ", $this$readOnlyToMutable));
        }
        FqName fqName2 = object;
        object = DescriptorUtilsKt.getBuiltIns($this$readOnlyToMutable).getBuiltInClassByFqName(fqName2);
        Intrinsics.checkNotNullExpressionValue(object, "builtIns.getBuiltInClassByFqName(fqName)");
        return object;
    }

    @NotNull
    public static final KType createNothingType(@NotNull KType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        KotlinType kotlinType = ((KTypeImpl)type2).getType();
        boolean bl = kotlinType instanceof SimpleType;
        if (!bl) {
            boolean bl2 = false;
            String string = Intrinsics.stringPlus("Non-simple type cannot be a Nothing type: ", type2);
            throw new IllegalArgumentException(string.toString());
        }
        SimpleType simpleType2 = (SimpleType)kotlinType;
        TypeConstructor typeConstructor2 = TypeUtilsKt.getBuiltIns(kotlinType).getNothing().getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "kotlinType.builtIns.nothing.typeConstructor");
        return new KTypeImpl(KotlinTypeFactory.simpleType$default(simpleType2, null, typeConstructor2, null, false, 26, null), null, 2, null);
    }
}

