/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.KClassImpl;
import kotlin.reflect.jvm.internal.pcollections.HashPMap;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000f\u0010\u0001\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0001\u0010\u0002\u001a-\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\"\b\b\u0000\u0010\u0004*\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0001\u00a2\u0006\u0004\b\b\u0010\t\"*\u0010\f\u001a\u0016\u0012\b\u0012\u0006*\u00020\u000b0\u000b\u0012\b\u0012\u0006*\u00020\u00030\u00030\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\r"}, d2={"", "clearKClassCache", "()V", "", "T", "Ljava/lang/Class;", "jClass", "Lkotlin/reflect/jvm/internal/KClassImpl;", "getOrCreateKotlinClass", "(Ljava/lang/Class;)Lkotlin/reflect/jvm/internal/KClassImpl;", "Lkotlin/reflect/jvm/internal/pcollections/HashPMap;", "", "K_CLASS_CACHE", "Lkotlin/reflect/jvm/internal/pcollections/HashPMap;"})
public final class KClassCacheKt {
    @NotNull
    private static HashPMap<String, Object> K_CLASS_CACHE;

    @NotNull
    public static final <T> KClassImpl<T> getOrCreateKotlinClass(@NotNull Class<T> jClass) {
        Object object;
        Intrinsics.checkNotNullParameter(jClass, "jClass");
        String name = jClass.getName();
        Object cached = K_CLASS_CACHE.get(name);
        if (cached instanceof WeakReference) {
            KClassImpl kClass = (KClassImpl)((WeakReference)cached).get();
            object = kClass;
            if (Intrinsics.areEqual(object == null ? null : ((KClassImpl)object).getJClass(), jClass)) {
                return kClass;
            }
        } else if (cached != null) {
            WeakReference[] cfr_ignored_0 = (WeakReference[])cached;
            for (WeakReference ref : (WeakReference[])cached) {
                KClassImpl kClass = (KClassImpl)ref.get();
                KClassImpl kClassImpl = kClass;
                if (!Intrinsics.areEqual(kClassImpl == null ? null : kClassImpl.getJClass(), jClass)) continue;
                return kClass;
            }
            int size = ((Object[])cached).length;
            WeakReference[] newArray = new WeakReference[size + 1];
            System.arraycopy(cached, 0, newArray, 0, size);
            KClassImpl<T> newKClass = new KClassImpl<T>(jClass);
            newArray[size] = new WeakReference<KClassImpl<T>>(newKClass);
            HashPMap<String, Object> hashPMap = K_CLASS_CACHE.plus(name, newArray);
            Intrinsics.checkNotNullExpressionValue(hashPMap, "K_CLASS_CACHE.plus(name, newArray)");
            K_CLASS_CACHE = hashPMap;
            return newKClass;
        }
        KClassImpl<T> newKClass = new KClassImpl<T>(jClass);
        object = K_CLASS_CACHE.plus(name, new WeakReference<KClassImpl<T>>(newKClass));
        Intrinsics.checkNotNullExpressionValue(object, "K_CLASS_CACHE.plus(name, WeakReference(newKClass))");
        K_CLASS_CACHE = object;
        return newKClass;
    }

    public static final void clearKClassCache() {
        HashPMap hashPMap = HashPMap.empty();
        Intrinsics.checkNotNullExpressionValue(hashPMap, "empty()");
        K_CLASS_CACHE = hashPMap;
    }

    static {
        HashPMap hashPMap = HashPMap.empty();
        Intrinsics.checkNotNullExpressionValue(hashPMap, "empty<String, Any>()");
        K_CLASS_CACHE = hashPMap;
    }
}

