/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.util.Arrays;
import java.util.Collections;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.FunctionBase;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Lambda;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference2;
import kotlin.jvm.internal.ReflectionFactory;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import kotlin.reflect.KMutableProperty0;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KMutableProperty2;
import kotlin.reflect.KProperty0;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KProperty2;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.KVariance;

public class Reflection {
    private static final ReflectionFactory factory;
    static final String REFLECTION_NOT_AVAILABLE = " (Kotlin reflection is not available)";
    private static final KClass[] EMPTY_K_CLASS_ARRAY;

    public static KClass createKotlinClass(Class javaClass) {
        return factory.createKotlinClass(javaClass);
    }

    public static KClass createKotlinClass(Class javaClass, String internalName) {
        return factory.createKotlinClass(javaClass, internalName);
    }

    public static KDeclarationContainer getOrCreateKotlinPackage(Class javaClass) {
        return factory.getOrCreateKotlinPackage(javaClass, "");
    }

    public static KDeclarationContainer getOrCreateKotlinPackage(Class javaClass, String moduleName) {
        return factory.getOrCreateKotlinPackage(javaClass, moduleName);
    }

    public static KClass getOrCreateKotlinClass(Class javaClass) {
        return factory.getOrCreateKotlinClass(javaClass);
    }

    public static KClass getOrCreateKotlinClass(Class javaClass, String internalName) {
        return factory.getOrCreateKotlinClass(javaClass, internalName);
    }

    public static KClass[] getOrCreateKotlinClasses(Class[] javaClasses) {
        int size = javaClasses.length;
        if (size == 0) {
            return EMPTY_K_CLASS_ARRAY;
        }
        KClass[] kClasses = new KClass[size];
        for (int i2 = 0; i2 < size; ++i2) {
            kClasses[i2] = Reflection.getOrCreateKotlinClass(javaClasses[i2]);
        }
        return kClasses;
    }

    public static String renderLambdaToString(Lambda lambda) {
        return factory.renderLambdaToString(lambda);
    }

    public static String renderLambdaToString(FunctionBase lambda) {
        return factory.renderLambdaToString(lambda);
    }

    public static KFunction function(FunctionReference f2) {
        return factory.function(f2);
    }

    public static KProperty0 property0(PropertyReference0 p2) {
        return factory.property0(p2);
    }

    public static KMutableProperty0 mutableProperty0(MutablePropertyReference0 p2) {
        return factory.mutableProperty0(p2);
    }

    public static KProperty1 property1(PropertyReference1 p2) {
        return factory.property1(p2);
    }

    public static KMutableProperty1 mutableProperty1(MutablePropertyReference1 p2) {
        return factory.mutableProperty1(p2);
    }

    public static KProperty2 property2(PropertyReference2 p2) {
        return factory.property2(p2);
    }

    public static KMutableProperty2 mutableProperty2(MutablePropertyReference2 p2) {
        return factory.mutableProperty2(p2);
    }

    public static KType typeOf(KClassifier classifier2) {
        return factory.typeOf(classifier2, Collections.emptyList(), false);
    }

    public static KType typeOf(Class klass) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), Collections.emptyList(), false);
    }

    public static KType typeOf(Class klass, KTypeProjection arg1) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), Collections.singletonList(arg1), false);
    }

    public static KType typeOf(Class klass, KTypeProjection arg1, KTypeProjection arg2) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), Arrays.asList(arg1, arg2), false);
    }

    public static KType typeOf(Class klass, KTypeProjection ... arguments2) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), ArraysKt.toList(arguments2), false);
    }

    public static KType nullableTypeOf(KClassifier classifier2) {
        return factory.typeOf(classifier2, Collections.emptyList(), true);
    }

    public static KType nullableTypeOf(Class klass) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), Collections.emptyList(), true);
    }

    public static KType nullableTypeOf(Class klass, KTypeProjection arg1) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), Collections.singletonList(arg1), true);
    }

    public static KType nullableTypeOf(Class klass, KTypeProjection arg1, KTypeProjection arg2) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), Arrays.asList(arg1, arg2), true);
    }

    public static KType nullableTypeOf(Class klass, KTypeProjection ... arguments2) {
        return factory.typeOf(Reflection.getOrCreateKotlinClass(klass), ArraysKt.toList(arguments2), true);
    }

    public static KTypeParameter typeParameter(Object container, String name, KVariance variance, boolean isReified) {
        return factory.typeParameter(container, name, variance, isReified);
    }

    public static void setUpperBounds(KTypeParameter typeParameter, KType bound) {
        factory.setUpperBounds(typeParameter, Collections.singletonList(bound));
    }

    public static void setUpperBounds(KTypeParameter typeParameter, KType ... bounds) {
        factory.setUpperBounds(typeParameter, ArraysKt.toList(bounds));
    }

    public static KType platformType(KType lowerBound, KType upperBound) {
        return factory.platformType(lowerBound, upperBound);
    }

    public static KType mutableCollectionType(KType type2) {
        return factory.mutableCollectionType(type2);
    }

    public static KType nothingType(KType type2) {
        return factory.nothingType(type2);
    }

    static {
        ReflectionFactory impl;
        try {
            Class<?> implClass = Class.forName("kotlin.reflect.jvm.internal.ReflectionFactoryImpl");
            impl = (ReflectionFactory)implClass.newInstance();
        }
        catch (ClassCastException e2) {
            impl = null;
        }
        catch (ClassNotFoundException e3) {
            impl = null;
        }
        catch (InstantiationException e4) {
            impl = null;
        }
        catch (IllegalAccessException e5) {
            impl = null;
        }
        factory = impl != null ? impl : new ReflectionFactory();
        EMPTY_K_CLASS_ARRAY = new KClass[0];
    }
}

