/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import kotlin.jvm.internal.CallableReference;
import kotlin.jvm.internal.FunctionBase;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KCallable;
import kotlin.reflect.KFunction;

public class FunctionReference
extends CallableReference
implements FunctionBase,
KFunction {
    private final int arity;
    private final int flags;

    public FunctionReference(int arity) {
        this(arity, NO_RECEIVER, null, null, null, 0);
    }

    public FunctionReference(int arity, Object receiver) {
        this(arity, receiver, null, null, null, 0);
    }

    public FunctionReference(int arity, Object receiver, Class owner, String name, String signature2, int flags) {
        super(receiver, owner, name, signature2, (flags & 1) == 1);
        this.arity = arity;
        this.flags = flags >> 1;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    protected KFunction getReflected() {
        return (KFunction)super.getReflected();
    }

    @Override
    protected KCallable computeReflected() {
        return Reflection.function(this);
    }

    @Override
    public boolean isInline() {
        return this.getReflected().isInline();
    }

    @Override
    public boolean isExternal() {
        return this.getReflected().isExternal();
    }

    @Override
    public boolean isOperator() {
        return this.getReflected().isOperator();
    }

    @Override
    public boolean isInfix() {
        return this.getReflected().isInfix();
    }

    @Override
    public boolean isSuspend() {
        return this.getReflected().isSuspend();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FunctionReference) {
            FunctionReference other = (FunctionReference)obj;
            return this.getName().equals(other.getName()) && this.getSignature().equals(other.getSignature()) && this.flags == other.flags && this.arity == other.arity && Intrinsics.areEqual(this.getBoundReceiver(), other.getBoundReceiver()) && Intrinsics.areEqual(this.getOwner(), other.getOwner());
        }
        if (obj instanceof KFunction) {
            return obj.equals(this.compute());
        }
        return false;
    }

    public int hashCode() {
        return ((this.getOwner() == null ? 0 : this.getOwner().hashCode() * 31) + this.getName().hashCode()) * 31 + this.getSignature().hashCode();
    }

    public String toString() {
        KCallable reflected = this.compute();
        if (reflected != this) {
            return reflected.toString();
        }
        return "<init>".equals(this.getName()) ? "constructor (Kotlin reflection is not available)" : "function " + this.getName() + " (Kotlin reflection is not available)";
    }
}

