/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import java.io.Serializable;

public final class ByteArrays {
    public static final byte[] EMPTY_ARRAY = new byte[0];
    public static final byte[] DEFAULT_EMPTY_ARRAY = new byte[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<byte[]> HASH_STRATEGY = new a(0);

    /*
     * WARNING - void declaration
     */
    public static byte[] forceCapacity(byte[] array, int length, int preserve) {
        void var2_3;
        byte[] byArray;
        byte[] byArray2 = new byte[length];
        System.arraycopy(byArray, 0, byArray2, 0, (int)var2_3);
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static void ensureOffsetLength(byte[] a2, int offset, int length) {
        void var2_2;
        void var1_1;
        Arrays.ensureOffsetLength(a2.length, (int)var1_1, (int)var2_2);
    }

    public static void swap(byte[] x2, int a2, int b2) {
        byte by = x2[a2];
        x2[var1_1] = x2[b2];
        var0[var2_2] = by;
    }

    public static void swap(byte[] x2, int a2, int b2, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            ByteArrays.swap(x2, a2, b2);
            ++n3;
            ++a2;
            ++b2;
        }
    }

    private static int b(byte[] byArray, int n2, int n3, int n4, ByteComparator byteComparator) {
        int n5 = byteComparator.compare(byArray[n2], byArray[n3]);
        int n6 = byteComparator.compare(byArray[n2], byArray[n4]);
        int n7 = byteComparator.compare(byArray[n3], byArray[n4]);
        if (n5 < 0) {
            if (n7 < 0) {
                return n3;
            }
            if (n6 < 0) {
                return n4;
            }
            return n2;
        }
        if (n7 > 0) {
            return n3;
        }
        if (n6 > 0) {
            return n4;
        }
        return n2;
    }

    public static void quickSort(byte[] x2, int from, int to, ByteComparator comp) {
        while (true) {
            int n2;
            int n3;
            int n4;
            if ((n4 = to - from) < 16) {
                while (from < to - 1) {
                    n4 = from;
                    for (n3 = from + 1; n3 < to; ++n3) {
                        if (comp.compare(x2[n3], x2[n4]) >= 0) continue;
                        n4 = n3;
                    }
                    if (n4 != from) {
                        n3 = x2[from];
                        x2[from] = x2[n4];
                        x2[n4] = n3;
                    }
                    ++from;
                }
                return;
            }
            n3 = from + n4 / 2;
            int n5 = from;
            int n6 = to - 1;
            if (n4 > 128) {
                int n7 = from;
                n5 = ByteArrays.b(x2, n7, n7 + (n4 /= 8), from + 2 * n4, comp);
                int n8 = n3;
                n3 = ByteArrays.b(x2, n3 - n4, n8, n8 + n4, comp);
                n6 = ByteArrays.b(x2, n6 - 2 * n4, n6 - n4, n6, comp);
            }
            n3 = ByteArrays.b(x2, n5, n3, n6, comp);
            n4 = x2[n3];
            n3 = from;
            n5 = from;
            int n9 = n6 = to - 1;
            while (true) {
                if (n5 <= n6 && (n2 = comp.compare(x2[n5], (byte)n4)) <= 0) {
                    if (n2 == 0) {
                        ByteArrays.swap(x2, n3++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = comp.compare(x2[n6], (byte)n4)) >= 0) {
                    if (n2 == 0) {
                        ByteArrays.swap(x2, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                ByteArrays.swap(x2, n5++, n6--);
            }
            n2 = Math.min(n3 - from, n5 - n3);
            ByteArrays.swap(x2, from, n5 - n2, n2);
            n2 = Math.min(n9 - n6, to - n9 - 1);
            ByteArrays.swap(x2, n5, to - n2, n2);
            n2 = n5 - n3;
            if (n2 > 1) {
                int n10 = from;
                ByteArrays.quickSort(x2, n10, n10 + n2, comp);
            }
            if ((n2 = n9 - n6) <= 1) break;
            from = to - n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void unstableSort(byte[] a2, int from, int to) {
        void var2_2;
        void var1_1;
        java.util.Arrays.sort(a2, (int)var1_1, (int)var2_2);
    }

    public static void unstableSort(byte[] a2) {
        byte[] byArray;
        ByteArrays.unstableSort(a2, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void unstableSort(byte[] a2, int from, int to, ByteComparator comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteArrays.quickSort(a2, (int)var1_1, (int)var2_2, (ByteComparator)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void unstableSort(byte[] a2, ByteComparator comp) {
        void var1_1;
        byte[] byArray;
        ByteArrays.unstableSort(a2, 0, byArray.length, (ByteComparator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeSort(byte[] a2, int from, int to, ByteComparator comp, byte[] supp22) {
        byte[] supp22;
        int n2 = to - from;
        if (n2 < 16) {
            int supp22 = from;
            while (++supp22 < to) {
                n2 = a2[supp22];
                int n3 = supp22;
                byte by = a2[n3 - 1];
                while (comp.compare((byte)n2, by) < 0) {
                    a2[n3] = by;
                    if (from == n3 - 1) {
                        --n3;
                        break;
                    }
                    by = a2[--n3 - 1];
                }
                a2[n3] = n2;
            }
            return;
        }
        if (supp22 == null) {
            supp22 = java.util.Arrays.copyOf(a2, to);
        }
        int n4 = from + to >>> 1;
        ByteArrays.mergeSort(supp22, from, n4, comp, a2);
        ByteArrays.mergeSort(supp22, n4, to, comp, a2);
        if (comp.compare(supp22[n4 - 1], supp22[n4]) <= 0) {
            System.arraycopy(supp22, from, a2, from, n2);
            return;
        }
        int n5 = n4;
        for (n2 = from; n2 < to; ++n2) {
            void var1_1;
            a2[n2] = n5 >= to || var1_1 < n4 && comp.compare(supp22[var1_1], supp22[n5]) <= 0 ? supp22[++var1_1] : supp22[n5++];
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeSort(byte[] a2, int from, int to, ByteComparator comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteArrays.mergeSort(a2, (int)var1_1, (int)var2_2, (ByteComparator)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void stableSort(byte[] a2, int from, int to) {
        void var2_2;
        void var1_1;
        ByteArrays.unstableSort(a2, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void stableSort(byte[] a2, int from, int to, ByteComparator comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteArrays.mergeSort(a2, (int)var1_1, (int)var2_2, (ByteComparator)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void stableSort(byte[] a2, ByteComparator comp) {
        void var1_1;
        byte[] byArray;
        ByteArrays.stableSort(a2, 0, byArray.length, (ByteComparator)var1_1);
    }

    protected static final class Segment {
        protected final int a;
        protected final int b;
        protected final int c;

        /*
         * WARNING - void declaration
         */
        protected Segment(int offset, int length, int level) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
            this.c = var3_3;
        }

        public final String toString() {
            return "Segment [offset=" + this.a + ", length=" + this.b + ", level=" + this.c + "]";
        }
    }

    private static final class a
    implements Hash.Strategy<byte[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

