/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Lazy;
import io.vavr.collection.Collections;
import io.vavr.collection.Iterator;
import io.vavr.collection.JavaConverters;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.Queue;
import io.vavr.collection.StreamModule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

public interface Stream<T>
extends LinearSeq<T> {
    public static final long serialVersionUID = 1L;

    public static <T> Collector<T, ArrayList<T>, Stream<T>> collector() {
        Supplier<ArrayList> supplier = ArrayList::new;
        BiConsumer<ArrayList, Object> accumulator = ArrayList::add;
        BinaryOperator combiner = (left, right) -> {
            left.addAll(right);
            return left;
        };
        Function<ArrayList, Stream> finisher = Stream::ofAll;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T> Stream<T> cons(T head, Supplier<? extends Stream<? extends T>> tailSupplier) {
        Objects.requireNonNull(tailSupplier, "tailSupplier is null");
        return new StreamModule.ConsImpl<T>(head, tailSupplier);
    }

    public static <T> Stream<T> empty() {
        return Empty.instance();
    }

    public static <T> Stream<T> of(T element) {
        return Stream.cons(element, Empty::instance);
    }

    public static <T> Stream<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof Stream) {
            return (Stream)elements;
        }
        if (elements instanceof JavaConverters.ListView && ((JavaConverters.ListView)elements).getDelegate() instanceof Stream) {
            return (Stream)((JavaConverters.ListView)elements).getDelegate();
        }
        return StreamModule.StreamFactory.create(elements.iterator());
    }

    @Override
    default public Stream<T> append(T element) {
        return this.isEmpty() ? Stream.of(element) : new StreamModule.AppendElements(this.head(), Queue.of(element), () -> this.tail());
    }

    @Override
    default public Stream<T> appendAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (Collections.isEmpty(elements)) {
            return this;
        }
        if (this.isEmpty()) {
            return Stream.ofAll(elements);
        }
        return Stream.ofAll(Iterator.concat(this, elements));
    }

    @Override
    default public Stream<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return this;
        }
        LinearSeq<T> stream = this;
        while (!stream.isEmpty() && !predicate.test(stream.head())) {
            stream = stream.tail();
        }
        Stream finalStream = stream;
        return stream.isEmpty() ? Stream.empty() : Stream.cons(stream.head(), () -> finalStream.tail().filter(predicate));
    }

    @Override
    default public T get(int index2) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("get(" + index2 + ") on Nil");
        }
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("get(" + index2 + ")");
        }
        LinearSeq<T> stream = this;
        for (int i2 = index2 - 1; i2 >= 0; --i2) {
            if (!(stream = stream.tail()).isEmpty()) continue;
            throw new IndexOutOfBoundsException("get(" + index2 + ") on Stream of size " + (index2 - i2));
        }
        return stream.head();
    }

    @Override
    default public boolean hasDefiniteSize() {
        return false;
    }

    @Override
    default public int indexOf(T element, int from) {
        int index2 = 0;
        LinearSeq<T> stream = this;
        while (!stream.isEmpty()) {
            if (index2 >= from && Objects.equals(stream.head(), element)) {
                return index2;
            }
            stream = stream.tail();
            ++index2;
        }
        return -1;
    }

    @Override
    default public Stream<T> insert(int index2, T element) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("insert(" + index2 + ", e)");
        }
        if (index2 == 0) {
            return Stream.cons(element, () -> this);
        }
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("insert(" + index2 + ", e) on Nil");
        }
        return Stream.cons(this.head(), () -> this.tail().insert(index2 - 1, (Object)element));
    }

    @Override
    default public Stream<T> insertAll(int index2, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("insertAll(" + index2 + ", elements)");
        }
        if (index2 == 0) {
            return this.isEmpty() ? Stream.ofAll(elements) : Stream.ofAll(elements).appendAll((Iterable)this);
        }
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("insertAll(" + index2 + ", elements) on Nil");
        }
        return Stream.cons(this.head(), () -> this.tail().insertAll(index2 - 1, (Iterable)elements));
    }

    @Override
    default public boolean isAsync() {
        return false;
    }

    @Override
    default public boolean isLazy() {
        return true;
    }

    @Override
    default public boolean isTraversableAgain() {
        return true;
    }

    @Override
    default public T last() {
        return Collections.last(this);
    }

    @Override
    default public int lastIndexOf(T element, int end) {
        int result2 = -1;
        LinearSeq<T> stream = this;
        for (int index2 = 0; index2 <= end && !stream.isEmpty(); ++index2) {
            if (Objects.equals(stream.head(), element)) {
                result2 = index2;
            }
            stream = stream.tail();
        }
        return result2;
    }

    @Override
    default public int length() {
        return this.foldLeft(0, (n2, ignored) -> n2 + 1);
    }

    @Override
    default public <U> Stream<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isEmpty()) {
            return Empty.instance();
        }
        return Stream.cons(mapper.apply(this.head()), () -> this.tail().map(mapper));
    }

    default public Stream<T> prepend(T element) {
        return Stream.cons(element, () -> this);
    }

    default public Stream<T> prependAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (this.isEmpty()) {
            if (elements instanceof Stream) {
                Stream stream = (Stream)elements;
                return stream;
            }
            return Stream.ofAll(elements);
        }
        return Stream.ofAll(elements).appendAll((Iterable)this);
    }

    @Override
    default public Stream<T> remove(T element) {
        if (this.isEmpty()) {
            return this;
        }
        Object head = this.head();
        return Objects.equals(head, element) ? this.tail() : Stream.cons(head, () -> this.tail().remove((Object)element));
    }

    @Override
    default public Stream<T> removeAt(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("removeAt(" + index2 + ")");
        }
        if (index2 == 0) {
            return this.tail();
        }
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("removeAt() on Nil");
        }
        return Stream.cons(this.head(), () -> this.tail().removeAt(index2 - 1));
    }

    @Override
    default public Stream<T> removeAll(Iterable<? extends T> elements) {
        return Collections.removeAll(this, elements);
    }

    @Override
    default public Stream<T> retainAll(Iterable<? extends T> elements) {
        return Collections.retainAll(this, elements);
    }

    @Override
    default public Stream<T> reverse() {
        return this.isEmpty() ? this : this.foldLeft(Stream.empty(), Stream::prepend);
    }

    @Override
    default public Stream<T> sorted(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return this.isEmpty() ? this : this.toJavaStream().sorted(comparator).collect(Stream.collector());
    }

    @Override
    default public String stringPrefix() {
        return "Stream";
    }

    @Override
    default public Stream<T> subSequence(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("subSequence(" + beginIndex + ", " + endIndex + ")");
        }
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("subSequence(" + beginIndex + ", " + endIndex + ")");
        }
        if (beginIndex == endIndex) {
            return Empty.instance();
        }
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("subSequence of Nil");
        }
        if (beginIndex == 0) {
            return Stream.cons(this.head(), () -> this.tail().subSequence(0, endIndex - 1));
        }
        return this.tail().subSequence(beginIndex - 1, endIndex - 1);
    }

    @Override
    public Stream<T> tail();

    @Override
    default public Stream<T> take(int n2) {
        if (n2 < 1 || this.isEmpty()) {
            return Stream.empty();
        }
        if (n2 == 1) {
            return Stream.cons(this.head(), Stream::empty);
        }
        return Stream.cons(this.head(), () -> this.tail().take(n2 - 1));
    }

    @Override
    default public Stream<T> update(int index2, T element) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("update(" + index2 + ", e) on Nil");
        }
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("update(" + index2 + ", e)");
        }
        Stream preceding = Empty.instance();
        LinearSeq<T> tail = this;
        int i2 = index2;
        while (i2 > 0) {
            if (tail.isEmpty()) {
                throw new IndexOutOfBoundsException("update at " + index2);
            }
            preceding = preceding.prepend(tail.head());
            --i2;
            tail = tail.tail();
        }
        if (tail.isEmpty()) {
            throw new IndexOutOfBoundsException("update at " + index2);
        }
        return preceding.reverse().appendAll(tail.tail().prepend(element));
    }

    public static abstract class Cons<T>
    implements Stream<T> {
        private static final long serialVersionUID = 1L;
        final T head;
        final Lazy<Stream<T>> tail;

        Cons(T head, Supplier<Stream<T>> tail) {
            Objects.requireNonNull(tail, "tail is null");
            this.head = head;
            this.tail = Lazy.of(tail);
        }

        @Override
        public T head() {
            return this.head;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            return new StreamModule.StreamIterator(this);
        }

        public boolean equals(Object o2) {
            return Collections.equals(this, o2);
        }

        public int hashCode() {
            return Collections.hashOrdered(this);
        }

        @Override
        public String toString() {
            StringBuilder builder2 = new StringBuilder(this.stringPrefix()).append("(");
            LinearSeq<T> stream = this;
            while (stream != null && !stream.isEmpty()) {
                Cons cons = stream;
                builder2.append(cons.head);
                if (cons.tail.isEvaluated()) {
                    if ((stream = stream.tail()).isEmpty()) continue;
                    builder2.append(", ");
                    continue;
                }
                builder2.append(", ?");
                stream = null;
            }
            return builder2.append(")").toString();
        }
    }

    public static final class Empty<T>
    implements Stream<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Empty<?> INSTANCE = new Empty();

        private Empty() {
        }

        public static <T> Empty<T> instance() {
            return INSTANCE;
        }

        @Override
        public T head() {
            throw new NoSuchElementException("head of empty stream");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterator.empty();
        }

        @Override
        public Stream<T> tail() {
            throw new UnsupportedOperationException("tail of empty stream");
        }

        public boolean equals(Object o2) {
            return Collections.equals(this, o2);
        }

        public int hashCode() {
            return Collections.hashOrdered(this);
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

