/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.Collections;
import io.vavr.collection.Seq;
import io.vavr.collection.Traversable;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

class JavaConverters {

    static class ListView<T, C extends Seq<T>>
    extends HasDelegate<C>
    implements List<T> {
        private static final long serialVersionUID = 1L;

        ListView(C delegate, boolean mutable) {
            super(delegate, mutable);
        }

        @Override
        public boolean add(T element) {
            this.setDelegate(() -> ((Seq)this.getDelegate()).append(element));
            return true;
        }

        @Override
        public void add(int index2, T element) {
            this.setDelegate(() -> ((Seq)this.getDelegate()).insert(index2, element));
        }

        @Override
        public boolean addAll(Collection<? extends T> collection) {
            Objects.requireNonNull(collection, "collection is null");
            return this.setDelegateAndCheckChanged(() -> ((Seq)this.getDelegate()).appendAll(collection));
        }

        @Override
        public boolean addAll(int index2, Collection<? extends T> collection) {
            Objects.requireNonNull(collection, "collection is null");
            return this.setDelegateAndCheckChanged(() -> ((Seq)this.getDelegate()).insertAll(index2, collection));
        }

        @Override
        public void clear() {
            if (this.isEmpty()) {
                return;
            }
            this.setDelegate(() -> ((Seq)this.getDelegate()).take(0));
        }

        @Override
        public boolean contains(Object obj) {
            Object that = obj;
            return ((Seq)this.getDelegate()).contains(that);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            Objects.requireNonNull(collection, "collection is null");
            Collection<?> that = collection;
            return ((Seq)this.getDelegate()).containsAll(that);
        }

        @Override
        public T get(int index2) {
            return ((Seq)this.getDelegate()).get(index2);
        }

        @Override
        public int indexOf(Object obj) {
            Object that = obj;
            return ((Seq)this.getDelegate()).indexOf(that);
        }

        @Override
        public boolean isEmpty() {
            return ((Seq)this.getDelegate()).isEmpty();
        }

        @Override
        public java.util.Iterator<T> iterator() {
            return new Iterator(this);
        }

        @Override
        public int lastIndexOf(Object obj) {
            Object that = obj;
            return ((Seq)this.getDelegate()).lastIndexOf(that);
        }

        @Override
        public java.util.ListIterator<T> listIterator() {
            return new ListIterator(this, 0);
        }

        @Override
        public java.util.ListIterator<T> listIterator(int index2) {
            return new ListIterator(this, index2);
        }

        @Override
        public T remove(int index2) {
            return this.setDelegateAndGetPreviousElement(index2, () -> ((Seq)this.getDelegate()).removeAt(index2));
        }

        @Override
        public boolean remove(Object obj) {
            Object that = obj;
            return this.setDelegateAndCheckChanged(() -> ((Seq)this.getDelegate()).remove(that));
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            Objects.requireNonNull(collection, "collection is null");
            Collection<?> that = collection;
            return this.setDelegateAndCheckChanged(() -> ((Seq)this.getDelegate()).removeAll(that));
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            Objects.requireNonNull(collection, "collection is null");
            Collection<?> that = collection;
            return this.setDelegateAndCheckChanged(() -> ((Seq)this.getDelegate()).retainAll(that));
        }

        @Override
        public T set(int index2, T element) {
            return this.setDelegateAndGetPreviousElement(index2, () -> ((Seq)this.getDelegate()).update(index2, element));
        }

        @Override
        public int size() {
            return ((Seq)this.getDelegate()).size();
        }

        @Override
        public void sort(Comparator<? super T> comparator) {
            Objects.requireNonNull(comparator, "comparator is null");
            if (this.isEmpty()) {
                return;
            }
            this.setDelegate(() -> ((Seq)this.getDelegate()).sorted(comparator));
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return new ListView(((Seq)this.getDelegate()).subSequence(fromIndex, toIndex), this.isMutable());
        }

        @Override
        public Object[] toArray() {
            return ((Seq)this.getDelegate()).toJavaArray();
        }

        @Override
        public <U> U[] toArray(U[] array) {
            Object[] target;
            Objects.requireNonNull(array, "array is null");
            Seq delegate = (Seq)this.getDelegate();
            int length = delegate.length();
            if (array.length < length) {
                Class<?> newType = array.getClass();
                target = newType == Object[].class ? new Object[length] : (Object[])Array.newInstance(newType.getComponentType(), length);
            } else {
                if (array.length > length) {
                    array[length] = null;
                }
                target = array;
            }
            java.util.Iterator iter = delegate.iterator();
            for (int i2 = 0; i2 < length; ++i2) {
                target[i2] = iter.next();
            }
            return target;
        }

        @Override
        public boolean equals(Object o2) {
            return o2 == this || o2 instanceof List && Collections.areEqual(this.getDelegate(), (List)o2);
        }

        @Override
        public int hashCode() {
            return Collections.hashOrdered(this.getDelegate());
        }

        public String toString() {
            return ((Seq)this.getDelegate()).mkString("[", ", ", "]");
        }

        private T setDelegateAndGetPreviousElement(int index2, Supplier<C> delegate) {
            this.ensureMutable();
            Object previousElement = ((Seq)this.getDelegate()).get(index2);
            this.setDelegate(delegate);
            return previousElement;
        }

        private static class ListIterator<T, C extends Seq<T>>
        extends Iterator<T, C>
        implements java.util.ListIterator<T> {
            ListIterator(ListView<T, C> list, int index2) {
                super(list);
                if (index2 < 0 || index2 > list.size()) {
                    throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + list.size());
                }
                this.nextIndex = index2;
            }

            @Override
            public boolean hasPrevious() {
                return this.nextIndex != 0;
            }

            @Override
            public int nextIndex() {
                return this.nextIndex;
            }

            @Override
            public int previousIndex() {
                return this.nextIndex - 1;
            }

            @Override
            public T previous() {
                this.checkForComodification();
                int index2 = this.nextIndex - 1;
                if (index2 < 0) {
                    throw new NoSuchElementException();
                }
                if (index2 >= this.list.size()) {
                    throw new ConcurrentModificationException();
                }
                try {
                    Object element = this.list.get(index2);
                    this.lastIndex = this.nextIndex = index2;
                    return element;
                }
                catch (IndexOutOfBoundsException x2) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public void set(T element) {
                this.list.ensureMutable();
                if (this.lastIndex < 0) {
                    throw new IllegalStateException();
                }
                this.checkForComodification();
                try {
                    this.list.set(this.lastIndex, element);
                }
                catch (IndexOutOfBoundsException x2) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public void add(T element) {
                this.list.ensureMutable();
                this.checkForComodification();
                try {
                    int index2 = this.nextIndex;
                    this.list.add(index2, element);
                    this.nextIndex = index2 + 1;
                    this.lastIndex = -1;
                    this.expectedSize = this.list.size();
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        private static class Iterator<T, C extends Seq<T>>
        implements java.util.Iterator<T> {
            ListView<T, C> list;
            int expectedSize;
            int nextIndex = 0;
            int lastIndex = -1;

            Iterator(ListView<T, C> list) {
                this.list = list;
                this.expectedSize = list.size();
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex != this.list.size();
            }

            @Override
            public T next() {
                this.checkForComodification();
                if (this.nextIndex >= this.list.size()) {
                    throw new NoSuchElementException();
                }
                try {
                    this.lastIndex = this.nextIndex++;
                    return this.list.get(this.lastIndex);
                }
                catch (IndexOutOfBoundsException x2) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public void remove() {
                this.list.ensureMutable();
                if (this.lastIndex < 0) {
                    throw new IllegalStateException();
                }
                this.checkForComodification();
                try {
                    this.nextIndex = this.lastIndex;
                    this.list.remove(this.nextIndex);
                    this.lastIndex = -1;
                    this.expectedSize = this.list.size();
                }
                catch (IndexOutOfBoundsException x2) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public void forEachRemaining(Consumer<? super T> consumer) {
                Objects.requireNonNull(consumer, "consumer is  null");
                this.checkForComodification();
                if (this.nextIndex >= this.list.size()) {
                    return;
                }
                int index2 = this.nextIndex;
                while (this.expectedSize == this.list.size() && index2 < this.expectedSize) {
                    consumer.accept(this.list.get(index2++));
                }
                this.nextIndex = index2;
                this.lastIndex = index2 - 1;
                this.checkForComodification();
            }

            final void checkForComodification() {
                if (this.expectedSize != this.list.size()) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    private static abstract class HasDelegate<C extends Traversable<?>>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private C delegate;
        private final boolean mutable;

        HasDelegate(C delegate, boolean mutable) {
            this.delegate = delegate;
            this.mutable = mutable;
        }

        protected boolean isMutable() {
            return this.mutable;
        }

        C getDelegate() {
            return this.delegate;
        }

        protected boolean setDelegateAndCheckChanged(Supplier<C> delegate) {
            boolean changed;
            this.ensureMutable();
            C previousDelegate = this.delegate;
            Traversable newDelegate = (Traversable)delegate.get();
            boolean bl = changed = newDelegate.size() != previousDelegate.size();
            if (changed) {
                this.delegate = newDelegate;
            }
            return changed;
        }

        protected void setDelegate(Supplier<C> newDelegate) {
            this.ensureMutable();
            this.delegate = (Traversable)newDelegate.get();
        }

        protected void ensureMutable() {
            if (!this.mutable) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

