/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.AbstractIterator;
import io.vavr.collection.Collections;
import io.vavr.collection.HashSet;
import io.vavr.collection.IteratorModule;
import io.vavr.collection.Queue;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.collection.Traversable;
import io.vavr.collection.TreeSet;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Iterator<T>
extends Traversable<T>,
java.util.Iterator<T> {
    @SafeVarargs
    public static <T> Iterator<T> concat(Iterable<? extends T> ... iterables) {
        Objects.requireNonNull(iterables, "iterables is null");
        if (iterables.length == 0) {
            return Iterator.empty();
        }
        IteratorModule.ConcatIterator<? extends T> res = new IteratorModule.ConcatIterator<T>();
        for (Iterable<T> iterable : iterables) {
            res.append(iterable.iterator());
        }
        return res;
    }

    public static <T> Iterator<T> empty() {
        return IteratorModule.EmptyIterator.INSTANCE;
    }

    public static <T> Iterator<T> of(final T element) {
        return new AbstractIterator<T>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T getNext() {
                this.hasNext = false;
                return element;
            }
        };
    }

    public static <T> Iterator<T> ofAll(final java.util.Iterator<? extends T> iterator2) {
        Objects.requireNonNull(iterator2, "iterator is null");
        if (iterator2 instanceof Iterator) {
            return (Iterator)iterator2;
        }
        return new AbstractIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public T getNext() {
                return iterator2.next();
            }
        };
    }

    default public Iterator<T> intersperse(final T element) {
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            boolean insertElement = false;

            @Override
            public boolean hasNext() {
                return that.hasNext();
            }

            @Override
            public T getNext() {
                if (this.insertElement) {
                    this.insertElement = false;
                    return element;
                }
                this.insertElement = true;
                return that.next();
            }
        };
    }

    default public Iterator<T> distinctBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        return new IteratorModule.DistinctIterator(this, TreeSet.empty(comparator), Function.identity());
    }

    default public <U> Iterator<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        return new IteratorModule.DistinctIterator<T, U>(this, HashSet.empty(), keyExtractor);
    }

    default public Iterator<T> drop(final int n2) {
        if (n2 <= 0) {
            return this;
        }
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            long count;
            {
                this.count = n2;
            }

            @Override
            public boolean hasNext() {
                while (this.count > 0L && that.hasNext()) {
                    that.next();
                    --this.count;
                }
                return that.hasNext();
            }

            @Override
            public T getNext() {
                return that.next();
            }
        };
    }

    default public Iterator<T> dropRight(final int n2) {
        if (n2 <= 0) {
            return this;
        }
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            private Queue<T> queue = Queue.empty();

            @Override
            public boolean hasNext() {
                while (this.queue.length() < n2 && that.hasNext()) {
                    this.queue = this.queue.append(that.next());
                }
                return this.queue.length() == n2 && that.hasNext();
            }

            @Override
            public T getNext() {
                Tuple2 t2 = ((Queue)this.queue.append(that.next())).dequeue();
                this.queue = (Queue)t2._2;
                return t2._1;
            }
        };
    }

    default public Iterator<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        IteratorModule.CachedIterator that = new IteratorModule.CachedIterator(this);
        while (that.hasNext() && predicate.test(that.touch())) {
            that.next();
        }
        return that;
    }

    @Override
    default public Iterator<T> filter(final Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            Option<T> next = Option.none();

            @Override
            public boolean hasNext() {
                while (this.next.isEmpty() && that.hasNext()) {
                    Object candidate = that.next();
                    if (!predicate.test(candidate)) continue;
                    this.next = Option.some(candidate);
                }
                return this.next.isDefined();
            }

            @Override
            public T getNext() {
                Object result2 = this.next.get();
                this.next = Option.none();
                return result2;
            }
        };
    }

    @Override
    default public T get() {
        return this.head();
    }

    @Override
    default public boolean hasDefiniteSize() {
        return false;
    }

    @Override
    default public T head() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("head() on empty iterator");
        }
        return (T)this.next();
    }

    @Override
    default public boolean isAsync() {
        return false;
    }

    @Override
    default public boolean isEmpty() {
        return !this.hasNext();
    }

    @Override
    default public boolean isLazy() {
        return true;
    }

    @Override
    default public boolean isTraversableAgain() {
        return false;
    }

    @Override
    default public boolean isSequential() {
        return true;
    }

    @Override
    default public Iterator<T> iterator() {
        return this;
    }

    @Override
    default public T last() {
        return Collections.last(this);
    }

    @Override
    default public int length() {
        return this.foldLeft(0, (n2, ignored) -> n2 + 1);
    }

    default public <U> Iterator<U> map(final Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<U>(){

            @Override
            public boolean hasNext() {
                return that.hasNext();
            }

            @Override
            public U getNext() {
                return mapper.apply(that.next());
            }
        };
    }

    @Override
    default public T reduceLeft(BiFunction<? super T, ? super T, ? extends T> op) {
        Objects.requireNonNull(op, "op is null");
        if (this.isEmpty()) {
            throw new NoSuchElementException("reduceLeft on Nil");
        }
        Object xs = this.next();
        while (this.hasNext()) {
            xs = op.apply(xs, this.next());
        }
        return (T)xs;
    }

    default public <U> Iterator<U> scanLeft(final U zero, final BiFunction<? super U, ? super T, ? extends U> operation) {
        Objects.requireNonNull(operation, "operation is null");
        if (this.isEmpty()) {
            return Iterator.of(zero);
        }
        final Iterator that = this;
        return new AbstractIterator<U>(){
            boolean isFirst = true;
            U acc = zero;

            @Override
            public boolean hasNext() {
                return this.isFirst || that.hasNext();
            }

            @Override
            public U getNext() {
                if (this.isFirst) {
                    this.isFirst = false;
                    return this.acc;
                }
                this.acc = operation.apply(this.acc, that.next());
                return this.acc;
            }
        };
    }

    default public Iterator<Seq<T>> slideBy(final Function<? super T, ?> classifier2) {
        Objects.requireNonNull(classifier2, "classifier is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final IteratorModule.CachedIterator source = new IteratorModule.CachedIterator(this);
        return new AbstractIterator<Seq<T>>(){
            private Stream<T> next = null;

            @Override
            public boolean hasNext() {
                if (this.next == null && source.hasNext()) {
                    Object key = classifier2.apply(source.touch());
                    ArrayList acc = new ArrayList();
                    acc.add(source.next());
                    while (source.hasNext() && key.equals(classifier2.apply(source.touch()))) {
                        acc.add(source.getNext());
                    }
                    this.next = Stream.ofAll(acc);
                }
                return this.next != null;
            }

            @Override
            public Stream<T> getNext() {
                Stream result2 = this.next;
                this.next = null;
                return result2;
            }
        };
    }

    default public Iterator<Seq<T>> sliding(int size, int step) {
        return new IteratorModule.GroupedIterator(this, size, step);
    }

    default public Tuple2<Iterator<T>, Iterator<T>> span(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (!this.hasNext()) {
            return Tuple.of(Iterator.empty(), Iterator.empty());
        }
        Stream that = Stream.ofAll(this);
        return Tuple.of(that.iterator().takeWhile(predicate), that.iterator().dropWhile(predicate));
    }

    @Override
    default public String stringPrefix() {
        return "Iterator";
    }

    @Override
    default public Iterator<T> tail() {
        if (!this.hasNext()) {
            throw new UnsupportedOperationException();
        }
        this.next();
        return this;
    }

    default public Iterator<T> take(final int n2) {
        if (n2 <= 0 || !this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            long count;
            {
                this.count = n2;
            }

            @Override
            public boolean hasNext() {
                return this.count > 0L && that.hasNext();
            }

            @Override
            public T getNext() {
                --this.count;
                return that.next();
            }
        };
    }

    default public Iterator<T> takeRight(final int n2) {
        if (n2 <= 0) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            private Queue<T> queue = Queue.empty();

            @Override
            public boolean hasNext() {
                while (that.hasNext()) {
                    this.queue = this.queue.enqueue(that.next());
                    if (this.queue.length() <= n2) continue;
                    this.queue = (Queue)this.queue.dequeue()._2;
                }
                return this.queue.length() > 0;
            }

            @Override
            public T getNext() {
                Tuple2 t2 = this.queue.dequeue();
                this.queue = (Queue)t2._2;
                return t2._1;
            }
        };
    }

    default public Iterator<T> takeWhile(final Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            private T next;
            private boolean cached = false;
            private boolean finished = false;

            @Override
            public boolean hasNext() {
                if (this.cached) {
                    return true;
                }
                if (this.finished) {
                    return false;
                }
                if (that.hasNext()) {
                    this.next = that.next();
                    if (predicate.test(this.next)) {
                        this.cached = true;
                        return true;
                    }
                }
                this.finished = true;
                return false;
            }

            @Override
            public T getNext() {
                this.cached = false;
                return this.next;
            }
        };
    }
}

