/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.serialization.ClassUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CollectionStrategy;
import com.intellij.util.xmlb.DomAdapter;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.RootBinding;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Transient;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002BS\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u0012\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J7\u0010\u0018\u001a\u00020\u0019\"\b\b\u0000\u0010\u001a*\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u0002H\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ;\u0010 \u001a\u0004\u0018\u00010\u0019\"\b\b\u0000\u0010\u001a*\u00020\u00192\u0006\u0010!\u001a\u0002H\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001e2\b\u0010\"\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0004\b#\u0010$J8\u0010%\u001a\u00020\u0019\"\b\b\u0000\u0010\u001a*\u00020\u00192\b\u0010&\u001a\u0004\u0018\u00010\u00192\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001eH\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020*H\u0016J\u0016\u0010+\u001a\u00020)2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020*0\u0016H\u0016J\u001c\u0010,\u001a\u0004\u0018\u00010\u00192\b\u0010&\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020)H\u0016J\u001e\u0010-\u001a\u0004\u0018\u00010\u00172\n\u0010.\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010\r\u001a\u00020\u000eH\u0016J-\u00103\u001a\u00020\u0007\"\b\b\u0000\u0010\u001a*\u00020\u00192\u0006\u0010\u001c\u001a\u0002H\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001eH\u0016\u00a2\u0006\u0002\u00104J\u001a\u00105\u001a\u00020*2\u0006\u0010\"\u001a\u00020\u00192\b\u00106\u001a\u0004\u0018\u000107H\u0016J\"\u00105\u001a\u0002002\u0006\u0010\"\u001a\u00020\u00192\u0006\u00108\u001a\u00020*2\b\u00106\u001a\u0004\u0018\u000107H\u0016J$\u00109\u001a\u0002002\b\u0010:\u001a\u0004\u0018\u00010\u00192\u0006\u00108\u001a\u00020*2\b\u00106\u001a\u0004\u0018\u000107H\u0002J\u001a\u0010;\u001a\u00020<2\u0006\u0010\"\u001a\u00020\u00192\b\u00106\u001a\u0004\u0018\u000107H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\f8\u0000X\u0081\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\b\u001a\u00020\u00078\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0014R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/util/xmlb/CollectionBinding;", "Lcom/intellij/util/xmlb/MultiNodeBinding;", "Lcom/intellij/util/xmlb/RootBinding;", "elementName", "", "valueAttributeName", "isSurroundWithTag", "", "isSortOrderedSet", "itemType", "Ljava/lang/Class;", "elementTypes", "", "serializer", "Lcom/intellij/util/xmlb/Serializer;", "strategy", "Lcom/intellij/util/xmlb/CollectionStrategy;", "(Ljava/lang/String;Ljava/lang/String;ZZLjava/lang/Class;[Ljava/lang/Class;Lcom/intellij/util/xmlb/Serializer;Lcom/intellij/util/xmlb/CollectionStrategy;)V", "[Ljava/lang/Class;", "isMulti", "()Z", "itemBindings", "", "Lcom/intellij/util/xmlb/Binding;", "deserialize", "", "T", "context", "element", "adapter", "Lcom/intellij/util/xmlb/DomAdapter;", "(Ljava/lang/Object;Ljava/lang/Object;Lcom/intellij/util/xmlb/DomAdapter;)Ljava/lang/Object;", "deserializeItem", "node", "bean", "deserializeItem$intellij_platform_util", "(Ljava/lang/Object;Lcom/intellij/util/xmlb/DomAdapter;Ljava/lang/Object;)Ljava/lang/Object;", "deserializeList", "currentValue", "elements", "deserializeToJson", "Lkotlinx/serialization/json/JsonElement;", "Lorg/jdom/Element;", "doDeserializeListToJson", "fromJson", "getItemBinding", "aClass", "init", "", "originalType", "Ljava/lang/reflect/Type;", "isBoundTo", "(Ljava/lang/Object;Lcom/intellij/util/xmlb/DomAdapter;)Z", "serialize", "filter", "Lcom/intellij/util/xmlb/SerializationFilter;", "parent", "serializeItem", "value", "toJson", "Lkotlinx/serialization/json/JsonArray;", "intellij.platform.util"})
public final class CollectionBinding
implements MultiNodeBinding,
RootBinding {
    @NotNull
    private final String elementName;
    @NotNull
    private final String valueAttributeName;
    private final boolean isSurroundWithTag;
    public final boolean isSortOrderedSet;
    @NotNull
    public final Class<?> itemType;
    @NotNull
    public final Class<?>[] elementTypes;
    @NotNull
    private final Serializer serializer;
    @NotNull
    private final CollectionStrategy strategy;
    @Nullable
    private List<? extends Binding> itemBindings;

    public CollectionBinding(@NotNull String elementName, @NotNull String valueAttributeName, boolean isSurroundWithTag, boolean isSortOrderedSet, @NotNull Class<?> itemType, @NotNull Class<?>[] elementTypes, @NotNull Serializer serializer, @NotNull CollectionStrategy strategy) {
        Intrinsics.checkNotNullParameter(elementName, "elementName");
        Intrinsics.checkNotNullParameter(valueAttributeName, "valueAttributeName");
        Intrinsics.checkNotNullParameter(itemType, "itemType");
        Intrinsics.checkNotNullParameter(elementTypes, "elementTypes");
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        Intrinsics.checkNotNullParameter(strategy, "strategy");
        this.elementName = elementName;
        this.valueAttributeName = valueAttributeName;
        this.isSurroundWithTag = isSurroundWithTag;
        this.isSortOrderedSet = isSortOrderedSet;
        this.itemType = itemType;
        this.elementTypes = elementTypes;
        this.serializer = serializer;
        this.strategy = strategy;
    }

    public boolean isSurroundWithTag() {
        return this.isSurroundWithTag;
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull Serializer serializer) {
        boolean bl;
        Intrinsics.checkNotNullParameter(originalType, "originalType");
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        boolean bl2 = bl = this.itemBindings == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Binding binding = this.getItemBinding(this.itemType, serializer);
        Class<?>[] elementTypes = this.elementTypes;
        if (elementTypes.length == 0) {
            Binding binding2 = binding;
            this.itemBindings = binding2 == null ? CollectionsKt.emptyList() : CollectionsKt.listOf(binding2);
        } else {
            List itemBindings = null;
            if (binding == null) {
                itemBindings = elementTypes.length == 1 ? (List)new SmartList() : (List)new ArrayList(elementTypes.length);
            } else {
                itemBindings = new ArrayList(elementTypes.length + 1);
                itemBindings.add(binding);
            }
            for (Class<?> aClass : elementTypes) {
                Binding b2 = this.getItemBinding(aClass, serializer);
                if (b2 == null || itemBindings.contains(b2)) continue;
                itemBindings.add(b2);
            }
            this.itemBindings = itemBindings.isEmpty() ? CollectionsKt.emptyList() : itemBindings;
        }
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    private final Binding getItemBinding(Class<?> aClass, Serializer serializer) {
        return ClassUtil.isPrimitive(aClass) || aClass.isAnnotationPresent(Transient.class) ? null : serializer.getRootBinding(aClass, aClass);
    }

    @Override
    @NotNull
    public <T> Object deserialize(@Nullable Object context, @NotNull T element, @NotNull DomAdapter<T> adapter) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(adapter, "adapter");
        return this.strategy.deserializeList(context, this.isSurroundWithTag() ? adapter.getChildren(element) : CollectionsKt.listOf(element), adapter, this);
    }

    @Override
    @NotNull
    public <T> Object deserializeList(@Nullable Object currentValue, @NotNull List<? extends T> elements, @NotNull DomAdapter<T> adapter) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        Intrinsics.checkNotNullParameter(adapter, "adapter");
        if (!this.isSurroundWithTag()) {
            return this.strategy.deserializeList(currentValue, elements, adapter, this);
        }
        T element = CollectionsKt.single(elements);
        return this.strategy.deserializeList(currentValue == null && Intrinsics.areEqual(adapter.getName(element), "set") ? new HashSet() : currentValue, adapter.getChildren(element), adapter, this);
    }

    @Nullable
    public final <T> Object deserializeItem$intellij_platform_util(@NotNull T node, @NotNull DomAdapter<T> adapter, @Nullable Object bean) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(adapter, "adapter");
            List<? extends Binding> list = this.itemBindings;
            Intrinsics.checkNotNull(list);
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Binding it = (Binding)element$iv;
                boolean bl = false;
                if (!it.isBoundTo(node, adapter)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        Binding binding = v1;
        if (binding == null) {
            String attributeName = this.valueAttributeName;
            String value2 = ((CharSequence)attributeName).length() == 0 ? adapter.getTextValue(node, "") : adapter.getAttributeValue(node, attributeName);
            return XmlSerializerImpl.convert(value2, this.itemType);
        }
        return binding.deserialize(bean, node, adapter);
    }

    @Override
    public <T> boolean isBoundTo(@NotNull T element, @NotNull DomAdapter<T> adapter) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(adapter, "adapter");
            if (this.isSurroundWithTag()) {
                bl = Intrinsics.areEqual(adapter.getName(element), this.strategy.getCollectionTagName(null));
            } else {
                List<? extends Binding> list = this.itemBindings;
                Intrinsics.checkNotNull(list);
                if (list.isEmpty()) {
                    bl = Intrinsics.areEqual(adapter.getName(element), this.elementName);
                } else {
                    List<? extends Binding> list2 = this.itemBindings;
                    Intrinsics.checkNotNull(list2);
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Binding it = (Binding)element$iv;
                            boolean bl2 = false;
                            if (!it.isBoundTo(element, adapter)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
            }
        }
        return bl;
    }
}

