/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.DomAdapter;
import com.intellij.util.xmlb.JdomAdapter;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.MapBindingKt;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.XmlDomAdapter;
import com.intellij.util.xmlb.annotations.Property;
import java.awt.Rectangle;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AccessorBindingWrapper
implements MultiNodeBinding,
NestedBinding {
    private final Binding binding;
    private final MutableAccessor accessor;
    final boolean isFlat;
    private final Property.Style beanStyle;

    AccessorBindingWrapper(@NotNull MutableAccessor accessor, @NotNull Binding binding, boolean isFlat, Property.Style beanStyle) {
        if (accessor == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(0);
        }
        if (binding == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(1);
        }
        this.accessor = accessor;
        this.binding = binding;
        this.isFlat = isFlat;
        this.beanStyle = beanStyle;
    }

    @Override
    @NotNull
    public MutableAccessor getAccessor() {
        MutableAccessor mutableAccessor = this.accessor;
        if (mutableAccessor == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(2);
        }
        return mutableAccessor;
    }

    @Override
    @Nullable
    public <T> Object deserialize(@Nullable Object context, @NotNull T element, @NotNull DomAdapter<T> adapter) {
        if (element == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(8);
        }
        if (adapter == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(9);
        }
        if (adapter == JdomAdapter.INSTANCE) {
            return this.deserializeUnsafe(context, (Element)element);
        }
        return this.deserializeUnsafe(context, (XmlElement)element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object deserializeUnsafe(Object context, @NotNull Element element) {
        Object deserializedValue;
        if (element == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(11);
        }
        Object currentValue = this.accessor.read(context);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(currentValue, element);
            return context;
        }
        if (this.beanStyle == Property.Style.ATTRIBUTE && this.binding instanceof BeanBinding && ((BeanBinding)this.binding).beanClass == Rectangle.class) {
            String xA = element.getAttributeValue("x");
            String yA = element.getAttributeValue("y");
            String wA = element.getAttributeValue("width");
            String hA = element.getAttributeValue("height");
            if (xA == null || yA == null || wA == null || hA == null) return context;
            int x2 = StringUtilRt.parseInt(xA, 0);
            int y2 = StringUtilRt.parseInt(yA, 0);
            int h2 = StringUtilRt.parseInt(hA, 0);
            int w2 = StringUtilRt.parseInt(wA, 0);
            deserializedValue = new Rectangle(x2, y2, w2, h2);
        } else {
            deserializedValue = this.binding.deserialize(currentValue, element, JdomAdapter.INSTANCE);
        }
        if (currentValue == deserializedValue) return context;
        this.accessor.set(context, deserializedValue);
        return context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object deserializeUnsafe(Object context, @NotNull XmlElement element) {
        if (element == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(12);
        }
        Object currentValue = this.accessor.read(context);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(currentValue, element);
            return context;
        } else {
            Object deserializedValue;
            if (this.beanStyle == Property.Style.ATTRIBUTE && this.binding instanceof BeanBinding && ((BeanBinding)this.binding).beanClass == Rectangle.class) {
                String xA = element.getAttributeValue("x");
                String yA = element.getAttributeValue("y");
                String wA = element.getAttributeValue("width");
                String hA = element.getAttributeValue("height");
                if (xA == null || yA == null || wA == null || hA == null) return context;
                int x2 = StringUtilRt.parseInt(xA, 0);
                int y2 = StringUtilRt.parseInt(yA, 0);
                int h2 = StringUtilRt.parseInt(hA, 0);
                int w2 = StringUtilRt.parseInt(wA, 0);
                deserializedValue = new Rectangle(x2, y2, w2, h2);
            } else {
                deserializedValue = this.binding.deserialize(currentValue, element, XmlDomAdapter.INSTANCE);
            }
            if (currentValue == deserializedValue) return context;
            this.accessor.set(context, deserializedValue);
        }
        return context;
    }

    @Override
    @Nullable
    public <T> Object deserializeList(@Nullable Object currentValue, @NotNull List<? extends T> elements, @NotNull DomAdapter<T> adapter) {
        if (elements == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(13);
        }
        if (adapter == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(14);
        }
        assert (currentValue != null);
        Object value2 = this.accessor.read(currentValue);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(value2, elements.get(0), adapter);
        } else {
            Object deserializedValue = MapBindingKt.deserializeList(this.binding, value2, elements, adapter);
            if (value2 != deserializedValue) {
                this.accessor.set(currentValue, deserializedValue);
            }
        }
        return null;
    }

    @Override
    public boolean isMulti() {
        return this.binding instanceof MultiNodeBinding && ((MultiNodeBinding)this.binding).isMulti();
    }

    @Override
    public <T> boolean isBoundTo(@NotNull T element, @NotNull DomAdapter<T> adapter) {
        if (element == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(17);
        }
        if (adapter == null) {
            AccessorBindingWrapper.$$$reportNull$$$0(18);
        }
        if (this.binding instanceof MapBinding) {
            return ((MapBinding)this.binding).isBoundToWithoutProperty(adapter.getName(element));
        }
        return this.binding.isBoundTo(element, adapter);
    }

    public String toString() {
        return this.binding.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 16: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/AccessorBindingWrapper";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/AccessorBindingWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doDeserializeListToJson";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toJson";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFromJson";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserializeToJson";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deserializeUnsafe";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doDeserializeListToJson";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

