/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageQueue;
import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\r\u001a\u00020\u00062\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\bR \u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00110\u00108\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016R\u0014\u0010\u001b\u001a\u00020\u00188AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e"}, d2={"Lcom/intellij/util/messages/impl/RootBus;", "Lcom/intellij/util/messages/impl/CompositeMessageBus;", "Lcom/intellij/util/messages/MessageBusOwner;", "owner", "<init>", "(Lcom/intellij/util/messages/MessageBusOwner;)V", "", "dispose", "()V", "Lcom/intellij/util/messages/Topic;", "topic", "", "handler", "removeDisposedHandlers", "(Lcom/intellij/util/messages/Topic;Ljava/lang/Object;)V", "scheduleEmptyConnectionRemoving", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/CompletableFuture;", "compactionFutureRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/atomic/AtomicInteger;", "compactionRequest", "Ljava/util/concurrent/atomic/AtomicInteger;", "emptyConnectionCounter", "Lcom/intellij/util/messages/impl/MessageQueue;", "getQueue$intellij_platform_core", "()Lcom/intellij/util/messages/impl/MessageQueue;", "queue", "Ljava/lang/ThreadLocal;", "queueThreadLocal", "Ljava/lang/ThreadLocal;"})
public final class RootBus
extends CompositeMessageBus {
    @NotNull
    private final AtomicReference<CompletableFuture<?>> compactionFutureRef;
    @NotNull
    private final AtomicInteger compactionRequest;
    @NotNull
    private final AtomicInteger emptyConnectionCounter;
    @NotNull
    private final ThreadLocal<MessageQueue> queueThreadLocal;

    public RootBus(@NotNull MessageBusOwner owner) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        super(owner);
        this.compactionFutureRef = new AtomicReference();
        this.compactionRequest = new AtomicInteger();
        this.emptyConnectionCounter = new AtomicInteger();
        ThreadLocal<MessageQueue> threadLocal = ThreadLocal.withInitial(RootBus::queueThreadLocal$lambda$0);
        Intrinsics.checkNotNullExpressionValue(threadLocal, "withInitial(...)");
        this.queueThreadLocal = threadLocal;
    }

    @NotNull
    public final MessageQueue getQueue$intellij_platform_core() {
        MessageQueue messageQueue = this.queueThreadLocal.get();
        Intrinsics.checkNotNullExpressionValue(messageQueue, "get(...)");
        return messageQueue;
    }

    public final void scheduleEmptyConnectionRemoving() {
        int counter = this.emptyConnectionCounter.incrementAndGet();
        if (counter < 128 || !this.emptyConnectionCounter.compareAndSet(counter, 0)) {
            return;
        }
        if (this.compactionRequest.incrementAndGet() == 1) {
            this.compactionFutureRef.set(CompletableFuture.runAsync(() -> RootBus.scheduleEmptyConnectionRemoving$lambda$1(this), AppExecutorUtil.getAppExecutorService()));
        }
    }

    @Override
    public void dispose() {
        CompletableFuture compactionFuture;
        CompletableFuture completableFuture = compactionFuture = (CompletableFuture)this.compactionFutureRef.getAndSet(null);
        if (completableFuture != null) {
            completableFuture.cancel(false);
        }
        this.compactionRequest.set(0);
        super.dispose();
    }

    public final void removeDisposedHandlers(@NotNull Topic<?> topic, @NotNull Object handler2) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(handler2, "handler");
        ArrayDeque<Message> queue = this.getQueue$intellij_platform_core().queue;
        if (queue.isEmpty()) {
            return;
        }
        queue.removeIf(arg_0 -> RootBus.removeDisposedHandlers$lambda$2(new Function1<Message, Boolean>(topic, handler2){
            final /* synthetic */ Topic<?> $topic;
            final /* synthetic */ Object $handler;
            {
                this.$topic = $topic;
                this.$handler = $handler;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Message message) {
                int n2 = message.handlers.length;
                for (int messageIndex = 0; messageIndex < n2; ++messageIndex) {
                    Object messageHandler;
                    if (message.handlers[messageIndex] == null) {
                        return false;
                    }
                    if (message.topic != this.$topic || messageHandler != this.$handler) continue;
                    message.handlers[messageIndex] = null;
                    return message.handlers.length == 1;
                }
                return false;
            }
        }, arg_0));
    }

    private static final MessageQueue queueThreadLocal$lambda$0() {
        return new MessageQueue();
    }

    private static final void scheduleEmptyConnectionRemoving$lambda$1(RootBus this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        int request = 0;
        do {
            request = this$0.compactionRequest.get();
            this$0.removeEmptyConnectionsRecursively();
        } while (!this$0.compactionRequest.compareAndSet(request, 0));
    }

    private static final boolean removeDisposedHandlers$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

