/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageBusImpl;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import com.intellij.util.messages.impl.MessageQueue;
import com.intellij.util.messages.impl.MethodHandleCache;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000r\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\u001a%\u0010\u0006\u001a\u00020\u00052\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00002\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a-\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a+\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001ac\u0010\u001d\u001a\u0004\u0018\u00010\u00132\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0010\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00002\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0004\u001a\u00020\u0003H\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a[\u0010&\u001a\u0004\u0018\u00010\u00132\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!2\u0010\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00002\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010#\u001a\u00020\u00012\b\u0010%\u001a\u0004\u0018\u00010$2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\b&\u0010'\u001a1\u0010)\u001a\u00020(2\u0006\u0010#\u001a\u00020\u00012\u0010\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00002\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b)\u0010*\u001a\u0017\u0010+\u001a\u00020(2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b+\u0010,\u001a9\u0010/\u001a\u00020(2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00002\u0006\u0010.\u001a\u00020-2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b/\u00100\u001a\u0017\u00102\u001a\u00020(2\u0006\u00101\u001a\u00020\u0013H\u0000\u00a2\u0006\u0004\b2\u00103\"\u0014\u00104\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105"}, d2={"", "", "topicAndHandlerPairs", "Lcom/intellij/util/messages/impl/MessageBusImpl;", "bus", "", "clearSubscriberCacheOnConnectionTerminated", "([Ljava/lang/Object;Lcom/intellij/util/messages/impl/MessageBusImpl;)Z", "Lcom/intellij/util/messages/impl/MessageBusConnectionImpl;", "connection", "Ljava/util/Deque;", "Lcom/intellij/util/messages/impl/Message;", "jobs", "", "deliverImmediately", "(Lcom/intellij/util/messages/impl/MessageBusConnectionImpl;Ljava/util/Deque;)Ljava/util/List;", "job", "Lcom/intellij/util/messages/impl/MessageQueue;", "jobQueue", "", "prevError", "deliverMessage", "(Lcom/intellij/util/messages/impl/Message;Lcom/intellij/util/messages/impl/MessageQueue;Ljava/lang/Throwable;)Ljava/lang/Throwable;", "Lcom/intellij/util/messages/Topic;", "topic", "Ljava/lang/reflect/Method;", "method", "args", "handlers", "executeOrAddToQueue", "(Lcom/intellij/util/messages/Topic;Ljava/lang/reflect/Method;[Ljava/lang/Object;[Ljava/lang/Object;Lcom/intellij/util/messages/impl/MessageQueue;Ljava/lang/Throwable;Lcom/intellij/util/messages/impl/MessageBusImpl;)Ljava/lang/Throwable;", "Ljava/lang/invoke/MethodHandle;", "methodHandle", "", "methodName", "handler", "Lcom/intellij/util/messages/impl/MessageDeliveryListener;", "messageDeliveryListener", "invokeListener", "(Ljava/lang/invoke/MethodHandle;Ljava/lang/String;[Ljava/lang/Object;Lcom/intellij/util/messages/Topic;Ljava/lang/Object;Lcom/intellij/util/messages/impl/MessageDeliveryListener;Ljava/lang/Throwable;)Ljava/lang/Throwable;", "", "invokeMethod", "(Ljava/lang/Object;[Ljava/lang/Object;Ljava/lang/invoke/MethodHandle;)V", "pumpWaiting", "(Lcom/intellij/util/messages/impl/MessageQueue;)V", "", "index", "removeDisposedHandlers", "([Ljava/lang/Object;ILcom/intellij/util/messages/Topic;Lcom/intellij/util/messages/impl/MessageBusImpl;)V", "error", "throwError", "(Ljava/lang/Throwable;)V", "NA", "Ljava/lang/Object;"})
public final class MessageBusImplKt {
    @NotNull
    private static final Object NA = new Object();

    private static final void pumpWaiting(MessageQueue jobQueue) {
        block5: {
            Throwable error = null;
            Message job = jobQueue.current;
            if (job != null) {
                if (job.bus.isDisposed()) {
                    MessageBusImpl.LOG.error("Accessing disposed message bus " + job.bus);
                } else {
                    error = MessageBusImplKt.deliverMessage(job, jobQueue, null);
                }
            }
            while (jobQueue.queue.pollFirst() != null) {
                if (job.bus.isDisposed()) {
                    MessageBusImpl.LOG.error("Accessing disposed message bus " + job.bus);
                    continue;
                }
                error = MessageBusImplKt.deliverMessage(job, jobQueue, error);
            }
            Throwable throwable = error;
            if (throwable == null) break block5;
            Throwable p0 = throwable;
            boolean bl = false;
            MessageBusImplKt.throwError(p0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Throwable deliverMessage(Message job, MessageQueue jobQueue, Throwable prevError) {
        AutoCloseable autoCloseable = ClientId.Companion.withClientId(job.clientId);
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            jobQueue.current = job;
            Object[] handlers2 = job.handlers;
            Throwable error = prevError;
            int index2 = job.currentHandlerIndex;
            int size = handlers2.length;
            int lastIndex = size - 1;
            while (index2 < size) {
                if (index2 == lastIndex) {
                    jobQueue.current = null;
                }
                int n2 = job.currentHandlerIndex;
                job.currentHandlerIndex = n2 + 1;
                Object handler2 = handlers2[index2];
                if (handler2 != null) {
                    error = MessageBusImplKt.invokeListener(job.method, job.methodName, job.args, job.topic, handler2, job.bus.messageDeliveryListener, error);
                }
                if (++index2 == job.currentHandlerIndex) continue;
                Throwable throwable2 = error;
                return throwable2;
            }
            Throwable throwable3 = error;
            return throwable3;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    @Nullable
    public static final Throwable executeOrAddToQueue(@NotNull Topic<?> topic, @NotNull Method method, @Nullable Object[] args, @NotNull Object[] handlers2, @Nullable MessageQueue jobQueue, @Nullable Throwable prevError, @NotNull MessageBusImpl bus) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(handlers2, "handlers");
        Intrinsics.checkNotNullParameter(bus, "bus");
        MethodHandle methodHandle = MethodHandleCache.compute(method, args);
        Intrinsics.checkNotNullExpressionValue(methodHandle, "compute(...)");
        MethodHandle methodHandle2 = methodHandle;
        if (jobQueue == null) {
            Throwable error = prevError;
            for (Object handler2 : handlers2) {
                String string = method.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                Object object = handler2;
                if (object == null) continue;
                error = MessageBusImplKt.invokeListener(methodHandle2, string, args, topic, object, bus.messageDeliveryListener, error);
            }
            return error;
        }
        ArrayDeque<Message> arrayDeque = jobQueue.queue;
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        arrayDeque.offerLast(new Message(topic, methodHandle2, string, args, handlers2, bus));
        return prevError;
    }

    private static final boolean clearSubscriberCacheOnConnectionTerminated(Object[] topicAndHandlerPairs, MessageBusImpl bus) {
        boolean isChildClearingNeeded = false;
        int i2 = 0;
        while (i2 < topicAndHandlerPairs.length) {
            Topic.BroadcastDirection direction;
            Object object = topicAndHandlerPairs[i2];
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type com.intellij.util.messages.Topic<*>");
            Topic topic = (Topic)object;
            MessageBusImplKt.removeDisposedHandlers(topicAndHandlerPairs, i2, topic, bus);
            Intrinsics.checkNotNullExpressionValue((Object)topic.getBroadcastDirection(), "getBroadcastDirection(...)");
            if (direction != Topic.BroadcastDirection.TO_CHILDREN) {
                i2 += 2;
                continue;
            }
            MessageBusImpl parentBus = bus;
            while (true) {
                CompositeMessageBus compositeMessageBus = parentBus.parentBus;
                if (compositeMessageBus == null) {
                    break;
                }
                parentBus = compositeMessageBus;
                MessageBusImplKt.removeDisposedHandlers(topicAndHandlerPairs, i2, topic, parentBus);
            }
            if (bus.hasChildren$intellij_platform_core()) {
                isChildClearingNeeded = true;
            }
            i2 += 2;
        }
        return isChildClearingNeeded;
    }

    private static final void removeDisposedHandlers(Object[] topicAndHandlerPairs, int index2, Topic<?> topic, MessageBusImpl bus) {
        Object[] objectArray = (Object[])bus.subscriberCache.remove(topic);
        if (objectArray == null) {
            return;
        }
        Object[] cachedHandlers = objectArray;
        Object handler2 = topicAndHandlerPairs[index2 + 1];
        if (topic.isImmediateDelivery()) {
            int length = cachedHandlers.length;
            for (int i2 = 0; i2 < length; ++i2) {
                if (cachedHandlers[i2] != handler2) continue;
                cachedHandlers[i2] = null;
            }
        }
        bus.rootBus.removeDisposedHandlers(topic, handler2);
    }

    private static final List<Message> deliverImmediately(MessageBusConnectionImpl connection, Deque<Message> jobs) {
        List newJobs = null;
        Iterator<Message> iterator2 = jobs.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Message> jobIterator = iterator2;
        while (jobIterator.hasNext()) {
            Message job = jobIterator.next();
            List handlers2 = null;
            Object[] allHandlers = job.handlers;
            int length = allHandlers.length;
            for (int i2 = 0; i2 < length; ++i2) {
                Object handler2 = allHandlers[i2];
                if (handler2 == null || connection.bus != job.bus || !connection.isMyHandler(job.topic, handler2)) continue;
                allHandlers[i2] = null;
                if (handlers2 == null) {
                    handlers2 = new ArrayList();
                }
                handlers2.add(handler2);
            }
            if (handlers2 == null) continue;
            if (allHandlers.length == handlers2.size()) {
                jobIterator.remove();
            }
            Collection $this$toTypedArray$iv = handlers2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Message filteredJob = new Message(job.topic, job.method, job.methodName, job.args, thisCollection$iv.toArray(new Object[0]), job.bus);
            if (newJobs == null) {
                newJobs = new ArrayList();
            }
            newJobs.add(filteredJob);
        }
        return newJobs;
    }

    private static final Throwable invokeListener(MethodHandle methodHandle, String methodName, Object[] args, Topic<?> topic, Object handler2, MessageDeliveryListener messageDeliveryListener, Throwable prevError) {
        try {
            if (handler2 instanceof MessageHandler) {
                MessageHandler messageHandler = (MessageHandler)handler2;
                Object[] objectArray = args;
                if (args == null) {
                    objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                }
                Object[] objectArray2 = objectArray;
                messageHandler.handle(methodHandle, Arrays.copyOf(objectArray2, objectArray2.length));
            } else if (messageDeliveryListener == null) {
                MessageBusImplKt.invokeMethod(handler2, args, methodHandle);
            } else {
                long startTime = System.nanoTime();
                MessageBusImplKt.invokeMethod(handler2, args, methodHandle);
                messageDeliveryListener.messageDelivered(topic, methodName, handler2, System.nanoTime() - startTime);
            }
        }
        catch (AbstractMethodError startTime) {
        }
        catch (Throwable e2) {
            Throwable error;
            Throwable throwable = error = e2 instanceof ProcessCanceledException || e2 instanceof AssertionError || e2 instanceof CancellationException ? e2 : (Throwable)new RuntimeException("Cannot invoke (class=" + handler2.getClass().getSimpleName() + ", method=" + methodName + ", topic=" + topic.getDisplayName() + ')', e2);
            if (prevError == null) {
                return error;
            }
            ExceptionsKt.addSuppressed(prevError, error);
            return prevError;
        }
        return prevError;
    }

    private static final void invokeMethod(Object handler2, Object[] args, MethodHandle methodHandle) {
        if (args == null) {
            methodHandle.invoke(handler2);
        } else {
            methodHandle.bindTo(handler2).invokeExact(args);
        }
    }

    public static final void throwError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter(error, "error");
        Throwable[] suppressed = error.getSuppressed();
        if (suppressed.length > 1) {
            Throwable throwable;
            block3: {
                Throwable throwable2;
                Intrinsics.checkNotNull(suppressed);
                Throwable[] $this$firstOrNull$iv = suppressed;
                boolean $i$f$firstOrNull = false;
                int n2 = $this$firstOrNull$iv.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Throwable element$iv;
                    Throwable it = element$iv = $this$firstOrNull$iv[i2];
                    boolean bl = false;
                    if (!(it instanceof ProcessCanceledException || it instanceof CancellationException)) continue;
                    throwable2 = element$iv;
                    break block3;
                }
                throwable2 = throwable = null;
            }
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                throw it;
            }
        }
        throw error;
    }

    public static final /* synthetic */ boolean access$clearSubscriberCacheOnConnectionTerminated(Object[] topicAndHandlerPairs, MessageBusImpl bus) {
        return MessageBusImplKt.clearSubscriberCacheOnConnectionTerminated(topicAndHandlerPairs, bus);
    }

    public static final /* synthetic */ List access$deliverImmediately(MessageBusConnectionImpl connection, Deque jobs) {
        return MessageBusImplKt.deliverImmediately(connection, jobs);
    }

    public static final /* synthetic */ Throwable access$deliverMessage(Message job, MessageQueue jobQueue, Throwable prevError) {
        return MessageBusImplKt.deliverMessage(job, jobQueue, prevError);
    }

    public static final /* synthetic */ Object access$getNA$p() {
        return NA;
    }

    public static final /* synthetic */ void access$pumpWaiting(MessageQueue jobQueue) {
        MessageBusImplKt.pumpWaiting(jobQueue);
    }
}

