/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.util.ui.EDT;
import java.awt.EventQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThreadingAssertions {
    private ThreadingAssertions() {
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(ThreadingAssertions.class);
        if (logger == null) {
            ThreadingAssertions.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public static void assertEventDispatchThread() {
        if (!EDT.isCurrentThreadEdt()) {
            ThreadingAssertions.throwThreadAccessException("Access is allowed from Event Dispatch Thread (EDT) only");
        }
    }

    public static void assertBackgroundThread() {
        if (EDT.isCurrentThreadEdt()) {
            ThreadingAssertions.throwThreadAccessException("Access from Event Dispatch Thread (EDT) is not allowed");
        }
    }

    @ApiStatus.Obsolete
    public static void softAssertReadAccess() {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            ThreadingAssertions.getLogger().error(ThreadingAssertions.createThreadAccessException("Read access is allowed from inside read-action only (see Application.runReadAction())"));
        }
    }

    public static void assertWriteAccess() {
        if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
            ThreadingAssertions.throwThreadAccessException("Write access is allowed inside write-action only (see Application.runWriteAction())");
        }
    }

    private static void throwThreadAccessException(@NotNull String message) {
        if (message == null) {
            ThreadingAssertions.$$$reportNull$$$0(1);
        }
        throw ThreadingAssertions.createThreadAccessException(message);
    }

    @NotNull
    private static RuntimeExceptionWithAttachments createThreadAccessException(@NotNull String message) {
        if (message == null) {
            ThreadingAssertions.$$$reportNull$$$0(2);
        }
        return new RuntimeExceptionWithAttachments(message + "; see " + "https://jb.gg/ij-platform-threading" + " for details\n" + ThreadingAssertions.getThreadDetails(), new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString()));
    }

    @NotNull
    private static String getThreadDetails() {
        Thread current = Thread.currentThread();
        Thread edt = EDT.getEventDispatchThreadOrNull();
        String string = "Current thread: " + ThreadingAssertions.describe(current) + " (EventQueue.isDispatchThread()=" + EventQueue.isDispatchThread() + ")\nSystemEventQueueThread: " + (edt == current ? "(same)" : ThreadingAssertions.describe(edt));
        if (string == null) {
            ThreadingAssertions.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String describe(@Nullable Thread o2) {
        String string = o2 == null ? "null" : o2 + " " + System.identityHashCode(o2);
        if (string == null) {
            ThreadingAssertions.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/ThreadingAssertions";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/ThreadingAssertions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadDetails";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "throwThreadAccessException";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createThreadAccessException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

