/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import java.util.concurrent.Callable;
import kotlin.coroutines.CoroutineContext;
import org.jetbrains.annotations.NotNull;

final class ContextCallable<V>
implements Callable<V> {
    private final boolean myRoot;
    @NotNull
    private final CoroutineContext myParentContext;
    @NotNull
    private final Callable<? extends V> myCallable;

    ContextCallable(boolean root, @NotNull CoroutineContext context, @NotNull Callable<? extends V> callable) {
        if (context == null) {
            ContextCallable.$$$reportNull$$$0(0);
        }
        if (callable == null) {
            ContextCallable.$$$reportNull$$$0(1);
        }
        this.myRoot = root;
        this.myParentContext = context;
        this.myCallable = callable;
    }

    @Override
    public V call() throws Exception {
        try (AccessToken ignored = ThreadContext.installThreadContext(this.myParentContext, !this.myRoot);){
            V v2 = this.myCallable.call();
            return v2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "callable";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/concurrency/ContextCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

