/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtilRt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathUtil {
    private PathUtil() {
    }

    @NotNull
    public static String getLocalPath(@NotNull String path) {
        if (path == null) {
            PathUtil.$$$reportNull$$$0(0);
        }
        String string = FileUtilRt.toSystemDependentName(Strings.trimEnd(path, "!/"));
        if (string == null) {
            PathUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getJarPathForClass(@NotNull Class<?> aClass) {
        if (aClass == null) {
            PathUtil.$$$reportNull$$$0(2);
        }
        String pathForClass = PathManager.getJarPathForClass(aClass);
        assert (pathForClass != null) : aClass;
        String string = pathForClass;
        if (string == null) {
            PathUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String toPresentableUrl(@NotNull String url) {
        if (url == null) {
            PathUtil.$$$reportNull$$$0(4);
        }
        return PathUtil.getLocalPath(VirtualFileManager.extractPath(url));
    }

    @NotNull
    public static String getFileName(@NotNull String path) {
        if (path == null) {
            PathUtil.$$$reportNull$$$0(5);
        }
        String string = PathUtilRt.getFileName(path);
        if (string == null) {
            PathUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static String toSystemIndependentName(@Nullable String path) {
        return path == null ? null : FileUtilRt.toSystemIndependentName(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 20: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/PathUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/PathUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarPathForClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentPath";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestFileName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "driveLetterToLowerCase";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "makeFileName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPath";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toPresentableUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileExtension";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParentPath";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "suggestFileName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isValidFileName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "driveLetterToLowerCase";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "makeFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

