/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtilRt;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArrayUtil {
    public static final char[] EMPTY_CHAR_ARRAY = ArrayUtilRt.EMPTY_CHAR_ARRAY;
    public static final byte[] EMPTY_BYTE_ARRAY = ArrayUtilRt.EMPTY_BYTE_ARRAY;
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final int[] EMPTY_INT_ARRAY = ArrayUtilRt.EMPTY_INT_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY = ArrayUtilRt.EMPTY_STRING_ARRAY;
    public static final Class[] EMPTY_CLASS_ARRAY = ArrayUtilRt.EMPTY_CLASS_ARRAY;
    public static final long[] EMPTY_LONG_ARRAY = ArrayUtilRt.EMPTY_LONG_ARRAY;
    public static final File[] EMPTY_FILE_ARRAY = ArrayUtilRt.EMPTY_FILE_ARRAY;
    public static final Runnable[] EMPTY_RUNNABLE_ARRAY = new Runnable[0];
    @Deprecated
    public static final CharSequence EMPTY_CHAR_SEQUENCE = new String();
    public static final ArrayFactory<String> STRING_ARRAY_FACTORY = ArrayUtil::newStringArray;
    public static final ArrayFactory<Object> OBJECT_ARRAY_FACTORY = ArrayUtil::newObjectArray;

    private ArrayUtil() {
    }

    public static boolean @NotNull [] realloc(boolean @NotNull [] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(6);
        }
        if (newSize == 0) {
            if (ArrayUtilRt.EMPTY_BOOLEAN_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(7);
            }
            return ArrayUtilRt.EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] blArray = array.length == newSize ? array : Arrays.copyOf(array, newSize);
        if (blArray == null) {
            ArrayUtil.$$$reportNull$$$0(8);
        }
        return blArray;
    }

    public static short @NotNull [] realloc(short @NotNull [] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(9);
        }
        if (newSize == 0) {
            if (ArrayUtilRt.EMPTY_SHORT_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(10);
            }
            return ArrayUtilRt.EMPTY_SHORT_ARRAY;
        }
        short[] sArray = array.length == newSize ? array : Arrays.copyOf(array, newSize);
        if (sArray == null) {
            ArrayUtil.$$$reportNull$$$0(11);
        }
        return sArray;
    }

    public static int @NotNull [] realloc(int @NotNull [] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(15);
        }
        if (newSize == 0) {
            if (EMPTY_INT_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(16);
            }
            return EMPTY_INT_ARRAY;
        }
        int[] nArray = array.length == newSize ? array : Arrays.copyOf(array, newSize);
        if (nArray == null) {
            ArrayUtil.$$$reportNull$$$0(17);
        }
        return nArray;
    }

    public static <T> T @NotNull [] realloc(T @NotNull [] array, int newSize, @NotNull ArrayFactory<? extends T> factory2) {
        int oldSize;
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(18);
        }
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(19);
        }
        if ((oldSize = array.length) == newSize) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(20);
            }
            return array;
        }
        T[] result2 = factory2.create(newSize);
        if (newSize == 0) {
            if (result2 == null) {
                ArrayUtil.$$$reportNull$$$0(21);
            }
            return result2;
        }
        System.arraycopy(array, 0, result2, 0, Math.min(oldSize, newSize));
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(22);
        }
        return result2;
    }

    public static int @NotNull [] append(int @NotNull [] array, int value2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(25);
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value2;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(26);
        }
        return array;
    }

    public static <T> T @NotNull [] insert(T @NotNull [] array, int index2, T value2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(27);
        }
        T[] result2 = ArrayUtil.newArray(ArrayUtil.getComponentType(array), array.length + 1);
        System.arraycopy(array, 0, result2, 0, index2);
        result2[index2] = value2;
        System.arraycopy(array, index2, result2, index2 + 1, array.length - index2);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(28);
        }
        return result2;
    }

    public static int @NotNull [] insert(int @NotNull [] array, int index2, int value2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(29);
        }
        int[] result2 = new int[array.length + 1];
        System.arraycopy(array, 0, result2, 0, index2);
        result2[index2] = value2;
        System.arraycopy(array, index2, result2, index2 + 1, array.length - index2);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(30);
        }
        return result2;
    }

    public static char @NotNull [] realloc(char @NotNull [] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(39);
        }
        if (newSize == 0) {
            if (ArrayUtilRt.EMPTY_CHAR_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(40);
            }
            return ArrayUtilRt.EMPTY_CHAR_ARRAY;
        }
        int oldSize = array.length;
        char[] cArray = oldSize == newSize ? array : Arrays.copyOf(array, newSize);
        if (cArray == null) {
            ArrayUtil.$$$reportNull$$$0(41);
        }
        return cArray;
    }

    public static <T> T @NotNull [] toObjectArray(@NotNull Collection<? extends T> collection, @NotNull Class<T> aClass) {
        if (collection == null) {
            ArrayUtil.$$$reportNull$$$0(42);
        }
        if (aClass == null) {
            ArrayUtil.$$$reportNull$$$0(43);
        }
        T[] array = ArrayUtil.newArray(aClass, collection.size());
        T[] TArray = collection.toArray(array);
        if (TArray == null) {
            ArrayUtil.$$$reportNull$$$0(44);
        }
        return TArray;
    }

    public static Object @NotNull [] toObjectArray(@NotNull Collection<?> collection) {
        if (collection == null) {
            ArrayUtil.$$$reportNull$$$0(48);
        }
        Object[] objectArray = collection.toArray(ArrayUtilRt.EMPTY_OBJECT_ARRAY);
        if (objectArray == null) {
            ArrayUtil.$$$reportNull$$$0(49);
        }
        return objectArray;
    }

    public static <T> T @NotNull [] mergeArrays(T @NotNull [] a1, T @NotNull [] a2) {
        Class<T> class2;
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(52);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(53);
        }
        if (a1.length == 0) {
            if (a2 == null) {
                ArrayUtil.$$$reportNull$$$0(54);
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                ArrayUtil.$$$reportNull$$$0(55);
            }
            return a1;
        }
        Class<T> class1 = ArrayUtil.getComponentType(a1);
        Class<T> aClass = class1.isAssignableFrom(class2 = ArrayUtil.getComponentType(a2)) ? class1 : class2;
        T[] result2 = ArrayUtil.newArray(aClass, a1.length + a2.length);
        System.arraycopy(a1, 0, result2, 0, a1.length);
        System.arraycopy(a2, 0, result2, a1.length, a2.length);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(56);
        }
        return result2;
    }

    public static <T> T @NotNull [] mergeCollections(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<? extends T> factory2) {
        if (c1 == null) {
            ArrayUtil.$$$reportNull$$$0(57);
        }
        if (c2 == null) {
            ArrayUtil.$$$reportNull$$$0(58);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(59);
        }
        T[] res = factory2.create(c1.size() + c2.size());
        int i2 = 0;
        for (T t2 : c1) {
            res[i2++] = t2;
        }
        for (T t2 : c2) {
            res[i2++] = t2;
        }
        if (res == null) {
            ArrayUtil.$$$reportNull$$$0(60);
        }
        return res;
    }

    public static int @NotNull [] mergeArrays(int @NotNull [] a1, int @NotNull [] a2) {
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(69);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(70);
        }
        if (a1.length == 0) {
            if (a2 == null) {
                ArrayUtil.$$$reportNull$$$0(71);
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                ArrayUtil.$$$reportNull$$$0(72);
            }
            return a1;
        }
        int[] result2 = new int[a1.length + a2.length];
        System.arraycopy(a1, 0, result2, 0, a1.length);
        System.arraycopy(a2, 0, result2, a1.length, a2.length);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(73);
        }
        return result2;
    }

    public static byte @NotNull [] mergeArrays(byte @NotNull [] a1, byte @NotNull [] a2) {
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(74);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(75);
        }
        if (a1.length == 0) {
            if (a2 == null) {
                ArrayUtil.$$$reportNull$$$0(76);
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                ArrayUtil.$$$reportNull$$$0(77);
            }
            return a1;
        }
        byte[] result2 = new byte[a1.length + a2.length];
        System.arraycopy(a1, 0, result2, 0, a1.length);
        System.arraycopy(a2, 0, result2, a1.length, a2.length);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(78);
        }
        return result2;
    }

    public static int[] intersection(int @NotNull [] a1, int @NotNull [] a2) {
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(79);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(80);
        }
        if (a1.length == 0) {
            return a2;
        }
        if (a2.length == 0) {
            return a1;
        }
        IntOpenHashSet result2 = new IntOpenHashSet(a1);
        result2.retainAll(new IntArrayList(a2));
        return result2.toIntArray();
    }

    public static <T> T @NotNull [] mergeArrayAndCollection(T @NotNull [] array, @NotNull Collection<? extends T> collection, @NotNull ArrayFactory<? extends T> factory2) {
        T[] array2;
        if (collection == null) {
            ArrayUtil.$$$reportNull$$$0(81);
        }
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(82);
        }
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(83);
        }
        if (collection.isEmpty()) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(84);
            }
            return array;
        }
        try {
            T[] a2 = factory2.create(collection.size());
            array2 = collection.toArray(a2);
        }
        catch (ArrayStoreException e2) {
            throw new RuntimeException("Bad elements in collection: " + collection, e2);
        }
        if (array.length == 0) {
            if (array2 == null) {
                ArrayUtil.$$$reportNull$$$0(85);
            }
            return array2;
        }
        T[] result2 = factory2.create(array.length + collection.size());
        System.arraycopy(array, 0, result2, 0, array.length);
        System.arraycopy(array2, 0, result2, array.length, array2.length);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(86);
        }
        return result2;
    }

    public static <T> T @NotNull [] append(T @NotNull [] src, @Nullable T element) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(87);
        }
        return ArrayUtil.append(src, element, ArrayUtil.getComponentType(src));
    }

    public static <T> T @NotNull [] prepend(T element, T @NotNull [] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(88);
        }
        return ArrayUtil.prepend(element, array, ArrayUtil.getComponentType(array));
    }

    public static <T> T @NotNull [] prepend(T element, T @NotNull [] array, @NotNull Class<T> type2) {
        if (type2 == null) {
            ArrayUtil.$$$reportNull$$$0(89);
        }
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(90);
        }
        int length = array.length;
        T[] result2 = ArrayUtil.newArray(type2, length + 1);
        System.arraycopy(array, 0, result2, 1, length);
        result2[0] = element;
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(91);
        }
        return result2;
    }

    public static <T> T @NotNull [] append(T @NotNull [] src, T element, @NotNull ArrayFactory<? extends T> factory2) {
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(97);
        }
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(98);
        }
        int length = src.length;
        T[] result2 = factory2.create(length + 1);
        System.arraycopy(src, 0, result2, 0, length);
        result2[length] = element;
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(99);
        }
        return result2;
    }

    public static <T> T @NotNull [] append(T @NotNull [] src, @Nullable T element, @NotNull Class<T> componentType) {
        if (componentType == null) {
            ArrayUtil.$$$reportNull$$$0(100);
        }
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(101);
        }
        int length = src.length;
        T[] result2 = ArrayUtil.newArray(componentType, length + 1);
        System.arraycopy(src, 0, result2, 0, length);
        result2[length] = element;
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(102);
        }
        return result2;
    }

    public static <T> T @NotNull [] remove(T @NotNull [] src, int idx) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(103);
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        Class<T> type2 = ArrayUtil.getComponentType(src);
        T[] result2 = ArrayUtil.newArray(type2, length - 1);
        System.arraycopy(src, 0, result2, 0, idx);
        System.arraycopy(src, idx + 1, result2, idx, length - idx - 1);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(104);
        }
        return result2;
    }

    public static <T> T @NotNull [] newArray(@NotNull Class<T> type2, int length) {
        if (type2 == null) {
            ArrayUtil.$$$reportNull$$$0(105);
        }
        Object[] objectArray = (Object[])Array.newInstance(type2, length);
        if (objectArray == null) {
            ArrayUtil.$$$reportNull$$$0(106);
        }
        return objectArray;
    }

    public static <T> T @NotNull [] remove(T @NotNull [] src, int idx, @NotNull ArrayFactory<? extends T> factory2) {
        if (factory2 == null) {
            ArrayUtil.$$$reportNull$$$0(107);
        }
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(108);
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        T[] result2 = factory2.create(length - 1);
        System.arraycopy(src, 0, result2, 0, idx);
        System.arraycopy(src, idx + 1, result2, idx, length - idx - 1);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(109);
        }
        return result2;
    }

    public static <T> T @NotNull [] remove(T @NotNull [] src, T element) {
        int index2;
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(110);
        }
        return (index2 = ArrayUtilRt.find(src, element)) == -1 ? src : (T[])ArrayUtil.remove(src, index2);
    }

    public static int @NotNull [] remove(int @NotNull [] src, int idx) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(114);
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        int[] result2 = ArrayUtil.newIntArray(src.length - 1);
        System.arraycopy(src, 0, result2, 0, idx);
        System.arraycopy(src, idx + 1, result2, idx, length - idx - 1);
        if (result2 == null) {
            ArrayUtil.$$$reportNull$$$0(115);
        }
        return result2;
    }

    public static int find(int @NotNull [] src, int obj) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(118);
        }
        return ArrayUtil.indexOf(src, obj);
    }

    public static <T> int find(T @NotNull [] src, T obj) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(119);
        }
        return ArrayUtilRt.find(src, obj);
    }

    public static boolean startsWith(byte @NotNull [] array, byte @NotNull [] prefix) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(120);
        }
        if (prefix == null) {
            ArrayUtil.$$$reportNull$$$0(121);
        }
        if (array == prefix) {
            return true;
        }
        int length = prefix.length;
        if (array.length < length) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (array[i2] == prefix[i2]) continue;
            return false;
        }
        return true;
    }

    public static <T> void swap(T @NotNull [] array, int i1, int i2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(139);
        }
        T t2 = array[i1];
        array[i1] = array[i2];
        array[i2] = t2;
    }

    public static int indexOf(Object @NotNull [] objects, @Nullable Object object) {
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(145);
        }
        return ArrayUtilRt.indexOf(objects, object, 0, objects.length);
    }

    public static int indexOf(int @NotNull [] ints, int value2) {
        if (ints == null) {
            ArrayUtil.$$$reportNull$$$0(151);
        }
        for (int i2 = 0; i2 < ints.length; ++i2) {
            if (ints[i2] != value2) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOfNot(int @NotNull [] src, int obj) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(156);
        }
        for (int i2 = src.length - 1; i2 >= 0; --i2) {
            int o2 = src[i2];
            if (o2 == obj) continue;
            return i2;
        }
        return -1;
    }

    @SafeVarargs
    public static <T> boolean contains(@Nullable T o2, T ... objects) {
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(157);
        }
        return ArrayUtil.indexOf(objects, o2) >= 0;
    }

    public static boolean contains(@Nullable String s2, String ... strings2) {
        if (strings2 == null) {
            ArrayUtil.$$$reportNull$$$0(158);
        }
        return ArrayUtil.indexOf(strings2, s2) >= 0;
    }

    public static int @NotNull [] newIntArray(int count2) {
        return count2 == 0 ? ArrayUtilRt.EMPTY_INT_ARRAY : new int[count2];
    }

    public static byte @NotNull [] newByteArray(int count2) {
        return count2 == 0 ? ArrayUtilRt.EMPTY_BYTE_ARRAY : new byte[count2];
    }

    public static String @NotNull [] newStringArray(int count2) {
        return count2 == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : new String[count2];
    }

    public static Object @NotNull [] newObjectArray(int count2) {
        return count2 == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[count2];
    }

    public static <E> E @NotNull [] ensureExactSize(int count2, E @NotNull [] sample2) {
        if (sample2 == null) {
            ArrayUtil.$$$reportNull$$$0(159);
        }
        if (count2 == sample2.length) {
            if (sample2 == null) {
                ArrayUtil.$$$reportNull$$$0(160);
            }
            return sample2;
        }
        return ArrayUtil.newArray(ArrayUtil.getComponentType(sample2), count2);
    }

    public static String @NotNull [] toStringArray(@Nullable Collection<String> collection) {
        String[] stringArray = ArrayUtilRt.toStringArray(collection);
        if (stringArray == null) {
            ArrayUtil.$$$reportNull$$$0(161);
        }
        return stringArray;
    }

    public static <T> T @NotNull [] stripTrailingNulls(T @NotNull [] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(164);
        }
        T[] TArray = array.length != 0 && array[array.length - 1] == null ? Arrays.copyOf(array, ArrayUtil.trailingNullsIndex(array)) : array;
        if (TArray == null) {
            ArrayUtil.$$$reportNull$$$0(165);
        }
        return TArray;
    }

    private static <T> int trailingNullsIndex(T @NotNull [] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(166);
        }
        for (int i2 = array.length - 1; i2 >= 0; --i2) {
            if (array[i2] == null) continue;
            return i2 + 1;
        }
        return 0;
    }

    public static int max(int @NotNull [] values2) {
        if (values2 == null) {
            ArrayUtil.$$$reportNull$$$0(170);
        }
        int max = Integer.MIN_VALUE;
        for (int value2 : values2) {
            if (value2 <= max) continue;
            max = value2;
        }
        return max;
    }

    public static double max(double @NotNull [] values2) {
        if (values2 == null) {
            ArrayUtil.$$$reportNull$$$0(171);
        }
        double max = Double.NEGATIVE_INFINITY;
        for (double value2 : values2) {
            if (!(value2 > max)) continue;
            max = value2;
        }
        return max;
    }

    @NotNull
    public static <T> Class<T> getComponentType(T @NotNull [] collection) {
        if (collection == null) {
            ArrayUtil.$$$reportNull$$$0(174);
        }
        Class<?> clazz = collection.getClass().getComponentType();
        if (clazz == null) {
            ArrayUtil.$$$reportNull$$$0(175);
        }
        return clazz;
    }

    public static <T> int indexOfIdentity(T @NotNull [] array, T element) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(176);
        }
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] != element) continue;
            return i2;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 86: 
            case 91: 
            case 94: 
            case 96: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 109: 
            case 113: 
            case 115: 
            case 117: 
            case 130: 
            case 132: 
            case 160: 
            case 161: 
            case 165: 
            case 175: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 86: 
            case 91: 
            case 94: 
            case 96: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 109: 
            case 113: 
            case 115: 
            case 117: 
            case 130: 
            case 132: 
            case 160: 
            case 161: 
            case 165: 
            case 175: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 86: 
            case 91: 
            case 94: 
            case 96: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 109: 
            case 113: 
            case 115: 
            case 117: 
            case 130: 
            case 132: 
            case 160: 
            case 161: 
            case 165: 
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ArrayUtil";
                break;
            }
            case 18: 
            case 59: 
            case 61: 
            case 82: 
            case 92: 
            case 97: 
            case 107: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 42: 
            case 48: 
            case 81: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 52: 
            case 62: 
            case 67: 
            case 69: 
            case 74: 
            case 79: 
            case 127: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 53: 
            case 63: 
            case 68: 
            case 70: 
            case 75: 
            case 80: 
            case 128: 
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 87: 
            case 93: 
            case 98: 
            case 101: 
            case 103: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 116: 
            case 118: 
            case 119: 
            case 154: 
            case 155: 
            case 156: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 89: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 123: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subArray";
                break;
            }
            case 126: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 133: 
            case 135: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj1";
                break;
            }
            case 134: 
            case 136: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj2";
                break;
            }
            case 145: 
            case 146: 
            case 149: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 150: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ints";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 167: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
            case 169: 
            case 170: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalityCondition";
                break;
            }
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr1";
                break;
            }
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr2";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ArrayUtil";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "realloc";
                break;
            }
            case 24: 
            case 26: 
            case 36: 
            case 38: 
            case 99: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 28: 
            case 30: 
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "insert";
                break;
            }
            case 44: 
            case 47: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "toObjectArray";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "toIntArray";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeArrays";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeCollections";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeArrayAndCollection";
                break;
            }
            case 91: 
            case 94: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "prepend";
                break;
            }
            case 104: 
            case 109: 
            case 113: 
            case 115: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "newArray";
                break;
            }
            case 130: 
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseArray";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureExactSize";
                break;
            }
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringArray";
                break;
            }
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "stripTrailingNulls";
                break;
            }
            case 175: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "realloc";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 86: 
            case 91: 
            case 94: 
            case 96: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 109: 
            case 113: 
            case 115: 
            case 117: 
            case 130: 
            case 132: 
            case 160: 
            case 161: 
            case 165: 
            case 175: {
                break;
            }
            case 23: 
            case 25: 
            case 35: 
            case 37: 
            case 87: 
            case 97: 
            case 98: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 27: 
            case 29: 
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "toObjectArray";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "toIntArray";
                break;
            }
            case 52: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "mergeArrays";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "mergeCollections";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "mergeArrayAndCollection";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 103: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 114: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "newArray";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 129: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "reverseArray";
                break;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "lexicographicCompare";
                break;
            }
            case 139: 
            case 140: 
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "swap";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "rotateLeft";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "rotateRight";
                break;
            }
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfNot";
                break;
            }
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "ensureExactSize";
                break;
            }
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "stripTrailingNulls";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "trailingNullsIndex";
                break;
            }
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "averageAmongMedians";
                break;
            }
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "min";
                break;
            }
            case 170: 
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "max";
                break;
            }
            case 172: 
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "mergeSortedArrays";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "getComponentType";
                break;
            }
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIdentity";
                break;
            }
            case 177: 
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "areEqual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 86: 
            case 91: 
            case 94: 
            case 96: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 109: 
            case 113: 
            case 115: 
            case 117: 
            case 130: 
            case 132: 
            case 160: 
            case 161: 
            case 165: 
            case 175: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

