/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.serialization.FieldAccessor;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.PropertyAccessor;
import java.awt.Rectangle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyCollector {
    private final ClassValue<List<MutableAccessor>> classToOwnFields;
    private final Configuration configuration;

    public PropertyCollector(@NotNull Configuration configuration2) {
        if (configuration2 == null) {
            PropertyCollector.$$$reportNull$$$0(0);
        }
        this.configuration = configuration2;
        this.classToOwnFields = new PropertyCollectorListClassValue(configuration2);
    }

    @NotNull
    public List<MutableAccessor> collect(@NotNull Class<?> aClass) {
        if (aClass == null) {
            PropertyCollector.$$$reportNull$$$0(1);
        }
        return PropertyCollector.doCollect(aClass, this.configuration, this.classToOwnFields);
    }

    @NotNull
    public static List<MutableAccessor> doCollect(@NotNull Class<?> aClass, @NotNull Configuration configuration2, @Nullable ClassValue<List<MutableAccessor>> classToOwnFields) {
        if (aClass == null) {
            PropertyCollector.$$$reportNull$$$0(2);
        }
        if (configuration2 == null) {
            PropertyCollector.$$$reportNull$$$0(3);
        }
        ArrayList<MutableAccessor> accessors = new ArrayList<MutableAccessor>();
        Map<Object, Object> nameToAccessors = !configuration2.collectAccessors || aClass == Rectangle.class ? Collections.emptyMap() : PropertyCollector.collectPropertyAccessors(aClass, accessors, configuration2);
        int propertyAccessorCount = accessors.size();
        Class<?> currentClass = aClass;
        do {
            accessors.addAll(classToOwnFields == null ? PropertyCollector.doCollectOwnFields(currentClass, configuration2) : (Collection)classToOwnFields.get(currentClass));
        } while ((currentClass = currentClass.getSuperclass()) != null && currentClass != Object.class && currentClass != AtomicReference.class && !configuration2.isAnnotatedAsTransient(currentClass));
        block1: for (int j2 = propertyAccessorCount; j2 < accessors.size(); ++j2) {
            String name = ((MutableAccessor)accessors.get(j2)).getName();
            if (!nameToAccessors.containsKey(name)) continue;
            for (int i2 = 0; i2 < propertyAccessorCount; ++i2) {
                if (!((MutableAccessor)accessors.get(i2)).getName().equals(name)) continue;
                accessors.remove(i2);
                --propertyAccessorCount;
                --j2;
                continue block1;
            }
        }
        ArrayList<MutableAccessor> arrayList = accessors;
        if (arrayList == null) {
            PropertyCollector.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static Map<String, Pair<Method, Method>> collectPropertyAccessors(@NotNull Class<?> aClass, @NotNull List<? super MutableAccessor> accessors, @NotNull Configuration configuration2) {
        if (aClass == null) {
            PropertyCollector.$$$reportNull$$$0(5);
        }
        if (accessors == null) {
            PropertyCollector.$$$reportNull$$$0(6);
        }
        if (configuration2 == null) {
            PropertyCollector.$$$reportNull$$$0(7);
        }
        TreeMap<String, Pair<Method, Method>> candidates = new TreeMap<String, Pair<Method, Method>>();
        for (Method method : aClass.getMethods()) {
            NameAndIsSetter propertyData;
            if (!Modifier.isPublic(method.getModifiers()) || (propertyData = PropertyCollector.getPropertyData(method.getName())) == null || method.getParameterCount() != (propertyData.isSetter ? 1 : 0) || propertyData.name.equals("class")) continue;
            Couple<Object> candidate = (Couple)candidates.get(propertyData.name);
            if (candidate == null) {
                candidate = Couple.getEmpty();
            }
            if ((propertyData.isSetter ? (Method)candidate.second : (Method)candidate.first) != null) continue;
            candidate = new Couple<Method>(propertyData.isSetter ? (Method)candidate.first : method, propertyData.isSetter ? method : (Method)candidate.second);
            candidates.put(propertyData.name, candidate);
        }
        Iterator iterator2 = candidates.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry candidate = iterator2.next();
            Pair methods2 = (Pair)candidate.getValue();
            Method getter = (Method)methods2.first;
            Method setter = (Method)methods2.second;
            if (PropertyCollector.isAcceptableProperty(getter, setter, configuration2)) {
                accessors.add(new PropertyAccessor((String)candidate.getKey(), getter.getReturnType(), getter, setter));
                continue;
            }
            iterator2.remove();
        }
        TreeMap<String, Pair<Method, Method>> treeMap = candidates;
        if (treeMap == null) {
            PropertyCollector.$$$reportNull$$$0(8);
        }
        return treeMap;
    }

    @Nullable
    private static NameAndIsSetter getPropertyData(@NotNull String methodName) {
        if (methodName == null) {
            PropertyCollector.$$$reportNull$$$0(9);
        }
        String part = "";
        boolean isSetter = false;
        if (methodName.startsWith("get")) {
            part = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            part = methodName.substring(2);
        } else if (methodName.startsWith("set")) {
            part = methodName.substring(3);
            isSetter = true;
        }
        if (part.isEmpty()) {
            return null;
        }
        int suffixIndex = part.indexOf(36);
        if (suffixIndex > 0) {
            if (part.endsWith("$annotations")) {
                return null;
            }
            part = part.substring(0, suffixIndex);
        }
        return new NameAndIsSetter(PropertyCollector.decapitalize(part), isSetter);
    }

    @NotNull
    private static String decapitalize(@NotNull String name) {
        if (name == null) {
            PropertyCollector.$$$reportNull$$$0(10);
        }
        if (name.isEmpty() || name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            String string = name;
            if (string == null) {
                PropertyCollector.$$$reportNull$$$0(11);
            }
            return string;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(name.charAt(0));
        return new String(chars);
    }

    private static boolean isAcceptableProperty(@Nullable Method getter, @Nullable Method setter, @NotNull Configuration configuration2) {
        if (configuration2 == null) {
            PropertyCollector.$$$reportNull$$$0(12);
        }
        if (getter == null || configuration2.isAnnotatedAsTransient(getter)) {
            return false;
        }
        if (getter.getDeclaringClass() == AtomicReference.class) {
            return false;
        }
        if (setter == null) {
            return (Collection.class.isAssignableFrom(getter.getReturnType()) || Map.class.isAssignableFrom(getter.getReturnType())) && configuration2.hasStoreAnnotations(getter);
        }
        return !configuration2.isAnnotatedAsTransient(setter) && getter.getReturnType().equals(setter.getParameterTypes()[0]);
    }

    @NotNull
    private static List<MutableAccessor> doCollectOwnFields(@NotNull Class<?> type2, @NotNull Configuration configuration2) {
        if (type2 == null) {
            PropertyCollector.$$$reportNull$$$0(13);
        }
        if (configuration2 == null) {
            PropertyCollector.$$$reportNull$$$0(14);
        }
        ArrayList<FieldAccessor> result2 = null;
        for (Field field : type2.getDeclaredFields()) {
            Class<?> fieldType;
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || !configuration2.hasStoreAnnotations(field) && (!configuration2.collectPrivateFields && !Modifier.isPublic(modifiers) || !configuration2.collectFinalFields && Modifier.isFinal(modifiers) && !Collection.class.isAssignableFrom(fieldType = field.getType()) && !Map.class.isAssignableFrom(fieldType) || configuration2.isAnnotatedAsTransient(field))) continue;
            if (result2 == null) {
                result2 = new ArrayList<FieldAccessor>();
            }
            result2.add(new FieldAccessor(field));
        }
        List<MutableAccessor> list = result2 == null ? Collections.emptyList() : result2;
        if (list == null) {
            PropertyCollector.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/serialization/PropertyCollector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessors";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/serialization/PropertyCollector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doCollect";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPropertyAccessors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalize";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "doCollectOwnFields";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCollect";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 15: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectPropertyAccessors";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "decapitalize";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableProperty";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doCollectOwnFields";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Configuration {
        private final boolean collectAccessors;
        private final boolean collectPrivateFields;
        private final boolean collectFinalFields;

        public Configuration(boolean collectAccessors, boolean collectPrivateFields, boolean collectFinalFields) {
            this.collectAccessors = collectAccessors;
            this.collectPrivateFields = collectPrivateFields;
            this.collectFinalFields = collectFinalFields;
        }

        public boolean isAnnotatedAsTransient(@NotNull AnnotatedElement element) {
            if (element == null) {
                Configuration.$$$reportNull$$$0(0);
            }
            return false;
        }

        public boolean hasStoreAnnotations(@NotNull AccessibleObject element) {
            if (element == null) {
                Configuration.$$$reportNull$$$0(1);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/serialization/PropertyCollector$Configuration";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAnnotatedAsTransient";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasStoreAnnotations";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PropertyCollectorListClassValue
    extends ClassValue<List<MutableAccessor>> {
        @NotNull
        private final Configuration configuration;

        private PropertyCollectorListClassValue(@NotNull Configuration configuration2) {
            if (configuration2 == null) {
                PropertyCollectorListClassValue.$$$reportNull$$$0(0);
            }
            this.configuration = configuration2;
        }

        @Override
        protected List<MutableAccessor> computeValue(Class<?> type2) {
            return PropertyCollector.doCollectOwnFields(type2, this.configuration);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/serialization/PropertyCollector$PropertyCollectorListClassValue", "<init>"));
        }
    }

    private static final class NameAndIsSetter {
        final String name;
        final boolean isSetter;

        NameAndIsSetter(String name, boolean isSetter) {
            this.name = name;
            this.isSetter = isSetter;
        }
    }
}

