/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassUtil {
    private ClassUtil() {
    }

    @NotNull
    public static Class<?> typeToClass(@NotNull Type type2) {
        if (type2 == null) {
            ClassUtil.$$$reportNull$$$0(4);
        }
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            if (clazz == null) {
                ClassUtil.$$$reportNull$$$0(5);
            }
            return clazz;
        }
        if (type2 instanceof TypeVariable) {
            Type bound = ((TypeVariable)type2).getBounds()[0];
            Class clazz = bound instanceof Class ? (Class)bound : (Class)((ParameterizedType)bound).getRawType();
            if (clazz == null) {
                ClassUtil.$$$reportNull$$$0(6);
            }
            return clazz;
        }
        if (type2 instanceof WildcardType) {
            Class clazz = (Class)((WildcardType)type2).getUpperBounds()[0];
            if (clazz == null) {
                ClassUtil.$$$reportNull$$$0(7);
            }
            return clazz;
        }
        Class clazz = (Class)((ParameterizedType)type2).getRawType();
        if (clazz == null) {
            ClassUtil.$$$reportNull$$$0(8);
        }
        return clazz;
    }

    public static boolean isPrimitive(@NotNull Class<?> aClass) {
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(9);
        }
        return aClass.isPrimitive() || aClass == String.class || aClass == Integer.class || aClass == Long.class || aClass == Boolean.class || aClass == Double.class || aClass == Float.class || aClass.isEnum() || Date.class.isAssignableFrom(aClass);
    }

    public static boolean isMutableCollection(@NotNull Object object) {
        if (object == null) {
            ClassUtil.$$$reportNull$$$0(10);
        }
        if (object == Collections.emptyList() || object == Collections.emptySet()) {
            return false;
        }
        if (object instanceof Collection) {
            Class<?> aClass = object.getClass();
            String simpleName2 = aClass.getSimpleName();
            if (simpleName2.equals("EmptyList") || simpleName2.startsWith("Unmodifiable") || simpleName2.equals("EmptySet")) {
                return false;
            }
            String fullName = aClass.getName();
            if (fullName.equals("java.util.Arrays$ArrayList") || fullName.equals("java.util.Collections$SingletonList") || fullName.equals("java.util.Collections$SingletonSet")) {
                return false;
            }
            Class<?> declaringClass = aClass.getDeclaringClass();
            return declaringClass == null || !"ImmutableCollections".equals(declaringClass.getSimpleName());
        }
        return false;
    }

    public static boolean isMutableMap(@NotNull Map<?, ?> object) {
        if (object == null) {
            ClassUtil.$$$reportNull$$$0(11);
        }
        if (object == Collections.emptyMap()) {
            return false;
        }
        String simpleName2 = object.getClass().getSimpleName();
        return !simpleName2.equals("EmptyMap") && !simpleName2.equals("UnmodifiableMap") && !simpleName2.equals("ImmutableMap") && !simpleName2.equals("SingletonMap");
    }

    @Nullable
    public static Object stringToEnum(@NotNull String value2, @NotNull Class<? extends Enum<?>> valueClass, boolean isAlwaysIgnoreCase) {
        if (value2 == null) {
            ClassUtil.$$$reportNull$$$0(12);
        }
        if (valueClass == null) {
            ClassUtil.$$$reportNull$$$0(13);
        }
        Enum<?>[] enumConstants = valueClass.getEnumConstants();
        if (!isAlwaysIgnoreCase) {
            for (Enum<?> enumConstant : enumConstants) {
                if (!enumConstant.toString().equals(value2)) continue;
                return enumConstant;
            }
        }
        for (Enum<?> enumConstant : enumConstants) {
            if (!enumConstant.toString().equalsIgnoreCase(value2)) continue;
            return enumConstant;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/serialization/ClassUtil";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/serialization/ClassUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "typeToClass";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationToString";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRawType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "typeToClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitive";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMutableCollection";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMutableMap";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "stringToEnum";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveVariableInHierarchy";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveVariable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "declarationToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

