/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.CollectionFactory;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaResolveCache {
    private final AtomicReference<Map<PsiVariable, Object>> myVarToConstValueMapPhysical;
    private final AtomicReference<Map<PsiVariable, Object>> myVarToConstValueMapNonPhysical;
    private static final Object NULL = Key.create("NULL");

    public static JavaResolveCache getInstance(Project project) {
        return project.getService(JavaResolveCache.class);
    }

    public JavaResolveCache(@NotNull Project project) {
        if (project == null) {
            JavaResolveCache.$$$reportNull$$$0(0);
        }
        this.myVarToConstValueMapPhysical = new AtomicReference();
        this.myVarToConstValueMapNonPhysical = new AtomicReference();
        project.getMessageBus().connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                JavaResolveCache.this.clearCaches(isPhysical);
            }
        });
    }

    private void clearCaches(boolean isPhysical) {
        if (isPhysical) {
            this.myVarToConstValueMapPhysical.set(null);
        }
        this.myVarToConstValueMapNonPhysical.set(null);
    }

    @Nullable
    public <T extends PsiExpression> PsiType getType(@NotNull T expr, @NotNull Function<? super T, ? extends PsiType> f2) {
        boolean prohibitCaching;
        if (expr == null) {
            JavaResolveCache.$$$reportNull$$$0(1);
        }
        if (f2 == null) {
            JavaResolveCache.$$$reportNull$$$0(2);
        }
        boolean bl = prohibitCaching = MethodCandidateInfo.isOverloadCheck() && PsiPolyExpressionUtil.isPolyExpression(expr);
        if (prohibitCaching) {
            return f2.fun(expr);
        }
        return CachedValuesManager.getProjectPsiDependentCache(expr, param -> (PsiType)f2.fun(param));
    }

    @Nullable
    public Object computeConstantValueWithCaching(@NotNull PsiVariable variable, @NotNull ConstValueComputer computer, Set<PsiVariable> visitedVars) {
        Object cached;
        boolean physical;
        AtomicReference<Map<PsiVariable, Object>> ref;
        Map map2;
        if (variable == null) {
            JavaResolveCache.$$$reportNull$$$0(3);
        }
        if (computer == null) {
            JavaResolveCache.$$$reportNull$$$0(4);
        }
        if ((map2 = (ref = (physical = variable.isPhysical()) ? this.myVarToConstValueMapPhysical : this.myVarToConstValueMapNonPhysical).get()) == null) {
            map2 = ConcurrencyUtil.cacheOrGet(ref, CollectionFactory.createConcurrentWeakMap());
        }
        if ((cached = map2.get(variable)) == NULL) {
            return null;
        }
        if (cached != null) {
            return cached;
        }
        Object result2 = computer.execute(variable, visitedVars);
        map2.put(variable, result2 == null ? NULL : result2);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/resolve/JavaResolveCache";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeConstantValueWithCaching";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface ConstValueComputer {
        public Object execute(@NotNull PsiVariable var1, Set<PsiVariable> var2);
    }
}

