/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.light.LightParameter;
import com.intellij.psi.impl.light.LightParameterListBuilder;
import com.intellij.psi.impl.light.LightReferenceListBuilder;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassInnerStuffCache {
    private final PsiExtensibleClass myClass;
    private final Ref<Pair<Long, Interner<PsiMember>>> myInterner;

    public ClassInnerStuffCache(@NotNull PsiExtensibleClass aClass) {
        if (aClass == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(0);
        }
        this.myInterner = Ref.create();
        this.myClass = aClass;
    }

    public PsiMethod @NotNull [] getConstructors() {
        PsiMethod[] psiMethodArray = ClassInnerStuffCache.copy(CachedValuesManager.getProjectPsiDependentCache(this.myClass, PsiImplUtil::getConstructors));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(1);
        }
        return psiMethodArray;
    }

    public PsiField @NotNull [] getFields() {
        PsiField[] psiFieldArray = ClassInnerStuffCache.copy(CachedValuesManager.getProjectPsiDependentCache(this.myClass, __ -> this.calcFields()));
        if (psiFieldArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(2);
        }
        return psiFieldArray;
    }

    public PsiMethod @NotNull [] getMethods() {
        PsiMethod[] psiMethodArray = ClassInnerStuffCache.copy(CachedValuesManager.getProjectPsiDependentCache(this.myClass, __ -> this.calcMethods()));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(3);
        }
        return psiMethodArray;
    }

    public PsiClass @NotNull [] getInnerClasses() {
        PsiClass[] psiClassArray = ClassInnerStuffCache.copy(CachedValuesManager.getProjectPsiDependentCache(this.myClass, __ -> this.calcInnerClasses()));
        if (psiClassArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    public PsiRecordComponent @NotNull [] getRecordComponents() {
        PsiRecordComponent[] psiRecordComponentArray = ClassInnerStuffCache.copy(CachedValuesManager.getProjectPsiDependentCache(this.myClass, __ -> this.calcRecordComponents()));
        if (psiRecordComponentArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(5);
        }
        return psiRecordComponentArray;
    }

    @Nullable
    public PsiField findFieldByName(String name, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findFieldByName(this.myClass, name, true);
        }
        return (PsiField)CachedValuesManager.getProjectPsiDependentCache(this.myClass, __ -> this.getFieldsMap()).get(name);
    }

    public PsiMethod @NotNull [] findMethodsByName(String name, boolean checkBases) {
        if (checkBases) {
            PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsByName(this.myClass, name, true);
            if (psiMethodArray == null) {
                ClassInnerStuffCache.$$$reportNull$$$0(6);
            }
            return psiMethodArray;
        }
        PsiMethod[] psiMethodArray = ClassInnerStuffCache.copy(ObjectUtils.notNull((PsiMethod[])CachedValuesManager.getProjectPsiDependentCache(this.myClass, __ -> this.getMethodsMap()).get(name), PsiMethod.EMPTY_ARRAY));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(7);
        }
        return psiMethodArray;
    }

    @Nullable
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findInnerByName(this.myClass, name, true);
        }
        return (PsiClass)CachedValuesManager.getProjectPsiDependentCache(this.myClass, __ -> this.getInnerClassesMap()).get(name);
    }

    @Nullable
    PsiMethod getValuesMethod() {
        return this.myClass.isEnum() && !this.isAnonymousClass() && !this.classNameIsSealed() ? this.internMember(CachedValuesManager.getProjectPsiDependentCache(this.myClass, ClassInnerStuffCache::makeValuesMethod)) : null;
    }

    private boolean classNameIsSealed() {
        return "sealed".equals(this.myClass.getName()) && PsiUtil.isAvailable(JavaFeature.SEALED_CLASSES, this.myClass);
    }

    @Nullable
    private PsiMethod getValueOfMethod() {
        return this.myClass.isEnum() && !this.isAnonymousClass() ? this.internMember(CachedValuesManager.getProjectPsiDependentCache(this.myClass, ClassInnerStuffCache::makeValueOfMethod)) : null;
    }

    private boolean isAnonymousClass() {
        return this.myClass.getName() == null || this.myClass instanceof PsiAnonymousClass;
    }

    private static <T> T[] copy(T[] value2) {
        return value2.length == 0 ? value2 : (Object[])value2.clone();
    }

    private PsiField @NotNull [] calcFields() {
        List<PsiField> own = this.myClass.getOwnFields();
        List<PsiField> ext = this.internMembers(PsiAugmentProvider.collectAugments(this.myClass, PsiField.class, null));
        PsiField[] psiFieldArray = ArrayUtil.mergeCollections(own, ext, PsiField.ARRAY_FACTORY);
        if (psiFieldArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(8);
        }
        return psiFieldArray;
    }

    @NotNull
    private <T extends PsiMember> List<T> internMembers(List<T> members2) {
        List<PsiMember> list = ContainerUtil.map(members2, this::internMember);
        if (list == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(9);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends PsiMember> T internMember(T m2) {
        if (m2 == null) {
            return null;
        }
        long modCount = this.myClass.getManager().getModificationTracker().getModificationCount();
        Ref<Pair<Long, Interner<PsiMember>>> ref = this.myInterner;
        synchronized (ref) {
            Pair<Long, Interner<PsiMember>> pair = this.myInterner.get();
            if (pair == null || (Long)pair.first != modCount) {
                pair = Pair.create(modCount, Interner.createWeakInterner());
                this.myInterner.set(pair);
            }
            return ((Interner)pair.second).intern(m2);
        }
    }

    private PsiMethod @NotNull [] calcMethods() {
        List<PsiMethod> own = this.myClass.getOwnMethods();
        List<PsiMethod> ext = this.internMembers(PsiAugmentProvider.collectAugments(this.myClass, PsiMethod.class, null));
        if (this.myClass.isEnum()) {
            ext = new ArrayList<PsiMethod>(ext);
            ContainerUtil.addIfNotNull(ext, this.getValuesMethod());
            ContainerUtil.addIfNotNull(ext, this.getValueOfMethod());
        }
        PsiMethod[] psiMethodArray = ArrayUtil.mergeCollections(own, ext, PsiMethod.ARRAY_FACTORY);
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(10);
        }
        return psiMethodArray;
    }

    private PsiClass @NotNull [] calcInnerClasses() {
        List<PsiClass> own = this.myClass.getOwnInnerClasses();
        List<PsiClass> ext = this.internMembers(PsiAugmentProvider.collectAugments(this.myClass, PsiClass.class, null));
        PsiClass[] psiClassArray = ArrayUtil.mergeCollections(own, ext, PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(11);
        }
        return psiClassArray;
    }

    private PsiRecordComponent @NotNull [] calcRecordComponents() {
        PsiRecordHeader header = this.myClass.getRecordHeader();
        PsiRecordComponent[] psiRecordComponentArray = header == null ? PsiRecordComponent.EMPTY_ARRAY : header.getRecordComponents();
        if (psiRecordComponentArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(12);
        }
        return psiRecordComponentArray;
    }

    @NotNull
    private Map<String, PsiField> getFieldsMap() {
        HashMap<String, PsiField> cachedFields = new HashMap<String, PsiField>();
        for (PsiField field : this.myClass.getOwnFields()) {
            String name2 = field.getName();
            if (cachedFields.containsKey(name2)) continue;
            cachedFields.put(name2, field);
        }
        ConcurrentMap<String, PsiField> concurrentMap = ConcurrentFactoryMap.createMap(name -> {
            PsiField result2 = (PsiField)cachedFields.get(name);
            return result2 != null ? result2 : this.internMember(ContainerUtil.getFirstItem(PsiAugmentProvider.collectAugments(this.myClass, PsiField.class, name)));
        });
        if (concurrentMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(13);
        }
        return concurrentMap;
    }

    @NotNull
    private Map<String, PsiMethod[]> getMethodsMap() {
        List<PsiMethod> ownMethods = this.myClass.getOwnMethods();
        ConcurrentMap<String, PsiMethod[]> concurrentMap = ConcurrentFactoryMap.createMap(name -> JBIterable.from(ownMethods).filter(m2 -> name.equals(m2.getName())).append("values".equals(name) ? this.getValuesMethod() : null).append("valueOf".equals(name) ? this.getValueOfMethod() : null).append((PsiMethod)((Object)this.internMembers(PsiAugmentProvider.collectAugments(this.myClass, PsiMethod.class, name)))).toArray(PsiMethod.EMPTY_ARRAY));
        if (concurrentMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(14);
        }
        return concurrentMap;
    }

    @NotNull
    private Map<String, PsiClass> getInnerClassesMap() {
        HashMap<String, PsiClass> cachedInners = new HashMap<String, PsiClass>();
        for (PsiClass psiClass : this.myClass.getOwnInnerClasses()) {
            String name2 = psiClass.getName();
            if (name2 == null) {
                Logger.getInstance(ClassInnerStuffCache.class).error("getName() returned null for " + psiClass);
                continue;
            }
            if (psiClass instanceof ExternallyDefinedPsiElement && cachedInners.containsKey(name2)) continue;
            cachedInners.put(name2, psiClass);
        }
        ConcurrentMap<String, PsiClass> concurrentMap = ConcurrentFactoryMap.createMap(name -> {
            PsiClass result2 = (PsiClass)cachedInners.get(name);
            return result2 != null ? result2 : this.internMember(ContainerUtil.getFirstItem(PsiAugmentProvider.collectAugments(this.myClass, PsiClass.class, name)));
        });
        if (concurrentMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(15);
        }
        return concurrentMap;
    }

    private static PsiMethod makeValuesMethod(PsiExtensibleClass enumClass) {
        return new EnumSyntheticMethod(enumClass, EnumMethodKind.Values);
    }

    private static PsiMethod makeValueOfMethod(PsiExtensibleClass enumClass) {
        return new EnumSyntheticMethod(enumClass, EnumMethodKind.ValueOf);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/ClassInnerStuffCache";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/ClassInnerStuffCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordComponents";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFields";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "internMembers";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calcMethods";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInnerClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRecordComponents";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsMap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsMap";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClassesMap";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EnumSyntheticMethod
    extends LightElement
    implements PsiMethod,
    SyntheticElement {
        private final PsiClass myClass;
        private final EnumMethodKind myKind;
        private final PsiType myReturnType;
        private final LightParameterListBuilder myParameterList;
        private final LightModifierList myModifierList;

        EnumSyntheticMethod(@NotNull PsiClass enumClass, EnumMethodKind kind) {
            if (enumClass == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(0);
            }
            super(enumClass.getManager(), enumClass.getLanguage());
            this.myClass = enumClass;
            this.myKind = kind;
            this.myReturnType = this.createReturnType();
            this.myParameterList = this.createParameterList();
            this.myModifierList = this.createModifierList();
        }

        @Override
        public void accept(@NotNull PsiElementVisitor visitor2) {
            if (visitor2 == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(1);
            }
            if (visitor2 instanceof JavaElementVisitor) {
                ((JavaElementVisitor)visitor2).visitMethod(this);
            } else {
                visitor2.visitElement(this);
            }
        }

        @NotNull
        private PsiType createReturnType() {
            PsiClassType type2 = JavaPsiFacade.getElementFactory(this.getProject()).createType(this.myClass);
            if (this.myKind == EnumMethodKind.Values) {
                PsiArrayType psiArrayType = type2.createArrayType();
                if (psiArrayType == null) {
                    EnumSyntheticMethod.$$$reportNull$$$0(2);
                }
                return psiArrayType;
            }
            PsiClassType psiClassType = type2;
            if (psiClassType == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(3);
            }
            return psiClassType;
        }

        @NotNull
        private LightModifierList createModifierList() {
            return new LightModifierList(this.myManager, this.getLanguage(), new String[]{"public", "static"}){

                @Override
                public PsiElement getParent() {
                    return this;
                }
            };
        }

        @NotNull
        private LightParameterListBuilder createParameterList() {
            LightParameterListBuilder parameters2 = new LightParameterListBuilder(this.myManager, this.getLanguage());
            if (this.myKind == EnumMethodKind.ValueOf) {
                PsiClassType string = PsiType.getJavaLangString(this.myManager, GlobalSearchScope.allScope(this.getProject()));
                LightParameter parameter = new LightParameter("name", string, this, this.getLanguage(), false);
                parameters2.addParameter(parameter);
            }
            LightParameterListBuilder lightParameterListBuilder = parameters2;
            if (lightParameterListBuilder == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(4);
            }
            return lightParameterListBuilder;
        }

        @Override
        public int getTextOffset() {
            return this.myClass.getTextOffset();
        }

        @Override
        public String toString() {
            return null;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof EnumSyntheticMethod && this.myClass.equals(((EnumSyntheticMethod)another).myClass) && this.myKind == ((EnumSyntheticMethod)another).myKind;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myClass, this.myKind});
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }

        @Override
        @Nullable
        public PsiDocComment getDocComment() {
            return null;
        }

        @Override
        @Nullable
        public PsiClass getContainingClass() {
            return this.myClass;
        }

        @Override
        @Nullable
        public PsiType getReturnType() {
            return this.myReturnType;
        }

        @Override
        @Nullable
        public PsiTypeElement getReturnTypeElement() {
            return null;
        }

        @Override
        @NotNull
        public PsiParameterList getParameterList() {
            LightParameterListBuilder lightParameterListBuilder = this.myParameterList;
            if (lightParameterListBuilder == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(5);
            }
            return lightParameterListBuilder;
        }

        @Override
        @NotNull
        public PsiReferenceList getThrowsList() {
            LightReferenceListBuilder throwsList = new LightReferenceListBuilder(this.myManager, this.getLanguage(), PsiReferenceList.Role.THROWS_LIST);
            if (this.myKind == EnumMethodKind.ValueOf) {
                throwsList.addReference("java.lang.IllegalArgumentException");
            }
            LightReferenceListBuilder lightReferenceListBuilder = throwsList;
            if (lightReferenceListBuilder == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(6);
            }
            return lightReferenceListBuilder;
        }

        @Override
        @Nullable
        public PsiCodeBlock getBody() {
            return null;
        }

        @Override
        public boolean isConstructor() {
            return false;
        }

        @Override
        public boolean isVarArgs() {
            return false;
        }

        @Override
        @NotNull
        public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor2) {
            if (substitutor2 == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(7);
            }
            MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create(this, substitutor2);
            if (methodSignatureBackedByPsiMethod == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(8);
            }
            return methodSignatureBackedByPsiMethod;
        }

        @Override
        @Nullable
        public PsiIdentifier getNameIdentifier() {
            return new LightIdentifier(this.myManager, this.getName());
        }

        @Override
        @NotNull
        public String getName() {
            if (this.myKind == EnumMethodKind.ValueOf) {
                return "valueOf";
            }
            return "values";
        }

        @Override
        public PsiMethod @NotNull [] findSuperMethods() {
            PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(this);
            if (psiMethodArray == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(9);
            }
            return psiMethodArray;
        }

        @Override
        public PsiMethod @NotNull [] findSuperMethods(boolean checkAccess) {
            PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
            if (psiMethodArray == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(10);
            }
            return psiMethodArray;
        }

        @Override
        public PsiMethod @NotNull [] findSuperMethods(PsiClass parentClass) {
            PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
            if (psiMethodArray == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(11);
            }
            return psiMethodArray;
        }

        @Override
        @NotNull
        public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
            List<MethodSignatureBackedByPsiMethod> list = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic(this, checkAccess);
            if (list == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(12);
            }
            return list;
        }

        @Override
        @Nullable
        public PsiMethod findDeepestSuperMethod() {
            return PsiSuperMethodImplUtil.findDeepestSuperMethod(this);
        }

        @Override
        public PsiMethod @NotNull [] findDeepestSuperMethods() {
            if (PsiMethod.EMPTY_ARRAY == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(13);
            }
            return PsiMethod.EMPTY_ARRAY;
        }

        @Override
        @NotNull
        public PsiModifierList getModifierList() {
            LightModifierList lightModifierList = this.myModifierList;
            if (lightModifierList == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(14);
            }
            return lightModifierList;
        }

        @Override
        public boolean hasModifierProperty(@NotNull String name) {
            if (name == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(15);
            }
            return name.equals("public") || name.equals("static");
        }

        @Override
        public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(16);
            }
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public HierarchicalMethodSignature getHierarchicalMethodSignature() {
            HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(this);
            if (hierarchicalMethodSignature == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(17);
            }
            return hierarchicalMethodSignature;
        }

        @Override
        public boolean hasTypeParameters() {
            return false;
        }

        @Override
        @Nullable
        public PsiTypeParameterList getTypeParameterList() {
            return null;
        }

        @Override
        public PsiFile getContainingFile() {
            return this.myClass.getContainingFile();
        }

        @Override
        public PsiTypeParameter @NotNull [] getTypeParameters() {
            if (PsiTypeParameter.EMPTY_ARRAY == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(18);
            }
            return PsiTypeParameter.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 17: 
                case 18: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 17: 
                case 18: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/ClassInnerStuffCache$EnumSyntheticMethod";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutor";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/ClassInnerStuffCache$EnumSyntheticMethod";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReturnType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createParameterList";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameterList";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThrowsList";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSignature";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findSuperMethods";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findSuperMethodSignaturesIncludingStatic";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findDeepestSuperMethods";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModifierList";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHierarchicalMethodSignature";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeParameters";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 17: 
                case 18: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getSignature";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "hasModifierProperty";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 17: 
                case 18: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum EnumMethodKind {
        ValueOf,
        Values;

    }
}

