/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.PsiField;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.BitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFieldStubImpl
extends StubBase<PsiField>
implements PsiFieldStub {
    private final String myName;
    private final TypeInfo myType;
    private final String myInitializer;
    private final byte myFlags;

    public PsiFieldStubImpl(StubElement parent2, @Nullable String name, @NotNull TypeInfo type2, @Nullable String initializer, byte flags) {
        if (type2 == null) {
            PsiFieldStubImpl.$$$reportNull$$$0(0);
        }
        super(parent2, PsiFieldStubImpl.isEnumConst(flags) ? JavaStubElementTypes.ENUM_CONSTANT : JavaStubElementTypes.FIELD);
        this.myName = name;
        this.myType = type2;
        this.myInitializer = initializer;
        this.myFlags = flags;
    }

    public byte getFlags() {
        return this.myFlags;
    }

    @Override
    @NotNull
    public TypeInfo getType() {
        TypeInfo typeInfo = this.myType;
        if (typeInfo == null) {
            PsiFieldStubImpl.$$$reportNull$$$0(1);
        }
        return typeInfo;
    }

    @Override
    public String getInitializerText() {
        return this.myInitializer;
    }

    @Override
    public boolean isEnumConstant() {
        return PsiFieldStubImpl.isEnumConst(this.myFlags);
    }

    private static boolean isEnumConst(byte flags) {
        return BitUtil.isSet(flags, (byte)1);
    }

    @Override
    public boolean isDeprecated() {
        return BitUtil.isSet(this.myFlags, (byte)2);
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return BitUtil.isSet(this.myFlags, (byte)4);
    }

    @Override
    public boolean hasDocComment() {
        return BitUtil.isSet(this.myFlags, (byte)8);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public static byte packFlags(boolean isEnumConst, boolean isDeprecated, boolean hasDeprecatedAnnotation, boolean hasDocComment) {
        byte flags = 0;
        if (isEnumConst) {
            flags = (byte)(flags | 1);
        }
        if (isDeprecated) {
            flags = (byte)(flags | 2);
        }
        if (hasDeprecatedAnnotation) {
            flags = (byte)(flags | 4);
        }
        if (hasDocComment) {
            flags = (byte)(flags | 8);
        }
        return flags;
    }

    @Override
    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("PsiFieldStub[");
        if (this.isDeprecated() || this.hasDeprecatedAnnotation()) {
            builder2.append("deprecated ");
        }
        if (this.isEnumConstant()) {
            builder2.append("enumconst ");
        }
        builder2.append(this.myName).append(':').append(this.myType);
        if (this.myInitializer != null) {
            builder2.append('=').append(this.myInitializer);
        }
        builder2.append(']');
        return builder2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/impl/PsiFieldStubImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/impl/PsiFieldStubImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

