/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.WalkingState;
import org.jetbrains.annotations.NotNull;

public abstract class PsiWalkingState
extends WalkingState<PsiElement> {
    private static final Logger LOG = Logger.getInstance(PsiWalkingState.class);
    private final PsiElementVisitor myVisitor;

    public static boolean processAll(@NotNull PsiElement root, @NotNull Processor<? super PsiElement> processor) {
        if (root == null) {
            PsiWalkingState.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            PsiWalkingState.$$$reportNull$$$0(1);
        }
        return PsiWalkingState.processAll(root, PsiTreeGuide.instance, processor);
    }

    protected PsiWalkingState(@NotNull PsiElementVisitor delegate) {
        if (delegate == null) {
            PsiWalkingState.$$$reportNull$$$0(2);
        }
        this(delegate, PsiTreeGuide.instance);
    }

    protected PsiWalkingState(@NotNull PsiElementVisitor delegate, @NotNull WalkingState.TreeGuide<PsiElement> guide) {
        if (delegate == null) {
            PsiWalkingState.$$$reportNull$$$0(3);
        }
        if (guide == null) {
            PsiWalkingState.$$$reportNull$$$0(4);
        }
        super(guide);
        this.myVisitor = delegate;
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            PsiWalkingState.$$$reportNull$$$0(5);
        }
        element.accept(this.myVisitor);
    }

    @Override
    public void elementStarted(@NotNull PsiElement element) {
        if (element == null) {
            PsiWalkingState.$$$reportNull$$$0(6);
        }
        if (!this.startedWalking && element instanceof PsiCompiledElement) {
            LOG.error(element + "; of class:" + element.getClass() + "; Do not use walking visitor inside compiled PSI since getNextSibling() is too slow there");
        }
        super.elementStarted(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guide";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/PsiWalkingState";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processAll";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "elementStarted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PsiTreeGuide
    implements WalkingState.TreeGuide<PsiElement> {
        public static final PsiTreeGuide instance = new PsiTreeGuide();

        private PsiTreeGuide() {
        }

        @Override
        public PsiElement getNextSibling(@NotNull PsiElement element) {
            if (element == null) {
                PsiTreeGuide.$$$reportNull$$$0(0);
            }
            return PsiTreeGuide.checkSanity(element, element.getNextSibling());
        }

        private static PsiElement checkSanity(PsiElement element, PsiElement sibling) {
            if (sibling == PsiUtilCore.NULL_PSI_ELEMENT) {
                throw new PsiInvalidElementAccessException(element, "Sibling of " + element + " is NULL_PSI_ELEMENT");
            }
            return sibling;
        }

        @Override
        public PsiElement getPrevSibling(@NotNull PsiElement element) {
            if (element == null) {
                PsiTreeGuide.$$$reportNull$$$0(1);
            }
            return PsiTreeGuide.checkSanity(element, element.getPrevSibling());
        }

        @Override
        public PsiElement getFirstChild(@NotNull PsiElement element) {
            if (element == null) {
                PsiTreeGuide.$$$reportNull$$$0(2);
            }
            return element.getFirstChild();
        }

        @Override
        public PsiElement getParent(@NotNull PsiElement element) {
            if (element == null) {
                PsiTreeGuide.$$$reportNull$$$0(3);
            }
            return element.getParent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/psi/PsiWalkingState$PsiTreeGuide";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNextSibling";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPrevSibling";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstChild";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getParent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

