/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiDiamondType
extends PsiType {
    public static final RecursionGuard<PsiElement> ourDiamondGuard = RecursionManager.createGuard("diamondInference");

    public PsiDiamondType() {
        super(TypeAnnotationProvider.EMPTY);
    }

    public abstract DiamondInferenceResult resolveInferredTypes();

    public static boolean hasDiamond(PsiNewExpression expression) {
        return PsiDiamondType.getDiamondType(expression) != null;
    }

    public static PsiDiamondType getDiamondType(PsiNewExpression expression) {
        PsiTypeElement[] parameterElements;
        PsiReferenceParameterList parameterList2;
        PsiJavaCodeReferenceElement classReference;
        if (PsiUtil.isLanguageLevel7OrHigher(expression) && (classReference = expression.getClassOrAnonymousClassReference()) != null && (parameterList2 = classReference.getParameterList()) != null && (parameterElements = parameterList2.getTypeParameterElements()).length == 1) {
            PsiType type2 = parameterElements[0].getType();
            return type2 instanceof PsiDiamondType ? (PsiDiamondType)type2 : null;
        }
        return null;
    }

    public static JavaResolveResult getDiamondsAwareResolveResult(PsiCall expression) {
        PsiDiamondType diamondType;
        if (expression instanceof PsiNewExpression && (diamondType = PsiDiamondType.getDiamondType((PsiNewExpression)expression)) != null) {
            JavaResolveResult factory2 = diamondType.getStaticFactory();
            return factory2 != null ? factory2 : JavaResolveResult.EMPTY;
        }
        if (expression instanceof PsiEnumConstant) {
            PsiEnumConstant enumConstant = (PsiEnumConstant)expression;
            PsiClass containingClass = enumConstant.getContainingClass();
            if (containingClass == null) {
                return JavaResolveResult.EMPTY;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance(enumConstant.getProject());
            PsiClassType type2 = facade.getElementFactory().createType(containingClass);
            PsiExpressionList argumentList = enumConstant.getArgumentList();
            if (argumentList == null) {
                return JavaResolveResult.EMPTY;
            }
            return facade.getResolveHelper().resolveConstructor(type2, argumentList, enumConstant);
        }
        return expression.resolveMethodGenerics();
    }

    @Nullable
    public abstract JavaResolveResult getStaticFactory();

    public static class DiamondInferenceResult {
        public static final DiamondInferenceResult EXPLICIT_CONSTRUCTOR_TYPE_ARGS = new DiamondInferenceResult(){

            @Override
            public PsiType @NotNull [] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return JavaPsiBundle.message("diamond.error.explicit.type.parameters.for.constructor", new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondType$DiamondInferenceResult$1", "getTypes"));
            }
        };
        public static final DiamondInferenceResult NULL_RESULT = new DiamondInferenceResult(){

            @Override
            public PsiType @NotNull [] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    2.$$$reportNull$$$0(0);
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return JavaPsiBundle.message("diamond.error.cannot.infer.arguments", new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondType$DiamondInferenceResult$2", "getTypes"));
            }
        };
        public static final DiamondInferenceResult RAW_RESULT = new DiamondInferenceResult(){

            @Override
            public PsiType @NotNull [] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    3.$$$reportNull$$$0(0);
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondType$DiamondInferenceResult$3", "getTypes"));
            }
        };
        public static final DiamondInferenceResult UNRESOLVED_CONSTRUCTOR = new DiamondInferenceResult(){

            @Override
            public PsiType @NotNull [] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    4.$$$reportNull$$$0(0);
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return JavaPsiBundle.message("diamond.error.cannot.infer.arguments.unable.to.resolve.constructor", new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondType$DiamondInferenceResult$4", "getTypes"));
            }
        };
        public static final DiamondInferenceResult ANONYMOUS_INNER_RESULT = new DiamondInferenceResult(){

            @Override
            public PsiType @NotNull [] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    5.$$$reportNull$$$0(0);
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return JavaPsiBundle.message("diamond.error.anonymous.inner.classes", new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondType$DiamondInferenceResult$5", "getTypes"));
            }
        };
        private final List<PsiType> myInferredTypes = new ArrayList<PsiType>();
        private String myErrorMessage;
        private String myNewExpressionPresentableText;

        public DiamondInferenceResult() {
        }

        public DiamondInferenceResult(String expressionPresentableText) {
            this.myNewExpressionPresentableText = expressionPresentableText;
        }

        public PsiType @NotNull [] getTypes() {
            PsiType[] psiTypeArray = this.myErrorMessage == null ? this.myInferredTypes.toArray(PsiType.createArray(this.myInferredTypes.size())) : PsiType.EMPTY_ARRAY;
            if (psiTypeArray == null) {
                DiamondInferenceResult.$$$reportNull$$$0(0);
            }
            return psiTypeArray;
        }

        public List<PsiType> getInferredTypes() {
            return this.myInferredTypes;
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public boolean failedToInfer() {
            return this.myErrorMessage != null;
        }

        protected void addInferredType(PsiType psiType) {
            if (this.myErrorMessage != null) {
                return;
            }
            if (psiType == null) {
                this.myErrorMessage = JavaPsiBundle.message("diamond.error.cannot.infer.type.arguments", this.myNewExpressionPresentableText);
            } else {
                this.myInferredTypes.add(psiType);
            }
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            DiamondInferenceResult that = (DiamondInferenceResult)o2;
            if (this.myErrorMessage != null ? !this.myErrorMessage.equals(that.myErrorMessage) : that.myErrorMessage != null) {
                return false;
            }
            return this.myInferredTypes.equals(that.myInferredTypes);
        }

        public int hashCode() {
            int result2 = this.myInferredTypes.hashCode();
            result2 = 31 * result2 + (this.myErrorMessage != null ? this.myErrorMessage.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiDiamondType$DiamondInferenceResult", "getTypes"));
        }
    }
}

