/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PatternCondition<T> {
    private static final Logger LOG = Logger.getInstance(PatternCondition.class);
    private final String myDebugMethodName;

    public PatternCondition(@Nullable String debugMethodName) {
        this.myDebugMethodName = debugMethodName;
    }

    private static void appendValue(StringBuilder builder2, String indent, Object obj) {
        if (obj instanceof ElementPattern) {
            ((ElementPattern)obj).getCondition().append(builder2, indent + "  ");
        } else if (obj instanceof Object[]) {
            PatternCondition.appendArray(builder2, indent, (Object[])obj);
        } else if (obj instanceof Collection) {
            PatternCondition.appendArray(builder2, indent, ((Collection)obj).toArray());
        } else if (obj instanceof String) {
            builder2.append('\"').append(obj).append('\"');
        } else {
            builder2.append(obj);
        }
    }

    protected static void appendArray(StringBuilder builder2, String indent, Object[] objects) {
        builder2.append("[");
        boolean first2 = true;
        for (Object o2 : objects) {
            if (!first2) {
                builder2.append(", ");
            }
            first2 = false;
            PatternCondition.appendValue(builder2, indent, o2);
        }
        builder2.append("]");
    }

    public abstract boolean accepts(@NotNull T var1, ProcessingContext var2);

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        this.append(builder2, "");
        return builder2.toString();
    }

    public void append(StringBuilder builder2, String indent) {
        builder2.append(this.myDebugMethodName);
        builder2.append("(");
        this.appendParams(builder2, indent);
        builder2.append(")");
    }

    private void appendParams(final StringBuilder builder2, final String indent) {
        this.processParameters((PairProcessor<String, Object>)new PairProcessor<String, Object>(){
            int count;
            String prevName;
            int prevOffset;

            @Override
            public boolean process(String name, Object value2) {
                ++this.count;
                if (this.count == 2) {
                    builder2.insert(this.prevOffset, this.prevName + "=");
                }
                if (this.count > 1) {
                    builder2.append(", ");
                }
                this.prevOffset = builder2.length();
                if (this.count > 1) {
                    builder2.append(name).append("=");
                }
                PatternCondition.appendValue(builder2, indent, value2);
                this.prevName = name;
                return true;
            }
        });
    }

    public boolean processParameters(PairProcessor<? super String, Object> processor) {
        for (Class<?> aClass = this.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                Object value2;
                String name;
                String fixedName;
                if (Modifier.isStatic(field.getModifiers()) || (field.isSynthetic() || aClass.equals(PatternCondition.class)) && !field.getName().startsWith("val$") || processor.process(fixedName = (name = field.getName()).startsWith("val$") ? name.substring("val$".length()) : name, value2 = this.getFieldValue(field))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFieldValue(Field field) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException e2) {
            LOG.error(e2);
        }
        finally {
            field.setAccessible(accessible);
        }
        return null;
    }
}

