/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.util.io.URLUtil;
import com.intellij.util.messages.Topic;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileManager
implements ModificationTracker {
    public static final Topic<BulkFileListener> VFS_CHANGES = new Topic<BulkFileListener>(BulkFileListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN, true);
    @NotNull
    public static final ModificationTracker VFS_STRUCTURE_MODIFICATIONS = () -> VirtualFileManager.getInstance().getStructureModificationCount();
    private static final Supplier<VirtualFileManager> ourInstance = CachedSingletonsRegistry.lazy(() -> ApplicationManager.getApplication().getService(VirtualFileManager.class));

    @NotNull
    public static VirtualFileManager getInstance() {
        VirtualFileManager virtualFileManager = ourInstance.get();
        if (virtualFileManager == null) {
            VirtualFileManager.$$$reportNull$$$0(0);
        }
        return virtualFileManager;
    }

    public abstract VirtualFileSystem getFileSystem(@Nullable String var1);

    @Nullable
    public VirtualFile findFileByUrl(@NotNull String url) {
        if (url == null) {
            VirtualFileManager.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    public VirtualFile findFileByNioPath(@NotNull Path path) {
        if (path == null) {
            VirtualFileManager.$$$reportNull$$$0(2);
        }
        return null;
    }

    @NotNull
    public static String constructUrl(@NotNull String protocol, @NotNull String path) {
        if (protocol == null) {
            VirtualFileManager.$$$reportNull$$$0(5);
        }
        if (path == null) {
            VirtualFileManager.$$$reportNull$$$0(6);
        }
        String string = protocol + "://" + path;
        if (string == null) {
            VirtualFileManager.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String extractPath(@NotNull String url) {
        if (url == null) {
            VirtualFileManager.$$$reportNull$$$0(9);
        }
        String string = URLUtil.extractPath(url);
        if (string == null) {
            VirtualFileManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    public abstract void notifyPropertyChanged(@NotNull VirtualFile var1, @NotNull String var2, Object var3, Object var4);

    public abstract long getStructureModificationCount();

    public VirtualFile findFileById(int id) {
        return null;
    }

    @NotNull
    public abstract CharSequence getVFileName(int var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/VirtualFileManager";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/VirtualFileManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "constructUrl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPath";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileByUrl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findFileByNioPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByUrl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByNioPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "constructUrl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extractProtocol";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

