/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShutDownTracker {
    private final Deque<Runnable> myShutdownTasks = new ConcurrentLinkedDeque<Runnable>();
    private final Deque<Runnable> myCachesShutdownTasks = new ConcurrentLinkedDeque<Runnable>();
    private final Thread myThread = new Thread(() -> this.run(), "Shutdown tracker");

    private ShutDownTracker() {
        Runtime.getRuntime().addShutdownHook(this.myThread);
    }

    @NotNull
    public static ShutDownTracker getInstance() {
        ShutDownTracker shutDownTracker = ShutDownTrackerHolder.ourInstance;
        if (shutDownTracker == null) {
            ShutDownTracker.$$$reportNull$$$0(0);
        }
        return shutDownTracker;
    }

    public static boolean isShutdownHookRunning() {
        return ShutDownTracker.getInstance().myThread.isAlive();
    }

    public void run() {
        Runnable task;
        while ((task = this.getNextTask()) != null) {
            try {
                task.run();
            }
            catch (Throwable e2) {
                try {
                    Logger.getInstance(ShutDownTracker.class).error(e2);
                }
                catch (AssertionError assertionError) {}
            }
        }
    }

    @Nullable
    private Runnable getNextTask() {
        Runnable task = this.myCachesShutdownTasks.pollLast();
        if (task != null) {
            return task;
        }
        return this.myShutdownTasks.pollLast();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/ShutDownTracker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/ShutDownTracker";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "waitFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerShutdownTask";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unregisterShutdownTask";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerCacheShutdownTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ShutDownTrackerHolder {
        private static final ShutDownTracker ourInstance = new ShutDownTracker();
    }
}

