/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.WeakList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public final class LowMemoryWatcher {
    private static final Logger LOG = Logger.getInstance(LowMemoryWatcher.class);
    private static final WeakList<LowMemoryWatcher> ourListeners = new WeakList();
    private final Runnable myRunnable;
    private final LowMemoryWatcherType myType;
    private static final AtomicBoolean ourNotificationsSuppressed = new AtomicBoolean();

    public static void onLowMemorySignalReceived(boolean afterGc) {
        LOG.info("Low memory signal received: afterGc=" + afterGc);
        for (LowMemoryWatcher watcher : ourListeners.toStrongList()) {
            try {
                if (watcher.myType != LowMemoryWatcherType.ALWAYS && (watcher.myType != LowMemoryWatcherType.ONLY_AFTER_GC || !afterGc)) continue;
                watcher.myRunnable.run();
            }
            catch (Throwable e2) {
                LOG.info(e2);
            }
        }
    }

    static boolean notificationsSuppressed() {
        return ourNotificationsSuppressed.get();
    }

    public static LowMemoryWatcher register(@NotNull Runnable runnable) {
        if (runnable == null) {
            LowMemoryWatcher.$$$reportNull$$$0(2);
        }
        return new LowMemoryWatcher(runnable, LowMemoryWatcherType.ALWAYS);
    }

    public static void register(@NotNull Runnable runnable, @NotNull LowMemoryWatcherType notificationType, @NotNull Disposable parentDisposable) {
        if (runnable == null) {
            LowMemoryWatcher.$$$reportNull$$$0(3);
        }
        if (notificationType == null) {
            LowMemoryWatcher.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            LowMemoryWatcher.$$$reportNull$$$0(5);
        }
        LowMemoryWatcher watcher = new LowMemoryWatcher(runnable, notificationType);
        Disposer.register(parentDisposable, () -> watcher.stop());
    }

    public static void register(@NotNull Runnable runnable, @NotNull Disposable parentDisposable) {
        if (runnable == null) {
            LowMemoryWatcher.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            LowMemoryWatcher.$$$reportNull$$$0(7);
        }
        LowMemoryWatcher.register(runnable, LowMemoryWatcherType.ALWAYS, parentDisposable);
    }

    private LowMemoryWatcher(@NotNull Runnable runnable, @NotNull LowMemoryWatcherType type2) {
        if (runnable == null) {
            LowMemoryWatcher.$$$reportNull$$$0(8);
        }
        if (type2 == null) {
            LowMemoryWatcher.$$$reportNull$$$0(9);
        }
        this.myRunnable = runnable;
        this.myType = type2;
        ourListeners.add(this);
    }

    public void stop() {
        ourListeners.remove(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationType";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/LowMemoryWatcher";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum LowMemoryWatcherType {
        ALWAYS,
        ONLY_AFTER_GC;

    }
}

