/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.util.concurrency.ThreadingAssertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileDocumentManager {
    @NotNull
    public static FileDocumentManager getInstance() {
        FileDocumentManager fileDocumentManager = ApplicationManager.getApplication().getService(FileDocumentManager.class);
        if (fileDocumentManager == null) {
            FileDocumentManager.$$$reportNull$$$0(0);
        }
        return fileDocumentManager;
    }

    @Nullable
    public abstract Document getDocument(@NotNull VirtualFile var1);

    @Nullable
    public Document getDocument(@NotNull VirtualFile file, @NotNull Project preferredProject) {
        if (file == null) {
            FileDocumentManager.$$$reportNull$$$0(1);
        }
        if (preferredProject == null) {
            FileDocumentManager.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.softAssertReadAccess();
        try (AccessToken ignored = ProjectLocator.withPreferredProject(file, preferredProject);){
            Document document = this.getDocument(file);
            return document;
        }
    }

    @Nullable
    public abstract Document getCachedDocument(@NotNull VirtualFile var1);

    @Nullable
    public abstract VirtualFile getFile(@NotNull Document var1);

    public abstract void saveDocument(@NotNull Document var1);

    public abstract void saveDocumentAsIs(@NotNull Document var1);

    public abstract boolean isDocumentUnsaved(@NotNull Document var1);

    public abstract void reloadFromDisk(@NotNull Document var1, @Nullable Project var2);

    @NotNull
    public abstract String getLineSeparator(@Nullable VirtualFile var1, @Nullable Project var2);

    public void reloadBinaryFiles() {
    }

    @Nullable
    public FileViewProvider findCachedPsiInAnyProject(@NotNull VirtualFile file) {
        if (file == null) {
            FileDocumentManager.$$$reportNull$$$0(8);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/FileDocumentManager";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredProject";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/FileDocumentManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWritingStatus";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requestWritingStatus";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fileForDocumentCheckedOutSuccessfully";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCachedPsiInAnyProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

